/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.remoting;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.springframework.remoting.support.RemoteInvocation;

public class ObjectToRemoteInvocationTransformer
extends AbstractTransformer {
    public ObjectToRemoteInvocationTransformer() {
        this.registerSourceType(DataTypeFactory.create(RemoteInvocation.class));
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.registerSourceType(DataTypeFactory.INPUT_STREAM);
        this.setReturnDataType(DataTypeFactory.create(RemoteInvocation.class));
    }

    protected Object doTransform(Object src, String encoding) throws TransformerException {
        if (src instanceof RemoteInvocation) {
            return src;
        }
        Object o = null;
        if (src instanceof InputStream) {
            try {
                o = new ObjectInputStream((InputStream)src).readObject();
            }
            catch (Exception e) {
                throw new TransformerException((Transformer)this, (Throwable)e);
            }
        }
        byte[] data = (byte[])src;
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            o = ois.readObject();
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
        RemoteInvocation ri = (RemoteInvocation)o;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("request to execute " + ri.getMethodName()));
            for (int i = 0; i < ri.getArguments().length; ++i) {
                Object currentArgument = ri.getArguments()[i];
                StringBuilder buf = new StringBuilder(64);
                buf.append("with argument (");
                buf.append(currentArgument == null ? "<null>" : currentArgument.toString());
                buf.append(")");
                this.logger.debug((Object)buf);
            }
        }
        return ri;
    }
}

