/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.parsers.specific;

import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.config.spring.parsers.assembly.BeanAssembler;
import org.mule.runtime.config.spring.parsers.assembly.BeanAssemblerFactory;
import org.mule.runtime.config.spring.parsers.assembly.DefaultBeanAssembler;
import org.mule.runtime.config.spring.parsers.assembly.configuration.PropertyConfiguration;
import org.mule.runtime.config.spring.parsers.collection.ChildMapEntryDefinitionParser;
import org.mule.runtime.config.spring.parsers.specific.DataTypeFactoryBean;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;

public class TypedPropertyMapEntryDefinitionParser
extends ChildMapEntryDefinitionParser {
    public TypedPropertyMapEntryDefinitionParser(String mapName) {
        super(mapName);
        this.setBeanAssemblerFactory(new TypedPropertyMapEntryBeanAssemblerFactory());
    }

    private static class TypedPropertyMapEntryBeanAssembler
    extends DefaultBeanAssembler {
        public static final String VALUE_REF = "value-ref";

        public TypedPropertyMapEntryBeanAssembler(PropertyConfiguration beanConfig, BeanDefinitionBuilder bean, PropertyConfiguration targetConfig, BeanDefinition target) {
            super(beanConfig, bean, targetConfig, target);
        }

        @Override
        public void insertBeanInTarget(String oldName) {
            this.assertTargetPresent();
            MutablePropertyValues sourceProperties = this.bean.getRawBeanDefinition().getPropertyValues();
            String newName = TypedPropertyMapEntryBeanAssembler.bestGuessName(this.targetConfig, oldName, this.target.getBeanClassName());
            MutablePropertyValues targetProperties = this.target.getPropertyValues();
            PropertyValue propertyValue = targetProperties.getPropertyValue(newName);
            ManagedMap propertiesMap = (ManagedMap)(null == propertyValue ? null : propertyValue.getValue());
            if (propertiesMap == null) {
                propertiesMap = new ManagedMap();
                propertyValue = new PropertyValue(newName, (Object)propertiesMap);
                targetProperties.addPropertyValue(propertyValue);
            }
            PropertyValue propertyKey = sourceProperties.getPropertyValue("key");
            AbstractBeanDefinition typedValueBeanDefinition = this.getTypedValue((PropertyValues)sourceProperties);
            propertiesMap.put((Object)((String)propertyKey.getValue()), (Object)typedValueBeanDefinition);
        }

        private AbstractBeanDefinition getTypedValue(PropertyValues sourceProperties) {
            AbstractBeanDefinition dataType = DataTypeFactoryBean.buildDataTypeDefinition(Object.class.getName(), sourceProperties);
            BeanDefinitionBuilder typedValueBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition(TypedValue.class);
            if (sourceProperties.contains(VALUE_REF)) {
                String valueRef = (String)sourceProperties.getPropertyValue(VALUE_REF).getValue();
                typedValueBeanDefinition.addConstructorArgReference(valueRef);
            } else {
                Object value = sourceProperties.getPropertyValue("value").getValue();
                typedValueBeanDefinition.addConstructorArgValue(value);
            }
            typedValueBeanDefinition.addConstructorArgValue((Object)dataType);
            return typedValueBeanDefinition.getBeanDefinition();
        }
    }

    private static class TypedPropertyMapEntryBeanAssemblerFactory
    implements BeanAssemblerFactory {
        private TypedPropertyMapEntryBeanAssemblerFactory() {
        }

        @Override
        public BeanAssembler newBeanAssembler(PropertyConfiguration beanConfig, BeanDefinitionBuilder bean, PropertyConfiguration targetConfig, BeanDefinition target) {
            return new TypedPropertyMapEntryBeanAssembler(beanConfig, bean, targetConfig, target);
        }
    }
}

