/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.factories;

import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.AbstractAnnotatedObject;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.exception.MessagingExceptionHandlerAware;
import org.mule.runtime.core.api.processor.MessageProcessorBuilder;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.transaction.TransactionFactory;
import org.mule.runtime.core.api.transaction.TypedTransactionFactory;
import org.mule.runtime.core.processor.TransactionalInterceptingMessageProcessor;
import org.mule.runtime.core.processor.chain.AbstractMessageProcessorChain;
import org.mule.runtime.core.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.transaction.MuleTransactionConfig;
import org.mule.runtime.core.transaction.TransactionType;
import org.springframework.beans.factory.FactoryBean;

public class BlockMessageProcessorFactoryBean
extends AbstractAnnotatedObject
implements FactoryBean,
MuleContextAware {
    protected List messageProcessors;
    protected MessagingExceptionHandler exceptionListener;
    protected String transactionalAction;
    private TransactionType transactionType;
    private MuleContext muleContext;

    public Class getObjectType() {
        return MessageProcessorChain.class;
    }

    public void setMessageProcessors(List messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    public Object getObject() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.setName("'transaction' child processor chain");
        TransactionalInterceptingMessageProcessor txProcessor = new TransactionalInterceptingMessageProcessor();
        txProcessor.setAnnotations(this.getAnnotations());
        txProcessor.setExceptionListener(this.exceptionListener);
        txProcessor.setTransactionConfig(this.createTransactionConfig(this.transactionalAction, this.transactionType));
        builder.chain(new Processor[]{txProcessor});
        for (Object processor : this.messageProcessors) {
            if (processor instanceof Processor) {
                builder.chain(new Processor[]{(Processor)processor});
            } else if (processor instanceof MessageProcessorBuilder) {
                builder.chain(new MessageProcessorBuilder[]{(MessageProcessorBuilder)processor});
            } else {
                throw new IllegalArgumentException("MessageProcessorBuilder should only have MessageProcessor's or MessageProcessorBuilder's configured");
            }
            if (!(processor instanceof MessagingExceptionHandlerAware)) continue;
            ((MessagingExceptionHandlerAware)processor).setMessagingExceptionHandler(this.exceptionListener);
        }
        return new AbstractMessageProcessorChain(Collections.singletonList(builder.build())){

            public void setMessagingExceptionHandler(MessagingExceptionHandler messagingExceptionHandler) {
            }
        };
    }

    protected MuleTransactionConfig createTransactionConfig(String action, TransactionType type) {
        MuleTransactionConfig transactionConfig = new MuleTransactionConfig();
        transactionConfig.setActionAsString(action);
        transactionConfig.setFactory(this.lookUpTransactionFactory(type));
        return transactionConfig;
    }

    private TransactionFactory lookUpTransactionFactory(TransactionType type) {
        for (TypedTransactionFactory possibleFactory : ServiceLoader.load(TypedTransactionFactory.class)) {
            if (!type.equals((Object)possibleFactory.getType())) continue;
            try {
                return (TransactionFactory)possibleFactory.getClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Unable to generate a factory for transaction %s.", type)));
            }
        }
        throw new IllegalArgumentException(String.format("No factory available for transaction type %s", type));
    }

    public boolean isSingleton() {
        return false;
    }

    public void setExceptionListener(MessagingExceptionHandler exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public void setTransactionalAction(String action) {
        this.transactionalAction = action;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void setTransactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
    }
}

