/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.editors;

import java.beans.PropertyEditorSupport;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.springframework.util.StringUtils;

public class DatePropertyEditor
extends PropertyEditorSupport {
    private DateFormat dateFormat;
    private DateFormat shortDateFormat;
    private final boolean allowEmpty;
    private final int exactDateLength;

    public DatePropertyEditor(DateFormat longDateFormat, DateFormat shortDateFormat, boolean allowEmpty) {
        this.dateFormat = longDateFormat;
        this.shortDateFormat = shortDateFormat;
        this.allowEmpty = allowEmpty;
        this.exactDateLength = -1;
    }

    public DatePropertyEditor(DateFormat longDateFormat, boolean allowEmpty, int exactDateLength) {
        this.dateFormat = longDateFormat;
        this.allowEmpty = allowEmpty;
        this.exactDateLength = exactDateLength;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (this.allowEmpty && !StringUtils.hasText((String)text)) {
            this.setValue(null);
        } else if (text.equals("now")) {
            this.setValue(new Date());
        } else {
            if (this.exactDateLength >= 0 && text.length() != this.exactDateLength) {
                throw new IllegalArgumentException("Could not parse date: it is not exactly" + this.exactDateLength + "characters long");
            }
            try {
                if (this.shortDateFormat != null && text.length() <= 10) {
                    this.setValue(this.shortDateFormat.parse(text));
                } else {
                    this.setValue(this.dateFormat.parse(text));
                }
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("Could not parse date: " + ex.getMessage(), ex);
            }
        }
    }

    @Override
    public String getAsText() {
        Date value = (Date)this.getValue();
        return value != null ? this.dateFormat.format(value) : "";
    }
}

