/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.ArrayUtils;
import org.mule.runtime.config.spring.ElementValidator;
import org.mule.runtime.config.spring.MuleArtifactContext;
import org.mule.runtime.config.spring.dsl.model.ApplicationModel;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;
import org.mule.runtime.config.spring.dsl.spring.BeanDefinitionFactory;
import org.mule.runtime.config.spring.dsl.spring.CommonBeanDefinitionCreator;
import org.mule.runtime.config.spring.parsers.generic.AutoIdUtils;
import org.mule.runtime.config.spring.util.SpringXMLUtils;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.core.util.xmlsecurity.XMLSecureFactories;
import org.mule.runtime.dsl.api.component.config.ComponentIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.DefaultBeanDefinitionDocumentReader;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MuleHierarchicalBeanDefinitionParserDelegate
extends BeanDefinitionParserDelegate {
    public static final String BEANS = "beans";
    public static final String MULE_REPEAT_PARSE = "org.mule.runtime.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_REPEAT_PARSE";
    public static final String MULE_NO_RECURSE = "org.mule.runtime.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE";
    public static final String MULE_FORCE_RECURSE = "org.mule.runtime.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_FORCE_RECURSE";
    public static final String MULE_NO_REGISTRATION = "org.mule.runtime.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_REGISTRATION";
    public static final String MULE_POST_CHILDREN = "org.mule.runtime.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_POST_CHILDREN";
    private final Supplier<ApplicationModel> applicationModelSupplier;
    private final List<ElementValidator> elementValidators;
    private final DefaultBeanDefinitionDocumentReader beanDefinitionDocumentReader;
    private BeanDefinitionFactory beanDefinitionFactory;
    protected static final Logger logger = LoggerFactory.getLogger(MuleHierarchicalBeanDefinitionParserDelegate.class);

    public MuleHierarchicalBeanDefinitionParserDelegate(XmlReaderContext readerContext, DefaultBeanDefinitionDocumentReader beanDefinitionDocumentReader, Supplier<ApplicationModel> applicationModelSupplier, BeanDefinitionFactory beanDefinitionFactory, ElementValidator ... elementValidators) {
        super(readerContext);
        this.beanDefinitionDocumentReader = beanDefinitionDocumentReader;
        this.applicationModelSupplier = applicationModelSupplier;
        this.beanDefinitionFactory = beanDefinitionFactory;
        this.elementValidators = ArrayUtils.isEmpty((Object[])elementValidators) ? ImmutableList.of() : ImmutableList.copyOf((Object[])elementValidators);
    }

    public BeanDefinition parseCustomElement(Element element, BeanDefinition parent) {
        ParserContext parserContext;
        if (logger.isDebugEnabled()) {
            logger.debug("parsing: " + SpringXMLUtils.elementToString((Element)element));
        }
        this.validate(element);
        if (SpringXMLUtils.isBeansNamespace(element) && !this.springElementHasCustomParser(element)) {
            return this.handleSpringElements(element, parent);
        }
        String namespaceUri = element.getNamespaceURI();
        NamespaceHandler handler = this.getReaderContext().getNamespaceHandlerResolver().resolve(namespaceUri);
        boolean noRecurse = false;
        boolean forceRecurse = false;
        BeanDefinition finalChild = null;
        BeanDefinition currentDefinition = null;
        do {
            ComponentModel componentModel = this.applicationModelSupplier.get().findComponentDefinitionModel(element);
            if (this.shouldUseNewMechanism(element)) {
                ComponentModel parentComponentModel = this.applicationModelSupplier.get().findComponentDefinitionModel((Element)element.getParentNode());
                this.beanDefinitionFactory.resolveComponentRecursively(parentComponentModel, componentModel, this.getReaderContext().getRegistry(), (resolvedComponent, registry) -> {
                    if (resolvedComponent.isRoot()) {
                        String name = resolvedComponent.getNameAttribute();
                        if (name == null) {
                            name = resolvedComponent.getIdentifier().equals((Object)ApplicationModel.CONFIGURATION_IDENTIFIER) ? "_muleConfiguration" : AutoIdUtils.uniqueValue(resolvedComponent.getIdentifier().toString());
                        }
                        BeanDefinitionFactory.checkElementNameUnique(registry, element);
                        registry.registerBeanDefinition(name, resolvedComponent.getBeanDefinition());
                        MuleArtifactContext.postProcessBeanDefinition(resolvedComponent, registry, name);
                    }
                }, (mpElement, beanDefinition) -> this.parseCustomElement((Element)mpElement, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition().getBeanDefinition()));
                return null;
            }
            if (!(element.getLocalName().equals("mule") || element.getLocalName().equals("mule-domain") || element.getLocalName().equals("policy"))) {
                parserContext = new ParserContext(this.getReaderContext(), (BeanDefinitionParserDelegate)this, parent);
                currentDefinition = finalChild = handler.parse(element, parserContext);
                ComponentModel parentComponentModel = this.applicationModelSupplier.get().findComponentDefinitionModel((Element)element.getParentNode());
                if (parentComponentModel != null) {
                    finalChild = CommonBeanDefinitionCreator.adaptFilterBeanDefinitions(parentComponentModel, (AbstractBeanDefinition)finalChild);
                }
                this.registerBean(element, currentDefinition);
                this.setComponentModelTypeFromBeanDefinition(finalChild, componentModel);
            }
            noRecurse = noRecurse || MuleHierarchicalBeanDefinitionParserDelegate.testFlag(finalChild, MULE_NO_RECURSE);
            boolean bl = forceRecurse = forceRecurse || MuleHierarchicalBeanDefinitionParserDelegate.testFlag(finalChild, MULE_FORCE_RECURSE);
        } while (null != finalChild && MuleHierarchicalBeanDefinitionParserDelegate.testFlag(finalChild, MULE_REPEAT_PARSE));
        boolean isRecurse = noRecurse ? false : (forceRecurse ? true : SpringXMLUtils.isMuleNamespace(element));
        if (isRecurse) {
            NodeList list = element.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                if (!(list.item(i) instanceof Element)) continue;
                this.parseCustomElement((Element)list.item(i), currentDefinition);
            }
        }
        if (MuleHierarchicalBeanDefinitionParserDelegate.testFlag(finalChild, MULE_POST_CHILDREN)) {
            parserContext = new ParserContext(this.getReaderContext(), (BeanDefinitionParserDelegate)this, parent);
            finalChild = handler.parse(element, parserContext);
        }
        return finalChild;
    }

    private boolean springElementHasCustomParser(Element element) {
        if (element.getLocalName().equals("properties")) {
            return true;
        }
        return element.getLocalName().equals("entry") && element.getParentNode().getLocalName().equals("properties");
    }

    private void setComponentModelTypeFromBeanDefinition(BeanDefinition finalChild, ComponentModel componentModel) {
        if (componentModel != null && finalChild != null) {
            try {
                Class type = ClassUtils.getClass((String)finalChild.getBeanClassName());
                if (FactoryBean.class.isAssignableFrom(type)) {
                    try {
                        type = (Class)((ParameterizedType)ClassUtils.getClass((String)finalChild.getBeanClassName()).getGenericInterfaces()[0]).getActualTypeArguments()[0];
                    }
                    catch (Exception e2) {
                        try {
                            type = (Class)((ParameterizedType)ClassUtils.getClass((String)finalChild.getBeanClassName()).getGenericSuperclass()).getActualTypeArguments()[0];
                        }
                        catch (Exception e3) {
                            try {
                                type = ((FactoryBean)type.newInstance()).getObjectType();
                            }
                            catch (InstantiationException e) {
                                type = Object.class;
                            }
                        }
                    }
                }
                componentModel.setType(type);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private boolean shouldUseNewMechanism(Element element) {
        ComponentIdentifier parentComponentIdentifier;
        if (element.getLocalName().equals("mule") || element.getLocalName().equals("mule-domain") || element.getLocalName().equals("policy")) {
            return false;
        }
        Node parentNode = element;
        while ((parentNode = parentNode.getParentNode()) != null && !this.isMuleRootElement(parentComponentIdentifier = this.getComponentIdentifier(parentNode))) {
            if (this.beanDefinitionFactory.hasDefinition(parentComponentIdentifier, this.getParentComponentIdentifier(parentNode))) continue;
            return false;
        }
        ComponentIdentifier elementComponentIdentifier = this.getComponentIdentifier(element);
        return this.beanDefinitionFactory.hasDefinition(elementComponentIdentifier, this.getParentComponentIdentifier(element));
    }

    private Optional<ComponentIdentifier> getParentComponentIdentifier(Node element) {
        if (element.getParentNode() == null || element.getParentNode().getLocalName() == null) {
            return Optional.empty();
        }
        return Optional.of(this.getComponentIdentifier(element.getParentNode()));
    }

    private ComponentIdentifier getComponentIdentifier(Node element) {
        String parentNodeNamespace = this.getNamespace(element);
        String parentNodeName = element.getLocalName();
        return new ComponentIdentifier.Builder().withNamespace(parentNodeNamespace).withName(parentNodeName).build();
    }

    private boolean isMuleRootElement(ComponentIdentifier componentIdentifier) {
        return ApplicationModel.MULE_IDENTIFIER.equals((Object)componentIdentifier) || ApplicationModel.MULE_DOMAIN_IDENTIFIER.equals((Object)componentIdentifier) || ApplicationModel.POLICY_IDENTIFIER.equals((Object)componentIdentifier);
    }

    private String getNamespace(Node parentNode) {
        if (parentNode.getPrefix() == null) {
            return parentNode.getNamespaceURI().equals("http://www.mulesoft.org/schema/mule/core") ? "mule" : "policy";
        }
        return parentNode.getPrefix();
    }

    private void validate(Element element) {
        for (ElementValidator validator : this.elementValidators) {
            validator.validate(element);
        }
    }

    protected BeanDefinition handleSpringElements(Element element, BeanDefinition parent) {
        if (SpringXMLUtils.isLocalName((Element)element, (String)BEANS)) {
            try {
                Document doc = XMLSecureFactories.createDefault().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                doc.appendChild(doc.importNode(element, true));
                this.beanDefinitionDocumentReader.registerBeanDefinitions(doc, this.getReaderContext());
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
            return parent;
        }
        if (SpringXMLUtils.isLocalName((Element)element, (String)"property")) {
            this.parsePropertyElement(element, parent);
            return parent;
        }
        if (SpringXMLUtils.isLocalName((Element)element, (String)"bean")) {
            BeanDefinitionHolder holder = this.parseBeanDefinitionElement(element, parent);
            this.registerBeanDefinitionHolder(holder);
            return holder.getBeanDefinition();
        }
        throw new IllegalStateException("Unexpected Spring element: " + SpringXMLUtils.elementToString((Element)element));
    }

    protected void registerBean(Element ele, BeanDefinition bd) {
        if (bd == null) {
            return;
        }
        if (!MuleHierarchicalBeanDefinitionParserDelegate.testFlag(bd, MULE_NO_REGISTRATION)) {
            String name = this.generateChildBeanName(ele);
            logger.debug("register " + name + ": " + bd.getBeanClassName());
            BeanDefinitionHolder beanDefinitionHolder = new BeanDefinitionHolder(bd, name);
            this.registerBeanDefinitionHolder(beanDefinitionHolder);
        }
    }

    protected void registerBeanDefinitionHolder(BeanDefinitionHolder bdHolder) {
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)bdHolder, (BeanDefinitionRegistry)this.getReaderContext().getRegistry());
        this.getReaderContext().fireComponentRegistered((ComponentDefinition)new BeanComponentDefinition(bdHolder));
    }

    protected String generateChildBeanName(Element e) {
        String id = SpringXMLUtils.getNameOrId(e);
        if (StringUtils.isBlank((String)id)) {
            String parentId = SpringXMLUtils.getNameOrId((Element)e.getParentNode());
            return "(inner bean)." + parentId + ":" + e.getLocalName();
        }
        return id;
    }

    public static void setFlag(BeanDefinition bean, String flag) {
        bean.setAttribute(flag, (Object)Boolean.TRUE);
    }

    public static boolean testFlag(BeanDefinition bean, String flag) {
        return null != bean && bean.hasAttribute(flag) && bean.getAttribute(flag) instanceof Boolean && (Boolean)bean.getAttribute(flag) != false;
    }

    public Map parseMapElement(Element mapEle, String mapElementTagName, String mapElementKeyAttributeName, String mapElementValueAttributeName) {
        List entryEles = DomUtils.getChildElementsByTagName((Element)mapEle, (String)mapElementTagName);
        ManagedMap map = new ManagedMap(entryEles.size());
        map.setSource(this.extractSource(mapEle));
        map.setMergeEnabled(this.parseMergeAttribute(mapEle));
        for (Element entryEle : entryEles) {
            Object key = this.buildTypedStringValueForMap(entryEle.getAttribute(mapElementKeyAttributeName), null, entryEle);
            Object value = this.buildTypedStringValueForMap(entryEle.getAttribute(mapElementValueAttributeName), null, entryEle);
            map.put(key, value);
        }
        return map;
    }
}

