/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.mule.runtime.config.spring.OptionalObjectsController;
import org.mule.runtime.core.util.ClassUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.RootBeanDefinition;

public class LaxInstantiationStrategyWrapper
implements InstantiationStrategy {
    private final InstantiationStrategy delegate;
    private final OptionalObjectsController optionalObjectsController;

    public LaxInstantiationStrategyWrapper(InstantiationStrategy delegate, OptionalObjectsController optionalObjectsController) {
        this.delegate = delegate;
        this.optionalObjectsController = optionalObjectsController;
    }

    public Object instantiate(RootBeanDefinition bd, String beanName, BeanFactory owner) throws BeansException {
        return ClassUtils.withContextClassLoader((ClassLoader)this.getClassLoader(bd), () -> {
            try {
                return this.delegate.instantiate(bd, beanName, owner);
            }
            catch (BeansException e) {
                return this.failIfNotOptional(e, beanName);
            }
        });
    }

    private ClassLoader getClassLoader(RootBeanDefinition bd) {
        try {
            return bd.getBeanClass().getClassLoader();
        }
        catch (IllegalStateException e) {
            return Thread.currentThread().getContextClassLoader();
        }
    }

    public Object instantiate(RootBeanDefinition bd, String beanName, BeanFactory owner, Constructor<?> ctor, Object ... args) throws BeansException {
        return ClassUtils.withContextClassLoader((ClassLoader)this.getClassLoader(bd), () -> {
            try {
                return this.delegate.instantiate(bd, beanName, owner, ctor, args);
            }
            catch (BeansException e) {
                return this.failIfNotOptional(e, beanName);
            }
        });
    }

    public Object instantiate(RootBeanDefinition bd, String beanName, BeanFactory owner, Object factoryBean, Method factoryMethod, Object ... args) throws BeansException {
        return ClassUtils.withContextClassLoader((ClassLoader)this.getClassLoader(bd), () -> {
            try {
                return this.delegate.instantiate(bd, beanName, owner, factoryBean, factoryMethod, args);
            }
            catch (BeansException e) {
                return this.failIfNotOptional(e, beanName);
            }
        });
    }

    private Object failIfNotOptional(BeansException exception, String beanName) throws BeansException {
        if (this.optionalObjectsController.isOptional(beanName)) {
            this.optionalObjectsController.discardOptionalObject(beanName);
            return this.optionalObjectsController.getDiscardedObjectPlaceholder();
        }
        throw exception;
    }
}

