/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.parsers.delegate;

import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.config.spring.parsers.MuleDefinitionParser;
import org.mule.runtime.config.spring.parsers.delegate.AbstractParallelDelegatingDefinitionParser;
import org.mule.runtime.config.spring.util.SpringXMLUtils;
import org.mule.runtime.core.util.CollectionUtils;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class AttributeSelectionDefinitionParser
extends AbstractParallelDelegatingDefinitionParser {
    private Map attributeToParserIndex = new HashMap();

    public AttributeSelectionDefinitionParser(String attribute, MuleDefinitionParser delegate) {
        this.addDelegate(attribute, delegate);
    }

    public void addDelegate(String attribute, MuleDefinitionParser delegate) {
        this.addDelegate(delegate);
        this.attributeToParserIndex.put(attribute, new Integer(this.size() - 1));
        delegate.setIgnoredDefault(true);
        delegate.removeIgnored(attribute);
    }

    @Override
    protected MuleDefinitionParser getDelegate(Element element, ParserContext parserContext) {
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attribute = SpringXMLUtils.attributeName((Attr)((Attr)attributes.item(i)));
            if (!this.attributeToParserIndex.containsKey(attribute)) continue;
            return this.getDelegate((Integer)this.attributeToParserIndex.get(attribute));
        }
        throw new IllegalArgumentException("Element " + SpringXMLUtils.elementToString((Element)element) + " does not contain any attribute from " + CollectionUtils.toString(this.attributeToParserIndex.keySet(), (int)10, (boolean)false));
    }
}

