/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.parsers;

import java.util.Map;
import org.mule.runtime.config.spring.parsers.XmlMetadataAnnotations;
import org.mule.runtime.core.util.SystemUtils;

public class DefaultXmlMetadataAnnotations
implements XmlMetadataAnnotations {
    public static final String METADATA_ANNOTATIONS_KEY = "metadataAnnotations";
    private StringBuilder xmlContent = new StringBuilder();
    private int lineNumber;

    @Override
    public void appendElementStart(String qName, Map<String, String> atts) {
        this.xmlContent.append("<" + qName);
        for (Map.Entry<String, String> entry : atts.entrySet()) {
            this.xmlContent.append(" " + entry.getKey() + "=\"" + entry.getValue() + "\"");
        }
        this.xmlContent.append(">");
    }

    @Override
    public void appendElementBody(String elementBody) {
        this.xmlContent.append(elementBody);
    }

    @Override
    public void appendElementEnd(String qName) {
        this.xmlContent.append("</" + qName + ">");
    }

    @Override
    public String getElementString() {
        return this.xmlContent.toString().replaceAll(">\\s+<+", ">" + SystemUtils.LINE_SEPARATOR + "<").trim();
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }
}

