/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.handlers;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import org.mule.runtime.config.spring.parsers.AbstractChildDefinitionParser;
import org.mule.runtime.config.spring.parsers.DeprecatedBeanDefinitionParser;
import org.mule.runtime.config.spring.parsers.MuleDefinitionParser;
import org.mule.runtime.config.spring.parsers.MuleDefinitionParserConfiguration;
import org.mule.runtime.config.spring.parsers.PostProcessor;
import org.mule.runtime.config.spring.parsers.PreProcessor;
import org.mule.runtime.config.spring.parsers.assembly.BeanAssembler;
import org.mule.runtime.config.spring.parsers.assembly.DefaultBeanAssembler;
import org.mule.runtime.config.spring.parsers.assembly.configuration.ValueMap;
import org.mule.runtime.config.spring.parsers.generic.MuleOrphanDefinitionParser;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.core.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractMuleNamespaceHandler
extends NamespaceHandlerSupport {
    public static final String GLOBAL_ENDPOINT = "endpoint";
    public static final String INBOUND_ENDPOINT = "inbound-endpoint";
    public static final String OUTBOUND_ENDPOINT = "outbound-endpoint";
    protected final transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected AbstractMuleNamespaceHandler() {
        this.registerBeanDefinitionParser("annotations", new AnnotationsBeanDefintionParser());
    }

    protected final void registerIgnoredElement(String name) {
        this.registerBeanDefinitionParser(name, new IgnoredDefinitionParser());
    }

    protected MuleDefinitionParserConfiguration registerConnectorDefinitionParser(Class connectorClass, String transportName) {
        return this.registerConnectorDefinitionParser(this.findConnectorClass(connectorClass, transportName));
    }

    protected MuleDefinitionParserConfiguration registerConnectorDefinitionParser(Class connectorClass) {
        return this.registerConnectorDefinitionParser(new MuleOrphanDefinitionParser(connectorClass, true));
    }

    protected MuleDefinitionParserConfiguration registerConnectorDefinitionParser(MuleDefinitionParser parser) {
        this.registerBeanDefinitionParser("connector", parser);
        return parser;
    }

    protected MuleDefinitionParserConfiguration registerMuleBeanDefinitionParser(String name, MuleDefinitionParser parser) {
        this.registerBeanDefinitionParser(name, parser);
        return parser;
    }

    protected MuleDefinitionParserConfiguration registerStandardTransportEndpoints(String protocol, String[] requiredAttributes) {
        return new RegisteredMdps();
    }

    protected MuleDefinitionParserConfiguration registerMetaTransportEndpoints(String protocol) {
        return new RegisteredMdps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class findConnectorClass(Class basicConnector, String transportName) {
        String preferredPropertiesURL = "META-INF/services/org/mule/transport/preferred-" + transportName + ".properties";
        InputStream stream = AbstractMuleNamespaceHandler.class.getClassLoader().getResourceAsStream(preferredPropertiesURL);
        if (stream != null) {
            try {
                Properties preferredProperties = new Properties();
                preferredProperties.load(stream);
                String preferredConnectorName = preferredProperties.getProperty("connector");
                if (preferredConnectorName != null) {
                    this.logger.debug("Found preferred connector class " + preferredConnectorName);
                    Class clazz = ClassUtils.getClass((String)preferredConnectorName);
                    return clazz;
                }
            }
            catch (Exception e) {
                this.logger.debug("Error processing preferred properties", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        return basicConnector;
    }

    protected void registerDeprecatedBeanDefinitionParser(String elementName, BeanDefinitionParser parser, String message) {
        this.registerBeanDefinitionParser(elementName, new DeprecatedBeanDefinitionParser(parser, String.format("Schema warning: Use of element <%s> is deprecated.  %s.", elementName, message)));
    }

    protected MuleDefinitionParserConfiguration registerDeprecatedMuleBeanDefinitionParser(String name, MuleDefinitionParser parser, String message) {
        this.registerDeprecatedBeanDefinitionParser(name, parser, message);
        return parser;
    }

    protected MuleDefinitionParserConfiguration registerDeprecatedConnectorDefinitionParser(Class connectorClass, String message) {
        MuleOrphanDefinitionParser parser = new MuleOrphanDefinitionParser(connectorClass, true);
        this.registerDeprecatedBeanDefinitionParser("connector", parser, message);
        return parser;
    }

    static class AnnotationsBeanDefintionParser
    extends AbstractChildDefinitionParser {
        AnnotationsBeanDefintionParser() {
        }

        @Override
        protected AbstractBeanDefinition parseInternal(Element element, ParserContext context) {
            AbstractBeanDefinition beanDef = super.parseInternal(element, context);
            beanDef.setAttribute("org.mule.runtime.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE", (Object)true);
            beanDef.setAttribute("org.mule.runtime.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_REGISTRATION", (Object)true);
            return beanDef;
        }

        @Override
        public String getPropertyName(Element element) {
            return "annotation";
        }

        @Override
        protected Class<?> getBeanClass(Element element) {
            return Map.class;
        }

        @Override
        protected void postProcess(ParserContext context, BeanAssembler beanAssembler, Element element) {
            if (beanAssembler instanceof DefaultBeanAssembler) {
                DefaultBeanAssembler assembler = (DefaultBeanAssembler)beanAssembler;
                if (assembler.getTarget() == null) {
                    return;
                }
                if (assembler.isAnnotationsPropertyAvailable(assembler.getTarget().getBeanClassName())) {
                    for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                        if (node.getNodeType() != 1) continue;
                        StringBuilder builder = new StringBuilder();
                        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                            switch (child.getNodeType()) {
                                case 3: 
                                case 4: {
                                    builder.append(child.getNodeValue());
                                }
                            }
                        }
                        assembler.addAnnotationValue(context.getContainingBeanDefinition().getPropertyValues(), new QName(node.getNamespaceURI(), node.getLocalName()), builder.toString());
                    }
                }
            }
        }
    }

    protected class RegisteredMdps
    implements MuleDefinitionParserConfiguration {
        private Set bdps = new HashSet();

        protected RegisteredMdps() {
        }

        protected MuleDefinitionParser add(MuleDefinitionParser bdp) {
            this.bdps.add(bdp);
            return bdp;
        }

        @Override
        public MuleDefinitionParserConfiguration registerPreProcessor(PreProcessor preProcessor) {
            Iterator bdp = this.bdps.iterator();
            while (bdp.hasNext()) {
                ((MuleDefinitionParserConfiguration)bdp.next()).registerPreProcessor(preProcessor);
            }
            return this;
        }

        @Override
        public MuleDefinitionParserConfiguration registerPostProcessor(PostProcessor postProcessor) {
            Iterator bdp = this.bdps.iterator();
            while (bdp.hasNext()) {
                ((MuleDefinitionParserConfiguration)bdp.next()).registerPostProcessor(postProcessor);
            }
            return this;
        }

        @Override
        public MuleDefinitionParserConfiguration addReference(String propertyName) {
            Iterator bdp = this.bdps.iterator();
            while (bdp.hasNext()) {
                ((MuleDefinitionParserConfiguration)bdp.next()).addReference(propertyName);
            }
            return this;
        }

        @Override
        public MuleDefinitionParserConfiguration addMapping(String propertyName, Map mappings) {
            Iterator bdp = this.bdps.iterator();
            while (bdp.hasNext()) {
                ((MuleDefinitionParserConfiguration)bdp.next()).addMapping(propertyName, mappings);
            }
            return this;
        }

        @Override
        public MuleDefinitionParserConfiguration addMapping(String propertyName, String mappings) {
            Iterator bdp = this.bdps.iterator();
            while (bdp.hasNext()) {
                ((MuleDefinitionParserConfiguration)bdp.next()).addMapping(propertyName, mappings);
            }
            return this;
        }

        @Override
        public MuleDefinitionParserConfiguration addMapping(String propertyName, ValueMap mappings) {
            Iterator bdp = this.bdps.iterator();
            while (bdp.hasNext()) {
                ((MuleDefinitionParserConfiguration)bdp.next()).addMapping(propertyName, mappings);
            }
            return this;
        }

        @Override
        public MuleDefinitionParserConfiguration addAlias(String alias, String propertyName) {
            Iterator bdp = this.bdps.iterator();
            while (bdp.hasNext()) {
                ((MuleDefinitionParserConfiguration)bdp.next()).addAlias(alias, propertyName);
            }
            return this;
        }

        @Override
        public MuleDefinitionParserConfiguration addCollection(String propertyName) {
            Iterator bdp = this.bdps.iterator();
            while (bdp.hasNext()) {
                ((MuleDefinitionParserConfiguration)bdp.next()).addCollection(propertyName);
            }
            return this;
        }

        @Override
        public MuleDefinitionParserConfiguration addIgnored(String propertyName) {
            Iterator bdp = this.bdps.iterator();
            while (bdp.hasNext()) {
                ((MuleDefinitionParserConfiguration)bdp.next()).addIgnored(propertyName);
            }
            return this;
        }

        @Override
        public MuleDefinitionParserConfiguration removeIgnored(String propertyName) {
            Iterator bdp = this.bdps.iterator();
            while (bdp.hasNext()) {
                ((MuleDefinitionParserConfiguration)bdp.next()).removeIgnored(propertyName);
            }
            return this;
        }

        @Override
        public MuleDefinitionParserConfiguration setIgnoredDefault(boolean ignoreAll) {
            Iterator bdp = this.bdps.iterator();
            while (bdp.hasNext()) {
                ((MuleDefinitionParserConfiguration)bdp.next()).setIgnoredDefault(ignoreAll);
            }
            return this;
        }

        @Override
        public MuleDefinitionParserConfiguration addBeanFlag(String flag) {
            Iterator bdp = this.bdps.iterator();
            while (bdp.hasNext()) {
                ((MuleDefinitionParserConfiguration)bdp.next()).addBeanFlag(flag);
            }
            return this;
        }
    }

    public static class IgnoredDefinitionParser
    implements BeanDefinitionParser {
        public BeanDefinition parse(Element element, ParserContext parserContext) {
            return null;
        }
    }
}

