/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.model.internal;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.app.declaration.ComponentElementDeclaration;
import org.mule.runtime.api.app.declaration.ConfigurationElementDeclaration;
import org.mule.runtime.api.app.declaration.ConnectionElementDeclaration;
import org.mule.runtime.api.app.declaration.ElementDeclaration;
import org.mule.runtime.api.app.declaration.OperationElementDeclaration;
import org.mule.runtime.api.app.declaration.ParameterElementDeclaration;
import org.mule.runtime.api.app.declaration.ParameterValue;
import org.mule.runtime.api.app.declaration.ParameterValueVisitor;
import org.mule.runtime.api.app.declaration.ParameterizedElementDeclaration;
import org.mule.runtime.api.app.declaration.SourceElementDeclaration;
import org.mule.runtime.api.app.declaration.TopLevelParameterDeclaration;
import org.mule.runtime.api.app.declaration.fluent.ParameterListValue;
import org.mule.runtime.api.app.declaration.fluent.ParameterObjectValue;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.config.spring.dsl.model.DslElementModel;
import org.mule.runtime.config.spring.dsl.model.internal.InfrastructureElementModelDelegate;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.runtime.dsl.api.component.config.ComponentIdentifier;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.internal.dsl.syntax.DslSyntaxUtils;

class DeclarationBasedElementModelFactory {
    private final DslResolvingContext context;
    private final InfrastructureElementModelDelegate infrastructureDelegate;
    private final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    private Map<ExtensionModel, DslSyntaxResolver> resolvers;
    private ExtensionModel currentExtension;
    private DslSyntaxResolver dsl;

    DeclarationBasedElementModelFactory(DslResolvingContext context, Map<ExtensionModel, DslSyntaxResolver> resolvers) {
        this.context = context;
        this.resolvers = resolvers;
        this.infrastructureDelegate = new InfrastructureElementModelDelegate();
    }

    public <T> Optional<DslElementModel<T>> create(final ElementDeclaration declaration) {
        this.setupCurrentExtensionContext(declaration.getDeclaringExtension());
        final Function<NamedObject, Boolean> equalsName = named -> named.getName().equals(declaration.getName());
        if (declaration instanceof TopLevelParameterDeclaration) {
            return this.createFromType((TopLevelParameterDeclaration)declaration);
        }
        final Reference elementModel = new Reference();
        new ExtensionWalker(){

            protected void onConfiguration(ConfigurationModel model) {
                if (((Boolean)equalsName.apply(model)).booleanValue()) {
                    Preconditions.checkArgument((boolean)(declaration instanceof ConfigurationElementDeclaration), (String)String.format("Found a Configuration with the given name, but expected a '%s'", declaration.getClass().getName()));
                    elementModel.set((Object)DeclarationBasedElementModelFactory.this.createConfigurationElement(model, (ConfigurationElementDeclaration)declaration));
                    this.stop();
                }
            }

            protected void onOperation(HasOperationModels owner, OperationModel model) {
                if (((Boolean)equalsName.apply(model)).booleanValue()) {
                    Preconditions.checkArgument((boolean)(declaration instanceof OperationElementDeclaration), (String)String.format("Found an Operation with the given name, but expected a '%s'", declaration.getClass().getName()));
                    elementModel.set((Object)DeclarationBasedElementModelFactory.this.createComponentElement((ComponentModel)model, (ComponentElementDeclaration)((OperationElementDeclaration)declaration)));
                    this.stop();
                }
            }

            protected void onSource(HasSourceModels owner, SourceModel model) {
                if (((Boolean)equalsName.apply(model)).booleanValue()) {
                    Preconditions.checkArgument((boolean)(declaration instanceof SourceElementDeclaration), (String)String.format("Found a Source with the given name, but expected a '%s'", declaration.getClass().getName()));
                    elementModel.set((Object)DeclarationBasedElementModelFactory.this.createComponentElement((ComponentModel)model, (ComponentElementDeclaration)((SourceElementDeclaration)declaration)));
                    this.stop();
                }
            }
        }.walk(this.currentExtension);
        return Optional.ofNullable(elementModel.get());
    }

    private <T> Optional<DslElementModel<T>> createFromType(TopLevelParameterDeclaration declaration) {
        Optional type = this.context.getTypeCatalog().getType(declaration.getValue().getTypeId());
        if (!type.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(this.createTopLevelElement((ObjectType)type.get(), declaration));
    }

    private DslElementModel<ConfigurationModel> createConfigurationElement(ConfigurationModel model, ConfigurationElementDeclaration configDeclaration) {
        DslElementSyntax configDsl = this.dsl.resolve((NamedObject)model);
        ComponentConfiguration.Builder configuration = ComponentConfiguration.builder().withIdentifier(this.asIdentifier(configDsl)).withParameter("name", configDeclaration.getRefName());
        DslElementModel.Builder<ConfigurationModel> element = this.createParameterizedElementModel(model, configDsl, (ParameterizedElementDeclaration)configDeclaration, configuration);
        if (configDeclaration.getConnection() != null) {
            this.addConnectionProvider(configDeclaration.getConnection(), model, configuration, element);
        }
        return element.withConfig(configuration.build()).build();
    }

    private DslElementModel<? extends ComponentModel> createComponentElement(ComponentModel model, ComponentElementDeclaration componentDeclaration) {
        DslElementSyntax configDsl = this.dsl.resolve((NamedObject)model);
        ComponentConfiguration.Builder configuration = ComponentConfiguration.builder().withIdentifier(this.asIdentifier(configDsl));
        if (componentDeclaration.getConfigRef() != null) {
            configuration.withParameter("config-ref", componentDeclaration.getConfigRef());
        }
        DslElementModel.Builder<ComponentModel> element = this.createParameterizedElementModel(model, configDsl, (ParameterizedElementDeclaration)componentDeclaration, configuration);
        return element.withConfig(configuration.build()).build();
    }

    private DslElementModel createTopLevelElement(ObjectType model, TopLevelParameterDeclaration declaration) {
        DslElementSyntax objectDsl = (DslElementSyntax)this.dsl.resolve((MetadataType)model).orElseThrow(() -> new IllegalArgumentException());
        DslElementModel.Builder<ObjectType> parentElement = DslElementModel.builder().withModel(model).withDsl(objectDsl);
        ComponentConfiguration.Builder configuration = ComponentConfiguration.builder().withIdentifier(this.asIdentifier(objectDsl)).withParameter("name", declaration.getRefName());
        this.populateObjectElementFields(model, declaration.getValue(), objectDsl, configuration, parentElement);
        return parentElement.withConfig(configuration.build()).build();
    }

    private void setupCurrentExtensionContext(String extension) {
        this.currentExtension = (ExtensionModel)this.context.getExtension(extension).orElseThrow(() -> new IllegalArgumentException());
        this.dsl = this.resolvers.get(this.currentExtension);
    }

    private void addConnectionProvider(ConnectionElementDeclaration connection, ConfigurationModel model, ComponentConfiguration.Builder configuration, DslElementModel.Builder<ConfigurationModel> configElement) {
        Stream.concat(model.getConnectionProviders().stream(), this.currentExtension.getConnectionProviders().stream()).filter(c -> c.getName().equals(connection.getName())).findFirst().ifPresent(provider -> {
            DslElementSyntax providerDsl = this.dsl.resolve((NamedObject)provider);
            ComponentConfiguration.Builder builder = ComponentConfiguration.builder().withIdentifier(this.asIdentifier(providerDsl));
            DslElementModel.Builder<ConnectionProviderModel> element = this.createParameterizedElementModel(provider, providerDsl, (ParameterizedElementDeclaration)connection, builder);
            ComponentConfiguration providerConfig = builder.build();
            configuration.withNestedComponent(providerConfig);
            configElement.containing(element.withConfig(providerConfig).build());
        });
    }

    private <T extends ParameterizedModel> DslElementModel.Builder<T> createParameterizedElementModel(T model, DslElementSyntax elementDsl, ParameterizedElementDeclaration declaration, ComponentConfiguration.Builder parentConfig) {
        DslElementModel.Builder parentElement = DslElementModel.builder().withModel(model).withDsl(elementDsl);
        List inlineGroupedParameters = model.getParameterGroupModels().stream().filter(ParameterGroupModel::isShowInDsl).peek(group -> this.addInlineGroupElement((ParameterGroupModel)group, elementDsl, parentConfig, parentElement, declaration)).flatMap(g -> g.getParameterModels().stream()).collect(Collectors.toList());
        List<ParameterModel> nonGroupedParameters = model.getAllParameterModels().stream().filter(p -> !inlineGroupedParameters.contains(p)).collect(Collectors.toList());
        this.addAllDeclaredParameters(nonGroupedParameters, declaration.getParameters(), elementDsl, parentConfig, parentElement);
        return parentElement;
    }

    private void addAllDeclaredParameters(List<ParameterModel> parameterModels, List<ParameterElementDeclaration> parameterDeclarations, DslElementSyntax parentDsl, ComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement) {
        LinkedList configuredParameters = new LinkedList();
        parameterModels.forEach(paramModel -> parentDsl.getContainedElement(paramModel.getName()).ifPresent(paramDsl -> {
            Optional<ParameterElementDeclaration> declared = parameterDeclarations.stream().filter(d -> d.getName().equals(paramModel.getName())).findFirst();
            if (declared.isPresent()) {
                this.addParameter(declared.get(), (ParameterModel)paramModel, (DslElementSyntax)paramDsl, parentConfig, parentElement);
                configuredParameters.add(declared.get().getName());
            } else {
                ExtensionModelUtils.getDefaultValue((ParameterModel)paramModel).ifPresent(value -> this.createSimpleParameter((String)value, (DslElementSyntax)paramDsl, parentConfig, parentElement, (ParameterModel)paramModel));
            }
        }));
        if (parameterDeclarations.size() > configuredParameters.size()) {
            String missing = parameterDeclarations.stream().filter(p -> !configuredParameters.contains(p.getName())).map(ElementDeclaration::getName).collect(Collectors.joining(","));
            throw new IllegalArgumentException(String.format("The parameter%s [%s] were declared but they do not exist in the associated model", missing));
        }
    }

    private <T extends ParameterizedModel> void addInlineGroupElement(ParameterGroupModel group, DslElementSyntax elementDsl, ComponentConfiguration.Builder parentConfig, DslElementModel.Builder<T> parentElement, ParameterizedElementDeclaration declaration) {
        elementDsl.getChild(group.getName()).ifPresent(groupDsl -> {
            DslElementModel.Builder<ParameterGroupModel> groupElementBuilder = DslElementModel.builder().withModel(group).withDsl((DslElementSyntax)groupDsl);
            ComponentConfiguration.Builder groupBuilder = ComponentConfiguration.builder().withIdentifier(this.asIdentifier((DslElementSyntax)groupDsl));
            this.addAllDeclaredParameters(group.getParameterModels(), declaration.getParameters(), (DslElementSyntax)groupDsl, groupBuilder, groupElementBuilder);
            ComponentConfiguration groupConfig = groupBuilder.build();
            groupElementBuilder.withConfig(groupConfig);
            parentConfig.withNestedComponent(groupConfig);
            parentElement.containing(groupElementBuilder.build());
        });
    }

    private void addParameter(ParameterElementDeclaration parameter, final ParameterModel parameterModel, final DslElementSyntax paramDsl, final ComponentConfiguration.Builder parentConfig, final DslElementModel.Builder parentElement) {
        if (ExtensionModelUtils.isInfrastructure((ParameterModel)parameterModel)) {
            this.infrastructureDelegate.addParameter(parameter, parameterModel, paramDsl, parentConfig, parentElement);
            return;
        }
        parameter.getValue().accept(new ParameterValueVisitor(){

            public void visitSimpleValue(String value) {
                DeclarationBasedElementModelFactory.this.createSimpleParameter(value, paramDsl, parentConfig, parentElement, parameterModel);
            }

            public void visitListValue(ParameterListValue list) {
                Preconditions.checkArgument((boolean)paramDsl.supportsChildDeclaration(), (String)String.format("Inline List values are not allowed for this parameter [%s]", parameterModel.getName()));
                Preconditions.checkArgument((boolean)(parameterModel.getType() instanceof ArrayType), (String)String.format("List values can only be associated to ArrayType parameters. Parameter [%s] is of type [%s]", parameterModel.getName(), DslSyntaxUtils.getId((MetadataType)parameterModel.getType())));
                DeclarationBasedElementModelFactory.this.createList(list, paramDsl, (ArrayType)parameterModel.getType(), parentConfig, parentElement);
            }

            public void visitObjectValue(ParameterObjectValue objectValue) {
                Preconditions.checkArgument((boolean)(parameterModel.getType() instanceof ObjectType), (String)String.format("Complex values can only be associated to ObjectType parameters. Parameter [%s] is of type [%s]", parameterModel.getName(), DslSyntaxUtils.getId((MetadataType)parameterModel.getType())));
                Preconditions.checkArgument((boolean)paramDsl.supportsChildDeclaration(), (String)String.format("Complex values are not allowed for this parameter [%s]", parameterModel.getName()));
                if (ExtensionMetadataTypeUtils.isMap((MetadataType)parameterModel.getType())) {
                    DeclarationBasedElementModelFactory.this.createMapParameter(objectValue, paramDsl, parameterModel, (ObjectType)parameterModel.getType(), parentConfig, parentElement);
                } else {
                    DeclarationBasedElementModelFactory.this.createComplexParameter(objectValue, paramDsl, parameterModel, parentConfig, parentElement);
                }
            }
        });
    }

    private void createMapParameter(ParameterObjectValue objectValue, DslElementSyntax paramDsl, Object model, ObjectType mapType, ComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement) {
        ComponentConfiguration.Builder mapConfig = ComponentConfiguration.builder().withIdentifier(this.asIdentifier(paramDsl));
        DslElementModel.Builder<Object> mapElement = DslElementModel.builder().withModel(model).withDsl(paramDsl);
        final MetadataType valueType = (MetadataType)mapType.getOpenRestriction().get();
        paramDsl.getGeneric(valueType).ifPresent(entryDsl -> objectValue.getParameters().forEach((key, value) -> {
            final ComponentConfiguration.Builder entryConfigBuilder = ComponentConfiguration.builder().withIdentifier(this.asIdentifier((DslElementSyntax)entryDsl));
            final DslElementModel.Builder<MetadataType> entryElement = DslElementModel.builder().withModel(valueType).withDsl((DslElementSyntax)entryDsl);
            entryDsl.getAttribute("key").ifPresent(keyDsl -> {
                entryConfigBuilder.withParameter("key", key);
                entryElement.containing(DslElementModel.builder().withModel(this.typeLoader.load(String.class)).withDsl((DslElementSyntax)keyDsl).withValue((String)key).build());
            });
            entryDsl.getAttribute("value").ifPresent(valueDsl -> value.accept(new ParameterValueVisitor((DslElementSyntax)valueDsl){
                final /* synthetic */ DslElementSyntax val$valueDsl;
                {
                    this.val$valueDsl = dslElementSyntax;
                }

                public void visitSimpleValue(String value) {
                    entryConfigBuilder.withParameter("value", value);
                    entryElement.containing(DslElementModel.builder().withModel(valueType).withDsl(this.val$valueDsl).withValue(value).build());
                }

                public void visitListValue(ParameterListValue list) {
                    DeclarationBasedElementModelFactory.this.createList(list, this.val$valueDsl, (ArrayType)valueType, entryConfigBuilder, entryElement);
                }

                public void visitObjectValue(ParameterObjectValue objectValue) {
                    if (ExtensionMetadataTypeUtils.isMap((MetadataType)valueType)) {
                        DeclarationBasedElementModelFactory.this.createMapParameter(objectValue, this.val$valueDsl, valueType, (ObjectType)valueType, entryConfigBuilder, entryElement);
                    } else {
                        DeclarationBasedElementModelFactory.this.createObject(objectValue, this.val$valueDsl, valueType, (ObjectType)valueType, entryConfigBuilder, entryElement);
                    }
                }
            }));
            ComponentConfiguration entryConfig = entryConfigBuilder.build();
            mapConfig.withNestedComponent(entryConfig);
            mapElement.containing(entryElement.withConfig(entryConfig).build());
        }));
        ComponentConfiguration result = mapConfig.build();
        parentConfig.withNestedComponent(result);
        parentElement.containing(mapElement.withConfig(result).build());
    }

    private void createComplexParameter(ParameterObjectValue objectValue, DslElementSyntax paramDsl, ParameterModel parameterModel, ComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement) {
        if (!paramDsl.isWrapped()) {
            this.createObject(objectValue, paramDsl, parameterModel, (ObjectType)parameterModel.getType(), parentConfig, parentElement);
        } else {
            this.createWrappedObject(objectValue, parameterModel, paramDsl, parentConfig, parentElement);
        }
    }

    private void createWrappedObject(ParameterObjectValue objectValue, ParameterModel parameterModel, DslElementSyntax paramDsl, ComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement) {
        DslElementModel.Builder<ParameterModel> wrapperElement = DslElementModel.builder().withModel(parameterModel).withDsl(paramDsl);
        ComponentConfiguration.Builder wrapperConfig = ComponentConfiguration.builder().withIdentifier(this.asIdentifier(paramDsl));
        ObjectType nestedElementType = objectValue.getTypeId() == null || objectValue.getTypeId().trim().isEmpty() || objectValue.getTypeId().equals(DslSyntaxUtils.getId((MetadataType)parameterModel.getType())) ? (ObjectType)parameterModel.getType() : this.lookupType(objectValue);
        this.dsl.resolve((MetadataType)nestedElementType).ifPresent(typeDsl -> this.createObject(objectValue, (DslElementSyntax)typeDsl, nestedElementType, nestedElementType, wrapperConfig, wrapperElement));
        ComponentConfiguration result = wrapperConfig.build();
        parentConfig.withNestedComponent(result);
        parentElement.containing(wrapperElement.withConfig(result).build());
    }

    private void createSimpleParameter(String value, DslElementSyntax paramDsl, ComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement, ParameterModel parameterModel) {
        if (paramDsl.supportsAttributeDeclaration()) {
            parentConfig.withParameter(paramDsl.getAttributeName(), value);
            parentElement.containing(DslElementModel.builder().withModel(parameterModel).withDsl(paramDsl).withValue(value).build());
        } else {
            ComponentConfiguration parameterConfig = ComponentConfiguration.builder().withIdentifier(this.asIdentifier(paramDsl)).withValue(value).build();
            parentConfig.withNestedComponent(parameterConfig);
            parentElement.containing(DslElementModel.builder().withModel(parameterModel).withDsl(paramDsl).withConfig(parameterConfig).build());
        }
    }

    private ObjectType lookupType(ParameterObjectValue objectValue) {
        ObjectType nestedElementType = (ObjectType)this.context.getTypeCatalog().getType(objectValue.getTypeId()).orElseThrow(() -> new IllegalArgumentException(String.format("Could not find Type with ID '%s' in the current context", objectValue.getTypeId())));
        return nestedElementType;
    }

    private void createListItemConfig(final MetadataType itemValueType, ParameterValue itemValue, final DslElementSyntax itemDsl, final ComponentConfiguration.Builder parentConfig, final DslElementModel.Builder parentElement) {
        itemValue.accept(new ParameterValueVisitor(){

            public void visitSimpleValue(String value) {
                ComponentConfiguration item = ComponentConfiguration.builder().withIdentifier(DeclarationBasedElementModelFactory.this.asIdentifier(itemDsl)).withParameter("value", value).build();
                parentConfig.withNestedComponent(item);
                parentElement.containing(DslElementModel.builder().withModel(itemValueType).withDsl(itemDsl).withConfig(item).build());
            }

            public void visitListValue(ParameterListValue list) {
                DslElementModel.Builder<MetadataType> itemElement = DslElementModel.builder().withModel(itemValueType).withDsl(itemDsl);
                ComponentConfiguration.Builder itemConfig = ComponentConfiguration.builder().withIdentifier(DeclarationBasedElementModelFactory.this.asIdentifier(itemDsl));
                MetadataType genericType = ((ArrayType)itemValueType).getType();
                itemDsl.getGeneric(genericType).ifPresent(genericDsl -> list.getValues().forEach(value -> DeclarationBasedElementModelFactory.this.createListItemConfig(genericType, value, genericDsl, itemConfig, itemElement)));
                ComponentConfiguration result = itemConfig.build();
                parentConfig.withNestedComponent(result);
                parentElement.containing(itemElement.withConfig(result).build());
            }

            public void visitObjectValue(final ParameterObjectValue objectValue) {
                itemValueType.accept(new MetadataTypeVisitor(){

                    public void visitObject(ObjectType objectType) {
                        if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                            DeclarationBasedElementModelFactory.this.createMapParameter(objectValue, itemDsl, itemValueType, objectType, parentConfig, parentElement);
                        } else {
                            DeclarationBasedElementModelFactory.this.createObject(objectValue, itemDsl, objectType, objectType, parentConfig, parentElement);
                        }
                    }
                });
            }
        });
    }

    private void addObjectField(final MetadataType fieldType, ParameterValue fieldValue, final DslElementSyntax fieldDsl, final ComponentConfiguration.Builder objectConfig, final DslElementModel.Builder objectElement) {
        fieldValue.accept(new ParameterValueVisitor(){

            public void visitSimpleValue(String value) {
                if (fieldDsl.supportsAttributeDeclaration()) {
                    objectConfig.withParameter(fieldDsl.getAttributeName(), value);
                    objectElement.containing(DslElementModel.builder().withModel(fieldType).withDsl(fieldDsl).withValue(value).build());
                } else {
                    ComponentConfiguration contentConfiguration = ComponentConfiguration.builder().withIdentifier(DeclarationBasedElementModelFactory.this.asIdentifier(fieldDsl)).withValue(value).build();
                    objectConfig.withNestedComponent(contentConfiguration);
                    objectElement.containing(DslElementModel.builder().withModel(fieldType).withDsl(fieldDsl).withConfig(contentConfiguration).build());
                }
            }

            public void visitListValue(ParameterListValue list) {
                DeclarationBasedElementModelFactory.this.createList(list, fieldDsl, (ArrayType)fieldType, objectConfig, objectElement);
            }

            public void visitObjectValue(final ParameterObjectValue objectValue) {
                fieldType.accept(new MetadataTypeVisitor(){

                    public void visitObject(ObjectType objectType) {
                        if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                            DeclarationBasedElementModelFactory.this.createMapParameter(objectValue, fieldDsl, fieldType, objectType, objectConfig, objectElement);
                        } else {
                            DeclarationBasedElementModelFactory.this.createObject(objectValue, fieldDsl, objectType, objectType, objectConfig, objectElement);
                        }
                    }
                });
            }
        });
    }

    private void createList(ParameterListValue list, DslElementSyntax listDsl, ArrayType listType, ComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement) {
        DslElementModel.Builder<ArrayType> listElement = DslElementModel.builder().withModel(listType).withDsl(listDsl);
        ComponentConfiguration.Builder listConfig = ComponentConfiguration.builder().withIdentifier(this.asIdentifier(listDsl));
        MetadataType itemType = listType.getType();
        listDsl.getGeneric(itemType).ifPresent(itemDsl -> list.getValues().forEach(value -> this.createListItemConfig(itemType, (ParameterValue)value, (DslElementSyntax)itemDsl, listConfig, listElement)));
        ComponentConfiguration result = listConfig.build();
        parentConfig.withNestedComponent(result);
        parentElement.containing(listElement.withConfig(result).build());
    }

    private void createObject(ParameterObjectValue objectValue, DslElementSyntax objectDsl, Object model, ObjectType objectType, ComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement) {
        ComponentConfiguration.Builder objectConfig = ComponentConfiguration.builder().withIdentifier(this.asIdentifier(objectDsl));
        DslElementModel.Builder<Object> objectElement = DslElementModel.builder().withModel(model).withDsl(objectDsl);
        this.populateObjectElementFields(objectType, objectValue, objectDsl, objectConfig, objectElement);
        ComponentConfiguration result = objectConfig.build();
        parentConfig.withNestedComponent(result);
        parentElement.containing(objectElement.withConfig(result).build());
    }

    private void populateObjectElementFields(ObjectType objectType, ParameterObjectValue objectValue, DslElementSyntax objectDsl, ComponentConfiguration.Builder objectConfig, DslElementModel.Builder objectElement) {
        List fields = objectType.getFields().stream().flatMap(f -> ExtensionMetadataTypeUtils.isParameterGroup((MetadataType)f) ? ((ObjectType)f.getValue()).getFields().stream() : Stream.of(f)).collect(Collectors.toList());
        objectValue.getParameters().forEach((name, value) -> fields.stream().filter(f -> ExtensionMetadataTypeUtils.getAlias((ObjectFieldType)f).equals(name)).findFirst().ifPresent(field -> objectDsl.getContainedElement(name).ifPresent(nestedDsl -> this.addObjectField(field.getValue(), (ParameterValue)value, (DslElementSyntax)nestedDsl, objectConfig, objectElement))));
    }

    private ComponentIdentifier asIdentifier(DslElementSyntax fieldDsl) {
        Preconditions.checkArgument((fieldDsl.supportsTopLevelDeclaration() || fieldDsl.supportsChildDeclaration() ? 1 : 0) != 0, (String)String.format("The given component '%s' does not support element-like declaration", fieldDsl.getAttributeName()));
        return ComponentIdentifier.builder().withName(fieldDsl.getElementName()).withNamespace(fieldDsl.getNamespaceUri()).build();
    }
}

