/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.model.extension.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.config.spring.dsl.model.ApplicationModel;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;
import org.mule.runtime.config.spring.dsl.model.extension.xml.GlobalElementComponentModelModelProperty;
import org.mule.runtime.config.spring.dsl.model.extension.xml.OperationComponentModelModelProperty;
import org.mule.runtime.config.spring.dsl.model.extension.xml.XmlExtensionModelProperty;
import org.mule.runtime.dsl.api.component.config.ComponentIdentifier;

public class MacroExpansionModuleModel {
    private static final String MODULE_CONFIG_GLOBAL_ELEMENT_NAME = "config";
    private static final String MODULE_OPERATION_CONFIG_REF = "config-ref";
    private final ApplicationModel applicationModel;
    private final Map<String, ExtensionModel> extensions;

    public MacroExpansionModuleModel(ApplicationModel applicationModel, Set<ExtensionModel> extensions) {
        this.applicationModel = applicationModel;
        this.extensions = extensions.stream().filter(extensionModel -> extensionModel.getModelProperty(XmlExtensionModelProperty.class).isPresent()).collect(Collectors.toMap(extensionModel -> extensionModel.getName(), Function.identity()));
    }

    public void expand() {
        if (!this.extensions.isEmpty()) {
            this.createOperationRefEffectiveModel(this.extensions);
            this.createConfigRefEffectiveModel(this.extensions);
        }
    }

    private void createOperationRefEffectiveModel(Map<String, ExtensionModel> extensionManager) {
        HashMap componentModelsToReplaceByIndex = new HashMap();
        this.applicationModel.executeOnEveryMuleComponentTree(componentModel -> {
            for (int i = 0; i < componentModel.getInnerComponents().size(); ++i) {
                Optional operationModel;
                ExtensionModel extensionModel;
                ComponentModel operationRefModel = componentModel.getInnerComponents().get(i);
                ComponentIdentifier identifier = operationRefModel.getIdentifier();
                String identifierName = identifier.getName();
                if (identifierName.equals(MODULE_CONFIG_GLOBAL_ELEMENT_NAME) || (extensionModel = (ExtensionModel)extensionManager.get(identifier.getNamespace())) == null) continue;
                ExtensionModel hasOperationModels = extensionModel;
                Optional configurationModel = extensionModel.getConfigurationModel(MODULE_CONFIG_GLOBAL_ELEMENT_NAME);
                if (configurationModel.isPresent()) {
                    hasOperationModels = (HasOperationModels)configurationModel.get();
                }
                if ((operationModel = hasOperationModels.getOperationModel(identifierName)).isPresent()) {
                    ComponentModel replacementModel = this.createOperationInstance(operationRefModel, extensionModel, (OperationModel)operationModel.get());
                    componentModelsToReplaceByIndex.put(i, replacementModel);
                    continue;
                }
                ComponentIdentifier parentIdentifier = operationRefModel.getParent().getIdentifier();
                String parentIdentifierName = parentIdentifier.getName();
                if (hasOperationModels.getOperationModel(parentIdentifierName).isPresent()) continue;
                throw new IllegalArgumentException(String.format("The operation '%s' is missing in the module '%s'", identifierName, extensionModel.getName()));
            }
            for (Map.Entry entry : componentModelsToReplaceByIndex.entrySet()) {
                ((ComponentModel)entry.getValue()).setParent((ComponentModel)componentModel);
                componentModel.getInnerComponents().add((Integer)entry.getKey(), (ComponentModel)entry.getValue());
                componentModel.getInnerComponents().remove((Integer)entry.getKey() + 1);
            }
            componentModelsToReplaceByIndex.clear();
        });
    }

    private void createConfigRefEffectiveModel(Map<String, ExtensionModel> extensionManager) {
        this.applicationModel.executeOnEveryMuleComponentTree(componentModel -> {
            HashMap<Integer, List<ComponentModel>> componentModelsToReplaceByIndex = new HashMap<Integer, List<ComponentModel>>();
            for (int i = 0; i < componentModel.getInnerComponents().size(); ++i) {
                ComponentModel configRefModel = componentModel.getInnerComponents().get(i);
                ComponentIdentifier identifier = configRefModel.getIdentifier();
                ExtensionModel extensionModel = (ExtensionModel)extensionManager.get(identifier.getNamespace());
                if (extensionModel == null) continue;
                List<ComponentModel> replacementGlobalElements = this.createGlobalElementsInstance(configRefModel, extensionModel);
                componentModelsToReplaceByIndex.put(i, replacementGlobalElements);
            }
            for (Map.Entry entry : componentModelsToReplaceByIndex.entrySet()) {
                componentModel.getInnerComponents().addAll((Integer)entry.getKey(), (Collection)entry.getValue());
                componentModel.getInnerComponents().remove((Integer)entry.getKey() + ((List)entry.getValue()).size());
            }
        });
    }

    private List<ComponentModel> createGlobalElementsInstance(ComponentModel configRefModel, ExtensionModel extensionModel) {
        ArrayList<ComponentModel> globalElementsModel = new ArrayList<ComponentModel>();
        Optional config = extensionModel.getConfigurationModel(MODULE_CONFIG_GLOBAL_ELEMENT_NAME);
        if (config.isPresent() && ((ConfigurationModel)config.get()).getModelProperty(GlobalElementComponentModelModelProperty.class).isPresent()) {
            GlobalElementComponentModelModelProperty globalElementComponentModelModelProperty = (GlobalElementComponentModelModelProperty)((ConfigurationModel)config.get()).getModelProperty(GlobalElementComponentModelModelProperty.class).get();
            globalElementsModel.addAll(globalElementComponentModelModelProperty.getGlobalElements().stream().map(globalElementModel -> this.copyComponentModel((ComponentModel)globalElementModel, configRefModel.getNameAttribute())).collect(Collectors.toList()));
            ComponentModel muleRootElement = configRefModel.getParent();
            globalElementsModel.stream().forEach(componentModel -> {
                componentModel.setRoot(true);
                componentModel.setParameter("name", componentModel.getNameAttribute() + "-" + configRefModel.getNameAttribute());
                componentModel.setParent(muleRootElement);
            });
        }
        return globalElementsModel;
    }

    private ComponentModel createOperationInstance(ComponentModel operationRefModel, ExtensionModel extensionModel, OperationModel operationModel) {
        List<ComponentModel> bodyProcessors = ((OperationComponentModelModelProperty)operationModel.getModelProperty(OperationComponentModelModelProperty.class).get()).getComponentModel().getInnerComponents();
        String configRefName = operationRefModel.getParameters().get(MODULE_OPERATION_CONFIG_REF);
        ComponentModel.Builder processorChainBuilder = new ComponentModel.Builder();
        processorChainBuilder.setIdentifier(new ComponentIdentifier.Builder().withNamespace("mule").withName("module-operation-chain").build());
        processorChainBuilder.addParameter("returnsVoid", String.valueOf(MetadataTypeUtils.isVoid((MetadataType)operationModel.getOutput().getType())), false);
        Map<String, String> propertiesMap = this.extractProperties(operationRefModel, extensionModel);
        Map<String, String> parametersMap = this.extractParameters(operationRefModel, operationModel.getAllParameterModels());
        ComponentModel propertiesComponentModel = this.getParameterChild(propertiesMap, "module-operation-properties", "module-operation-property-entry");
        ComponentModel parametersComponentModel = this.getParameterChild(parametersMap, "module-operation-parameters", "module-operation-parameter-entry");
        processorChainBuilder.addChildComponentModel(propertiesComponentModel);
        processorChainBuilder.addChildComponentModel(parametersComponentModel);
        for (ComponentModel componentModel : bodyProcessors) {
            processorChainBuilder.addChildComponentModel(this.copyComponentModel(componentModel, configRefName));
        }
        for (Map.Entry entry : operationRefModel.getCustomAttributes().entrySet()) {
            processorChainBuilder.addCustomAttribute((String)entry.getKey(), entry.getValue());
        }
        ComponentModel processorChainModel = processorChainBuilder.build();
        for (ComponentModel processoChainModelChild : processorChainModel.getInnerComponents()) {
            processoChainModelChild.setParent(processorChainModel);
        }
        return processorChainModel;
    }

    private ComponentModel getParameterChild(Map<String, String> parameters, String wrapperParameters, String entryParameter) {
        ComponentModel.Builder parametersBuilder = new ComponentModel.Builder();
        parametersBuilder.setIdentifier(new ComponentIdentifier.Builder().withNamespace("mule").withName(wrapperParameters).build());
        parameters.forEach((paramName, paramValue) -> {
            ComponentModel.Builder parameterBuilder = new ComponentModel.Builder();
            parameterBuilder.setIdentifier(new ComponentIdentifier.Builder().withNamespace("mule").withName(entryParameter).build());
            parameterBuilder.addParameter("key", (String)paramName, false);
            parameterBuilder.addParameter("value", (String)paramValue, false);
            parametersBuilder.addChildComponentModel(parameterBuilder.build());
        });
        ComponentModel parametersComponentModel = parametersBuilder.build();
        for (ComponentModel parameterComponentModel : parametersComponentModel.getInnerComponents()) {
            parameterComponentModel.setParent(parametersComponentModel);
        }
        return parametersComponentModel;
    }

    private Map<String, String> extractProperties(ComponentModel operationRefModel, ExtensionModel extensionModel) {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        String configParameter = operationRefModel.getParameters().get(MODULE_OPERATION_CONFIG_REF);
        if (configParameter != null) {
            ComponentModel configRefComponentModel = this.applicationModel.getRootComponentModel().getInnerComponents().stream().filter(componentModel -> componentModel.getIdentifier().getNamespace().equals(extensionModel.getName()) && componentModel.getIdentifier().getName().equals(MODULE_CONFIG_GLOBAL_ELEMENT_NAME) && configParameter.equals(componentModel.getParameters().get("name"))).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("There's no <%s:config> named [%s] in the current mule app", extensionModel.getName(), configParameter)));
            valuesMap.putAll(this.extractParameters(configRefComponentModel, ((ConfigurationModel)extensionModel.getConfigurationModel(MODULE_CONFIG_GLOBAL_ELEMENT_NAME).get()).getAllParameterModels()));
        }
        return valuesMap;
    }

    private Map<String, String> extractParameters(ComponentModel componentModel, List<ParameterModel> parameters) {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        for (ParameterModel parameterExtension : parameters) {
            String paramName = parameterExtension.getName();
            String value = null;
            switch (parameterExtension.getRole()) {
                case BEHAVIOUR: {
                    if (!componentModel.getParameters().containsKey(paramName)) break;
                    value = componentModel.getParameters().get(paramName);
                    break;
                }
                case CONTENT: 
                case PRIMARY_CONTENT: {
                    Optional<ComponentModel> childComponentModel = componentModel.getInnerComponents().stream().filter(cm -> paramName.equals(cm.getIdentifier().getName())).findFirst();
                    if (!childComponentModel.isPresent()) break;
                    value = childComponentModel.get().getTextContent();
                }
            }
            if (value == null && parameterExtension.getDefaultValue() != null) {
                value = (String)parameterExtension.getDefaultValue();
            }
            if (value == null) continue;
            valuesMap.put(paramName, value);
        }
        return valuesMap;
    }

    private ComponentModel copyComponentModel(ComponentModel modelToCopy, String configRefName) {
        ComponentModel.Builder operationReplacementModel = new ComponentModel.Builder();
        operationReplacementModel.setIdentifier(modelToCopy.getIdentifier()).setTextContent(modelToCopy.getTextContent());
        for (Map.Entry<String, Object> entry : modelToCopy.getCustomAttributes().entrySet()) {
            operationReplacementModel.addCustomAttribute(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : modelToCopy.getParameters().entrySet()) {
            String value = entry.getKey().endsWith("ref") ? ((String)entry.getValue()).concat("-").concat(configRefName) : (String)entry.getValue();
            operationReplacementModel.addParameter(entry.getKey(), value, false);
        }
        for (ComponentModel componentModel : modelToCopy.getInnerComponents()) {
            operationReplacementModel.addChildComponentModel(this.copyComponentModel(componentModel, configRefName));
        }
        ComponentModel componentModel = operationReplacementModel.build();
        for (ComponentModel child : componentModel.getInnerComponents()) {
            child.setParent(componentModel);
        }
        return componentModel;
    }
}

