/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.DefaultMuleContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.ConfigurationExtension;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.exception.MessagingExceptionHandlerAcceptor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.api.serialization.JavaObjectSerializer;
import org.mule.runtime.core.api.serialization.ObjectSerializer;
import org.mule.runtime.core.config.DefaultMuleConfiguration;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.util.ProcessingStrategyUtils;
import org.mule.runtime.dsl.api.component.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.SmartFactoryBean;

public class MuleConfigurationConfigurator
implements MuleContextAware,
SmartFactoryBean,
ObjectFactory {
    private MuleContext muleContext;
    private DefaultMuleConfiguration config = new DefaultMuleConfiguration();
    protected transient Logger logger = LoggerFactory.getLogger(MuleConfigurationConfigurator.class);

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public boolean isEagerInit() {
        return true;
    }

    public boolean isPrototype() {
        return false;
    }

    public Object getObject() throws Exception {
        MuleConfiguration configuration = this.muleContext.getConfiguration();
        if (configuration instanceof DefaultMuleConfiguration) {
            DefaultMuleConfiguration defaultConfig = (DefaultMuleConfiguration)configuration;
            defaultConfig.setDefaultResponseTimeout(this.config.getDefaultResponseTimeout());
            defaultConfig.setDefaultTransactionTimeout(this.config.getDefaultTransactionTimeout());
            defaultConfig.setShutdownTimeout(this.config.getShutdownTimeout());
            defaultConfig.setDefaultErrorHandlerName(this.config.getDefaultErrorHandlerName());
            defaultConfig.addExtensions(this.config.getExtensions());
            defaultConfig.setMaxQueueTransactionFilesSize(this.config.getMaxQueueTransactionFilesSizeInMegabytes());
            this.determineDefaultProcessingStrategy(defaultConfig);
            this.validateDefaultErrorHandler();
            this.applyDefaultIfNoObjectSerializerSet(defaultConfig);
            return configuration;
        }
        throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)("Unable to set properties on read-only MuleConfiguration: " + configuration.getClass())));
    }

    private void determineDefaultProcessingStrategy(DefaultMuleConfiguration defaultConfig) {
        if (this.config.getDefaultProcessingStrategyFactory() != null) {
            defaultConfig.setDefaultProcessingStrategyFactory(this.config.getDefaultProcessingStrategyFactory());
        } else {
            String processingStrategyFromSystemProperty = System.getProperty("mule.default.processing.strategy");
            if (!StringUtils.isBlank((String)processingStrategyFromSystemProperty)) {
                defaultConfig.setDefaultProcessingStrategyFactory(ProcessingStrategyUtils.parseProcessingStrategy((String)processingStrategyFromSystemProperty));
            }
        }
    }

    private void validateDefaultErrorHandler() {
        String defaultErrorHandler = this.config.getDefaultErrorHandlerName();
        if (defaultErrorHandler != null) {
            MessagingExceptionHandlerAcceptor messagingExceptionHandlerAcceptor;
            MessagingExceptionHandler messagingExceptionHandler = (MessagingExceptionHandler)this.muleContext.getRegistry().lookupObject(defaultErrorHandler);
            if (messagingExceptionHandler == null) {
                throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)String.format("No global error handler defined with name %s.", defaultErrorHandler)));
            }
            if (messagingExceptionHandler instanceof MessagingExceptionHandlerAcceptor && !(messagingExceptionHandlerAcceptor = (MessagingExceptionHandlerAcceptor)messagingExceptionHandler).acceptsAll()) {
                throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)"Default exception strategy must not have expression attribute. It must accept any message."));
            }
        }
    }

    private void applyDefaultIfNoObjectSerializerSet(DefaultMuleConfiguration configuration) {
        ObjectSerializer configuredSerializer = this.config.getDefaultObjectSerializer();
        if (configuredSerializer == null) {
            configuredSerializer = new JavaObjectSerializer();
            ((MuleContextAware)configuredSerializer).setMuleContext(this.muleContext);
            this.config.setDefaultObjectSerializer(configuredSerializer);
        }
        configuration.setDefaultObjectSerializer(configuredSerializer);
        if (this.muleContext instanceof DefaultMuleContext) {
            ((DefaultMuleContext)this.muleContext).setObjectSerializer(configuredSerializer);
        }
    }

    public Class<?> getObjectType() {
        return MuleConfiguration.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setDefaultSynchronousEndpoints(boolean synchronous) {
        this.config.setDefaultSynchronousEndpoints(synchronous);
    }

    public void setDefaultResponseTimeout(int responseTimeout) {
        this.config.setDefaultResponseTimeout(responseTimeout);
    }

    public void setDefaultTransactionTimeout(int defaultTransactionTimeout) {
        this.config.setDefaultTransactionTimeout(defaultTransactionTimeout);
    }

    public void setShutdownTimeout(int shutdownTimeout) {
        this.config.setShutdownTimeout(shutdownTimeout);
    }

    public void setDefaultErrorHandlerName(String defaultErrorHandlerName) {
        this.config.setDefaultErrorHandlerName(defaultErrorHandlerName);
    }

    public void setDefaultObjectSerializer(ObjectSerializer objectSerializer) {
        this.config.setDefaultObjectSerializer(objectSerializer);
    }

    public void setDefaultProcessingStrategy(ProcessingStrategyFactory processingStrategyFactory) {
        this.config.setDefaultProcessingStrategyFactory(processingStrategyFactory);
    }

    public void setMaxQueueTransactionFilesSize(int queueTransactionFilesSizeInMegabytes) {
        this.config.setMaxQueueTransactionFilesSize(queueTransactionFilesSizeInMegabytes);
    }

    public void setExtensions(List<ConfigurationExtension> extensions) {
        this.config.addExtensions(extensions);
    }
}

