/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.runtime.api.app.declaration.ArtifactDeclaration;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.config.spring.GlobalNamePostProcessor;
import org.mule.runtime.config.spring.MissingParserProblemReporter;
import org.mule.runtime.config.spring.MuleBeanDefinitionDocumentReader;
import org.mule.runtime.config.spring.MuleConfigurationConfigurator;
import org.mule.runtime.config.spring.MuleContextPostProcessor;
import org.mule.runtime.config.spring.MuleDocumentLoader;
import org.mule.runtime.config.spring.MuleDomainBeanDefinitionDocumentReader;
import org.mule.runtime.config.spring.MuleXmlBeanDefinitionReader;
import org.mule.runtime.config.spring.OptionalObjectsController;
import org.mule.runtime.config.spring.SpringMuleContextServiceConfigurator;
import org.mule.runtime.config.spring.XmlConfigurationDocumentLoader;
import org.mule.runtime.config.spring.dsl.api.xml.StaticXmlNamespaceInfo;
import org.mule.runtime.config.spring.dsl.api.xml.StaticXmlNamespaceInfoProvider;
import org.mule.runtime.config.spring.dsl.model.ApplicationModel;
import org.mule.runtime.config.spring.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;
import org.mule.runtime.config.spring.dsl.model.MinimalApplicationModelGenerator;
import org.mule.runtime.config.spring.dsl.processor.ArtifactConfig;
import org.mule.runtime.config.spring.dsl.processor.ConfigFile;
import org.mule.runtime.config.spring.dsl.processor.ConfigLine;
import org.mule.runtime.config.spring.dsl.processor.xml.XmlApplicationParser;
import org.mule.runtime.config.spring.dsl.spring.BeanDefinitionFactory;
import org.mule.runtime.config.spring.editors.MulePropertyEditorRegistrar;
import org.mule.runtime.config.spring.parsers.generic.AutoIdUtils;
import org.mule.runtime.config.spring.processors.ContextExclusiveInjectorProcessor;
import org.mule.runtime.config.spring.processors.DiscardedOptionalBeanPostProcessor;
import org.mule.runtime.config.spring.processors.LifecycleStatePostProcessor;
import org.mule.runtime.config.spring.processors.MuleInjectorProcessor;
import org.mule.runtime.config.spring.processors.PostRegistrationActionsPostProcessor;
import org.mule.runtime.config.spring.util.LaxInstantiationStrategyWrapper;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connectivity.ConnectivityTestingService;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.registry.AbstractServiceRegistry;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.config.ConfigResource;
import org.mule.runtime.core.config.bootstrap.ArtifactType;
import org.mule.runtime.core.exception.ErrorTypeLocator;
import org.mule.runtime.core.exception.ErrorTypeLocatorFactory;
import org.mule.runtime.core.exception.ErrorTypeRepository;
import org.mule.runtime.core.registry.MuleRegistryHelper;
import org.mule.runtime.core.registry.SpiServiceRegistry;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.core.util.collection.ImmutableListCollector;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinitionProvider;
import org.mule.runtime.dsl.api.component.config.ComponentIdentifier;
import org.mule.runtime.dsl.api.xml.XmlNamespaceInfo;
import org.mule.runtime.dsl.api.xml.XmlNamespaceInfoProvider;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.factory.annotation.RequiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.CglibSubclassingInstantiationStrategy;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ConfigurationClassPostProcessor;
import org.springframework.context.annotation.ContextAnnotationAutowireCandidateResolver;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.w3c.dom.Document;

public class MuleArtifactContext
extends AbstractXmlApplicationContext {
    private static final ThreadLocal<MuleContext> currentMuleContext = new ThreadLocal();
    public static final String INNER_BEAN_PREFIX = "(inner bean)";
    protected final ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry = new ComponentBuildingDefinitionRegistry();
    private final OptionalObjectsController optionalObjectsController;
    private final Map<String, String> artifactProperties;
    private final ArtifactDeclaration artifactDeclaration;
    private final XmlConfigurationDocumentLoader xmlConfigurationDocumentLoader;
    protected ApplicationModel applicationModel;
    protected MuleContext muleContext;
    private Resource[] artifactConfigResources;
    protected BeanDefinitionFactory beanDefinitionFactory;
    private MuleXmlBeanDefinitionReader beanDefinitionReader;
    private final ServiceRegistry serviceRegistry = new SpiServiceRegistry();
    protected boolean useNewParsingMechanism = true;
    protected final XmlApplicationParser xmlApplicationParser;
    private ArtifactType artifactType;
    private List<ComponentIdentifier> componentNotSupportedByNewParsers = new ArrayList<ComponentIdentifier>();

    public MuleArtifactContext(MuleContext muleContext, ConfigResource[] artifactConfigResources, ArtifactDeclaration artifactDeclaration, OptionalObjectsController optionalObjectsController, Map<String, String> artifactProperties, ArtifactType artifactType) throws BeansException {
        this(muleContext, MuleArtifactContext.convert(artifactConfigResources), artifactDeclaration, optionalObjectsController, artifactProperties, artifactType);
    }

    public MuleArtifactContext(MuleContext muleContext, Resource[] artifactConfigResources, ArtifactDeclaration artifactDeclaration, OptionalObjectsController optionalObjectsController, Map<String, String> artifactProperties, ArtifactType artifactType) {
        Preconditions.checkArgument((optionalObjectsController != null ? 1 : 0) != 0, (String)"optionalObjectsController cannot be null");
        this.muleContext = muleContext;
        this.artifactConfigResources = artifactConfigResources;
        this.optionalObjectsController = optionalObjectsController;
        this.artifactProperties = artifactProperties;
        this.artifactType = artifactType;
        this.artifactDeclaration = artifactDeclaration;
        this.xmlConfigurationDocumentLoader = this.newXmlConfigurationDocumentLoader();
        this.serviceRegistry.lookupProviders(ComponentBuildingDefinitionProvider.class, Thread.currentThread().getContextClassLoader()).forEach(componentBuildingDefinitionProvider -> {
            if (componentBuildingDefinitionProvider instanceof MuleContextAware) {
                ((MuleContextAware)componentBuildingDefinitionProvider).setMuleContext(muleContext);
            }
            componentBuildingDefinitionProvider.init();
            componentBuildingDefinitionProvider.getComponentBuildingDefinitions().forEach(this.componentBuildingDefinitionRegistry::register);
        });
        this.xmlApplicationParser = new XmlApplicationParser((ServiceRegistry)new XmlServiceRegistry(this.serviceRegistry, muleContext));
        this.beanDefinitionFactory = new BeanDefinitionFactory(this.componentBuildingDefinitionRegistry, muleContext.getErrorTypeRepository());
        this.createApplicationModel();
        this.determineIfOnlyNewParsingMechanismCanBeUsed();
    }

    protected XmlConfigurationDocumentLoader newXmlConfigurationDocumentLoader() {
        return new XmlConfigurationDocumentLoader();
    }

    private ErrorTypeLocator createComponentErrorTypeLocator(ErrorTypeRepository errorTypeRepository) {
        return ErrorTypeLocatorFactory.createDefaultErrorTypeLocator((ErrorTypeRepository)errorTypeRepository);
    }

    private void determineIfOnlyNewParsingMechanismCanBeUsed() {
        if (this.applicationModel.hasSpringConfig()) {
            this.useNewParsingMechanism = false;
            return;
        }
        this.applicationModel.executeOnEveryComponentTree(componentModel -> {
            Optional<ComponentIdentifier> parentIdentifierOptional = Optional.ofNullable(componentModel.getParent()).flatMap(parentComponentModel -> Optional.ofNullable(parentComponentModel.getIdentifier()));
            if (!this.beanDefinitionFactory.hasDefinition(componentModel.getIdentifier(), parentIdentifierOptional)) {
                this.componentNotSupportedByNewParsers.add(componentModel.getIdentifier());
                this.useNewParsingMechanism = false;
            }
        });
    }

    private void createApplicationModel() {
        try {
            ArtifactConfig.Builder applicationConfigBuilder = new ArtifactConfig.Builder();
            applicationConfigBuilder.setApplicationProperties(this.artifactProperties);
            for (Resource springResource : this.artifactConfigResources) {
                Document document = this.xmlConfigurationDocumentLoader.loadDocument(Optional.ofNullable(this.muleContext.getExtensionManager()), springResource.getFilename(), springResource.getInputStream());
                ConfigLine mainConfigLine = this.xmlApplicationParser.parse(document.getDocumentElement()).get();
                applicationConfigBuilder.addConfigFile(new ConfigFile(this.getFilename(springResource), Arrays.asList(mainConfigLine)));
            }
            applicationConfigBuilder.setApplicationName(this.muleContext.getConfiguration().getId());
            this.applicationModel = new ApplicationModel(applicationConfigBuilder.build(), this.artifactDeclaration, Optional.ofNullable(this.muleContext.getExtensionManager()), Optional.of(this.componentBuildingDefinitionRegistry));
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private String getFilename(Resource resource) {
        if (resource instanceof ByteArrayResource) {
            return resource.getDescription();
        }
        return resource.getFilename();
    }

    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.prepareBeanFactory(beanFactory);
        this.registerEditors(beanFactory);
        this.addBeanPostProcessors(beanFactory, new BeanPostProcessor[]{new MuleContextPostProcessor(this.muleContext), new GlobalNamePostProcessor(), new PostRegistrationActionsPostProcessor((MuleRegistryHelper)this.muleContext.getRegistry(), beanFactory), new DiscardedOptionalBeanPostProcessor(this.optionalObjectsController, (DefaultListableBeanFactory)beanFactory), new LifecycleStatePostProcessor(this.muleContext.getLifecycleManager().getState())});
        beanFactory.registerSingleton("_muleContext", (Object)this.muleContext);
    }

    private void registerEditors(ConfigurableListableBeanFactory beanFactory) {
        MulePropertyEditorRegistrar registrar = new MulePropertyEditorRegistrar();
        registrar.setMuleContext(this.muleContext);
        beanFactory.addPropertyEditorRegistrar((PropertyEditorRegistrar)registrar);
    }

    private void addBeanPostProcessors(ConfigurableListableBeanFactory beanFactory, BeanPostProcessor ... processors) {
        for (BeanPostProcessor processor : processors) {
            beanFactory.addBeanPostProcessor(processor);
        }
    }

    public void close() {
        super.close();
        this.beanDefinitionFactory.destroy();
    }

    private static Resource[] convert(ConfigResource[] resources) {
        Resource[] configResources = new Resource[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            ConfigResource resource = resources[i];
            if (resource.getUrl() != null) {
                configResources[i] = new UrlResource(resource.getUrl());
                continue;
            }
            try {
                configResources[i] = new ByteArrayResource(IOUtils.toByteArray((InputStream)resource.getInputStream()), resource.getResourceName());
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return configResources;
    }

    protected Resource[] getConfigResources() {
        return (Resource[])ArrayUtils.addAll((Object[])this.artifactConfigResources, (Object[])new Resource[0]);
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException {
        BeanDefinitionReader beanDefinitionReader = this.createBeanDefinitionReader(beanFactory);
        try {
            currentMuleContext.set(this.muleContext);
            this.createInitialApplicationComponents(beanFactory, beanDefinitionReader);
        }
        finally {
            currentMuleContext.remove();
        }
    }

    protected void createInitialApplicationComponents(DefaultListableBeanFactory beanFactory, BeanDefinitionReader beanDefinitionReader) {
        if (this.useNewParsingMechanism) {
            this.createApplicationComponents(beanFactory, this.applicationModel, true);
        } else {
            this.logger.info((Object)("Using mixed mechanism to load configuration since there are some components that were not yet migrated to the new mechanism: " + this.getOldParsingMechanismComponentIdentifiers()));
            beanDefinitionReader.loadBeanDefinitions(this.getConfigResources());
        }
    }

    protected List<String> createApplicationComponents(DefaultListableBeanFactory beanFactory, ApplicationModel applicationModel, boolean mustBeRoot) {
        ArrayList<String> createdComponentModels = new ArrayList<String>();
        applicationModel.executeOnEveryMuleComponentTree(componentModel -> {
            if (!mustBeRoot || componentModel.isRoot()) {
                if (componentModel.getIdentifier().equals((Object)ApplicationModel.MULE_IDENTIFIER)) {
                    return;
                }
                if (componentModel.getNameAttribute() != null) {
                    createdComponentModels.add(componentModel.getNameAttribute());
                }
                this.beanDefinitionFactory.resolveComponentRecursively(applicationModel.getRootComponentModel(), (ComponentModel)componentModel, beanFactory, (resolvedComponentModel, registry) -> {
                    if (resolvedComponentModel.isRoot()) {
                        String nameAttribute = resolvedComponentModel.getNameAttribute();
                        if (resolvedComponentModel.getIdentifier().equals((Object)ApplicationModel.CONFIGURATION_IDENTIFIER)) {
                            nameAttribute = "_muleConfiguration";
                        } else if (nameAttribute == null) {
                            nameAttribute = AutoIdUtils.uniqueValue(resolvedComponentModel.getBeanDefinition().getBeanClassName());
                        }
                        registry.registerBeanDefinition(nameAttribute, resolvedComponentModel.getBeanDefinition());
                        MuleArtifactContext.postProcessBeanDefinition(componentModel, registry, nameAttribute);
                    }
                }, null);
            }
        });
        return createdComponentModels;
    }

    protected String getOldParsingMechanismComponentIdentifiers() {
        return StringUtils.join((Object[])this.componentNotSupportedByNewParsers.toArray(), (String)",");
    }

    protected void customizeBeanFactory(DefaultListableBeanFactory beanFactory) {
        super.customizeBeanFactory(beanFactory);
        new SpringMuleContextServiceConfigurator(this.muleContext, this.artifactType, this.optionalObjectsController, beanFactory).createArtifactServices();
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        Optional<ComponentModel> configurationOptional = this.applicationModel.findComponentDefinitionModel(ApplicationModel.CONFIGURATION_IDENTIFIER);
        if (configurationOptional.isPresent()) {
            return;
        }
        BeanDefinitionRegistry beanDefinitionRegistry = (BeanDefinitionRegistry)beanFactory;
        beanDefinitionRegistry.registerBeanDefinition("_muleConfiguration", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(MuleConfigurationConfigurator.class).getBeanDefinition());
    }

    protected BeanDefinitionReader createBeanDefinitionReader(DefaultListableBeanFactory beanFactory) {
        this.beanDefinitionReader = new MuleXmlBeanDefinitionReader(beanFactory, this.createBeanDefinitionDocumentReader(this.beanDefinitionFactory));
        this.beanDefinitionReader.setDocumentLoader(this.createLoader());
        this.beanDefinitionReader.setDocumentReaderClass(this.getBeanDefinitionDocumentReaderClass());
        this.beanDefinitionReader.setProblemReporter((ProblemReporter)new MissingParserProblemReporter());
        this.registerAnnotationConfigProcessors(this.beanDefinitionReader.getRegistry(), null);
        return this.beanDefinitionReader;
    }

    protected MuleBeanDefinitionDocumentReader createBeanDefinitionDocumentReader(BeanDefinitionFactory beanDefinitionFactory) {
        if (this.artifactType.equals((Object)ArtifactType.DOMAIN)) {
            return new MuleDomainBeanDefinitionDocumentReader(beanDefinitionFactory, this.xmlApplicationParser);
        }
        return new MuleBeanDefinitionDocumentReader(beanDefinitionFactory, this.xmlApplicationParser);
    }

    protected MuleDocumentLoader createLoader() {
        return new MuleDocumentLoader();
    }

    private void registerAnnotationConfigProcessors(BeanDefinitionRegistry registry, Object source) {
        this.registerAnnotationConfigProcessor(registry, "org.springframework.context.annotation.internalConfigurationAnnotationProcessor", ConfigurationClassPostProcessor.class, source);
        this.registerAnnotationConfigProcessor(registry, "org.springframework.context.annotation.internalRequiredAnnotationProcessor", RequiredAnnotationBeanPostProcessor.class, source);
        this.registerInjectorProcessor(registry);
    }

    protected void registerInjectorProcessor(BeanDefinitionRegistry registry) {
        if (this.artifactType.equals((Object)ArtifactType.APP)) {
            this.registerAnnotationConfigProcessor(registry, "org.springframework.context.annotation.internalAutowiredAnnotationProcessor", MuleInjectorProcessor.class, null);
        } else if (this.artifactType.equals((Object)ArtifactType.DOMAIN)) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ContextExclusiveInjectorProcessor.class);
            builder.addConstructorArgValue((Object)this);
            this.registerPostProcessor(registry, (RootBeanDefinition)builder.getBeanDefinition(), "org.springframework.context.annotation.internalAutowiredAnnotationProcessor");
        }
    }

    private void registerAnnotationConfigProcessor(BeanDefinitionRegistry registry, String key, Class<?> type, Object source) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition(type);
        beanDefinition.setSource(source);
        this.registerPostProcessor(registry, beanDefinition, key);
    }

    protected void registerPostProcessor(BeanDefinitionRegistry registry, RootBeanDefinition definition, String beanName) {
        definition.setRole(2);
        registry.registerBeanDefinition(beanName, (BeanDefinition)definition);
    }

    protected Class<? extends MuleBeanDefinitionDocumentReader> getBeanDefinitionDocumentReaderClass() {
        if (this.artifactType.equals((Object)ArtifactType.DOMAIN)) {
            return MuleDomainBeanDefinitionDocumentReader.class;
        }
        return MuleBeanDefinitionDocumentReader.class;
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory(this.getInternalParentBeanFactory());
        beanFactory.setAutowireCandidateResolver((AutowireCandidateResolver)new ContextAnnotationAutowireCandidateResolver());
        beanFactory.setInstantiationStrategy(new LaxInstantiationStrategyWrapper((InstantiationStrategy)new CglibSubclassingInstantiationStrategy(), this.optionalObjectsController));
        return beanFactory;
    }

    public boolean isRunning() {
        try {
            return super.isRunning();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    protected static void postProcessBeanDefinition(ComponentModel resolvedComponent, BeanDefinitionRegistry registry, String beanName) {
        if (Converter.class.isAssignableFrom(resolvedComponent.getType())) {
            GenericBeanDefinition converterBeanDefinitionCopy = new GenericBeanDefinition(resolvedComponent.getBeanDefinition());
            converterBeanDefinitionCopy.setScope("singleton");
            registry.registerBeanDefinition(beanName + "-converter", (BeanDefinition)converterBeanDefinitionCopy);
        }
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    protected OptionalObjectsController getOptionalObjectsController() {
        return this.optionalObjectsController;
    }

    public static ThreadLocal<MuleContext> getCurrentMuleContext() {
        return currentMuleContext;
    }

    public void initializeComponent(String componentName) {
        if (this.muleContext.getRegistry().get(componentName) != null) {
            return;
        }
        MinimalApplicationModelGenerator minimalApplicationModelGenerator = new MinimalApplicationModelGenerator(this.applicationModel, this.componentBuildingDefinitionRegistry);
        ApplicationModel minimalApplicationModel = !componentName.contains("/") ? minimalApplicationModelGenerator.getMinimalModelByName(componentName) : minimalApplicationModelGenerator.getMinimalModelByPath(componentName);
        this.createApplicationComponents((DefaultListableBeanFactory)this.getBeanFactory(), minimalApplicationModel, false);
    }

    public ConnectivityTestingService getConnectivityTestingService() {
        return (ConnectivityTestingService)this.muleContext.getRegistry().lookupObject("_muleConnectivityTestingService");
    }

    public MetadataService getMetadataService() {
        return (MetadataService)this.muleContext.getRegistry().get("_muleMetadataService");
    }

    private class XmlServiceRegistry
    extends AbstractServiceRegistry {
        private final ServiceRegistry delegate;
        private final XmlNamespaceInfoProvider extensionsXmlInfoProvider;

        public XmlServiceRegistry(ServiceRegistry delegate, MuleContext muleContext) {
            this.delegate = delegate;
            ExtensionManager extensionManager = muleContext.getExtensionManager();
            Object extensionNamespaces = extensionManager != null ? (List)extensionManager.getExtensions().stream().map(ext -> {
                XmlDslModel xmlDslModel = ext.getXmlDslModel();
                return xmlDslModel != null ? new StaticXmlNamespaceInfo(xmlDslModel.getNamespaceUri(), xmlDslModel.getNamespace()) : null;
            }).filter(info -> info != null).collect(new ImmutableListCollector()) : ImmutableList.of();
            this.extensionsXmlInfoProvider = new StaticXmlNamespaceInfoProvider((Collection<XmlNamespaceInfo>)extensionNamespaces);
        }

        protected <T> Collection<T> doLookupProviders(Class<T> providerClass, ClassLoader classLoader) {
            Collection providers = this.delegate.lookupProviders(providerClass, classLoader);
            if (XmlNamespaceInfoProvider.class.equals(providerClass)) {
                providers = ImmutableList.builder().addAll((Iterable)providers).add((Object)this.extensionsXmlInfoProvider).build();
            }
            return providers;
        }
    }
}

