/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.util;

import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.core.util.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SpringXMLUtils
extends XMLUtils {
    private static final Logger logger = LoggerFactory.getLogger(SpringXMLUtils.class);
    public static final String MULE_DEFAULT_NAMESPACE = "http://www.mulesoft.org/schema/mule/core";
    public static final String MULE_NAMESPACE_PREFIX = "http://www.mulesoft.org/schema/mule/";

    public static boolean isMuleNamespace(Element element) {
        String ns = element.getNamespaceURI();
        return ns != null && ns.startsWith(MULE_NAMESPACE_PREFIX);
    }

    public static boolean isBeansNamespace(Element element) {
        String ns = element.getNamespaceURI();
        return ns != null && ns.equals("http://www.springframework.org/schema/beans");
    }

    public static String getNameOrId(Element element) {
        String id = element.getAttribute("id");
        String name = element.getAttribute("name");
        if (StringUtils.isBlank((String)id)) {
            if (StringUtils.isBlank((String)name)) {
                return "";
            }
            return name;
        }
        if (!StringUtils.isBlank((String)name) && !name.equals(id)) {
            logger.warn("Id (" + id + ") and name (" + name + ") differ for " + SpringXMLUtils.elementToString((Element)element));
        }
        return id;
    }
}

