/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.factories;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.store.ObjectStore;
import org.mule.runtime.core.source.polling.watermark.UpdateExpressionWatermark;
import org.mule.runtime.core.source.polling.watermark.Watermark;
import org.mule.runtime.core.source.polling.watermark.selector.SelectorWatermark;
import org.mule.runtime.core.source.polling.watermark.selector.WatermarkSelectorBroker;
import org.mule.runtime.core.util.store.MuleObjectStoreManager;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class WatermarkFactoryBean
extends AbstractFactoryBean<Watermark>
implements MuleContextAware,
AnnotatedObject {
    public static final String MULE_WATERMARK_PARTITION = "mule.watermark";
    private static final String DEFAULT_SELECTOR_EXPRESSION = "#[payload]";
    private String variable;
    private String defaultExpression;
    private String updateExpression;
    private WatermarkSelectorBroker selector;
    private String selectorExpression;
    private ObjectStore<Serializable> objectStore;
    private Map<QName, Object> annotations = new HashMap<QName, Object>();
    private MuleContext muleContext;

    public Class<?> getObjectType() {
        return Watermark.class;
    }

    protected Watermark createInstance() throws Exception {
        if (this.selector != null) {
            if (!StringUtils.isEmpty((String)this.updateExpression)) {
                throw new IllegalArgumentException("You specified a watermark with both an update expression and a selector and/or a selector.\nThose cannot co-exist. You have to either specify an updateExpression or selector options");
            }
            String selectorExpression = StringUtils.isEmpty((String)this.selectorExpression) ? DEFAULT_SELECTOR_EXPRESSION : this.selectorExpression;
            return new SelectorWatermark(this.acquireObjectStore(), this.variable, this.defaultExpression, this.selector, selectorExpression);
        }
        return new UpdateExpressionWatermark(this.acquireObjectStore(), this.variable, this.defaultExpression, this.updateExpression);
    }

    private ObjectStore<Serializable> acquireObjectStore() {
        ObjectStore os = this.objectStore;
        if (os == null) {
            MuleObjectStoreManager mgr = (MuleObjectStoreManager)this.muleContext.getObjectStoreManager();
            os = mgr.getUserObjectStore(MULE_WATERMARK_PARTITION, true);
        }
        return os;
    }

    public void setObjectStore(ObjectStore<Serializable> objectStore) {
        this.objectStore = objectStore;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public void setDefaultExpression(String defaultExpression) {
        this.defaultExpression = defaultExpression;
    }

    public void setUpdateExpression(String updateExpression) {
        this.updateExpression = updateExpression;
    }

    public void setSelector(WatermarkSelectorBroker selector) {
        this.selector = selector;
    }

    public void setSelectorExpression(String selectorExpression) {
        this.selectorExpression = selectorExpression;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public Object getAnnotation(QName name) {
        return this.annotations.get(name);
    }

    public Map<QName, Object> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Map<QName, Object> annotations) {
        this.annotations = annotations;
    }
}

