/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.spring;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.beanutils.BeanUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.config.spring.dsl.model.ApplicationModel;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;
import org.mule.runtime.config.spring.dsl.processor.ObjectTypeVisitor;
import org.mule.runtime.config.spring.dsl.processor.xml.XmlCustomAttributeHandler;
import org.mule.runtime.config.spring.dsl.spring.BeanDefinitionBuilderHelper;
import org.mule.runtime.config.spring.dsl.spring.BeanDefinitionCreator;
import org.mule.runtime.config.spring.dsl.spring.ComponentConfigurationBuilder;
import org.mule.runtime.config.spring.dsl.spring.CreateBeanDefinitionRequest;
import org.mule.runtime.config.spring.dsl.spring.ObjectFactoryClassRepository;
import org.mule.runtime.config.spring.dsl.spring.PropertyComponentUtils;
import org.mule.runtime.config.spring.parsers.AbstractMuleBeanDefinitionParser;
import org.mule.runtime.core.api.routing.filter.Filter;
import org.mule.runtime.core.api.security.SecurityFilter;
import org.mule.runtime.core.processor.SecurityFilterMessageProcessor;
import org.mule.runtime.core.routing.MessageFilter;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.ComponentIdentifier;
import org.mule.runtime.dsl.api.component.ObjectFactory;
import org.mule.runtime.dsl.api.component.TypeDefinitionVisitor;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CommonBeanDefinitionCreator
extends BeanDefinitionCreator {
    private static final String TRANSPORT_BEAN_DEFINITION_POST_PROCESSOR_CLASS = "org.mule.compatibility.config.spring.parsers.specific.TransportElementBeanDefinitionPostProcessor";
    private static final ImmutableSet<ComponentIdentifier> MESSAGE_FILTER_WRAPPERS = new ImmutableSet.Builder().add((Object)ApplicationModel.MESSAGE_FILTER_ELEMENT_IDENTIFIER).add((Object)ApplicationModel.MULE_IDENTIFIER).add((Object)ApplicationModel.DEFAULT_ES_ELEMENT_IDENTIFIER).build();
    private Set<ComponentIdentifier> genericPropertiesCustomProcessingIdentifiers = ImmutableSet.builder().add((Object)ApplicationModel.SINGLETON_OBJECT_IDENTIFIER).add((Object)ApplicationModel.PROTOTYPE_OBJECT_IDENTIFIER).add((Object)ApplicationModel.CUSTOM_TRANSFORMER_IDENTIFIER).build();
    private final ObjectFactoryClassRepository objectFactoryClassRepository;
    private BeanDefinitionPostProcessor beanDefinitionPostProcessor;

    public CommonBeanDefinitionCreator(ObjectFactoryClassRepository objectFactoryClassRepository) {
        this.objectFactoryClassRepository = objectFactoryClassRepository;
        try {
            this.beanDefinitionPostProcessor = (BeanDefinitionPostProcessor)ClassUtils.getClass((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)TRANSPORT_BEAN_DEFINITION_POST_PROCESSOR_CLASS).newInstance();
        }
        catch (Exception e) {
            this.beanDefinitionPostProcessor = (componentModel, beanDefinition) -> {};
        }
    }

    @Override
    public boolean handleRequest(CreateBeanDefinitionRequest request) {
        ComponentModel componentModel = request.getComponentModel();
        ComponentBuildingDefinition buildingDefinition = request.getComponentBuildingDefinition();
        componentModel.setType(this.retrieveComponentType(componentModel, buildingDefinition));
        BeanDefinitionBuilder beanDefinitionBuilder = this.createBeanDefinitionBuilder(componentModel, buildingDefinition);
        this.processAnnotations(componentModel, beanDefinitionBuilder);
        this.processComponentDefinitionModel(request.getParentComponentModel(), componentModel, buildingDefinition, beanDefinitionBuilder);
        return true;
    }

    private BeanDefinitionBuilder createBeanDefinitionBuilder(ComponentModel componentModel, ComponentBuildingDefinition buildingDefinition) {
        BeanDefinitionBuilder beanDefinitionBuilder = buildingDefinition.getObjectFactoryType() != null ? this.createBeanDefinitionBuilderFromObjectFactory(componentModel, buildingDefinition) : BeanDefinitionBuilder.genericBeanDefinition(componentModel.getType());
        return beanDefinitionBuilder;
    }

    private void processAnnotationParameters(ComponentModel componentModel, Map<QName, Object> annotations) {
        componentModel.getParameters().entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(":")).forEach(annotationKey -> {
            Node attribute = XmlCustomAttributeHandler.from(componentModel).getNode().getAttributes().getNamedItem((String)annotationKey.getKey());
            if (attribute != null) {
                annotations.put(new QName(attribute.getNamespaceURI(), attribute.getLocalName()), annotationKey.getValue());
            }
        });
    }

    private void processNestedAnnotations(ComponentModel componentModel, Map<QName, Object> previousAnnotations) {
        componentModel.getInnerComponents().stream().filter(cdm -> cdm.getIdentifier().equals((Object)ApplicationModel.ANNOTATIONS_ELEMENT_IDENTIFIER)).findFirst().ifPresent(annotationsCdm -> annotationsCdm.getInnerComponents().forEach(annotationCdm -> previousAnnotations.put(new QName(XmlCustomAttributeHandler.from(annotationCdm).getNamespaceUri(), annotationCdm.getIdentifier().getName()), annotationCdm.getTextContent())));
    }

    private void processAnnotations(ComponentModel componentModel, BeanDefinitionBuilder beanDefinitionBuilder) {
        if (AnnotatedObject.class.isAssignableFrom(componentModel.getType())) {
            XmlCustomAttributeHandler.ComponentCustomAttributeRetrieve customAttributeRetrieve = XmlCustomAttributeHandler.from(componentModel);
            Map<QName, Object> annotations = AbstractMuleBeanDefinitionParser.processMetadataAnnotationsHelper((Element)customAttributeRetrieve.getNode(), customAttributeRetrieve.getConfigFileName(), beanDefinitionBuilder);
            this.processAnnotationParameters(componentModel, annotations);
            this.processNestedAnnotations(componentModel, annotations);
            if (!annotations.isEmpty()) {
                beanDefinitionBuilder.addPropertyValue("annotations", annotations);
            }
        }
    }

    private Class<?> retrieveComponentType(ComponentModel componentModel, ComponentBuildingDefinition componentBuildingDefinition) {
        ObjectTypeVisitor objectTypeVisitor = new ObjectTypeVisitor(componentModel);
        componentBuildingDefinition.getTypeDefinition().visit((TypeDefinitionVisitor)objectTypeVisitor);
        return objectTypeVisitor.getType();
    }

    private BeanDefinitionBuilder createBeanDefinitionBuilderFromObjectFactory(ComponentModel componentModel, ComponentBuildingDefinition componentBuildingDefinition) {
        ObjectTypeVisitor objectTypeVisitor = new ObjectTypeVisitor(componentModel);
        componentBuildingDefinition.getTypeDefinition().visit((TypeDefinitionVisitor)objectTypeVisitor);
        Class objectFactoryType = componentBuildingDefinition.getObjectFactoryType();
        Map<String, Object> customProperties = this.getTransformerCustomProperties(componentModel);
        Optional<Consumer<Object>> instanceCustomizationFunction = Optional.empty();
        if (!customProperties.isEmpty()) {
            instanceCustomizationFunction = Optional.of(object -> this.injectSpringProperties(customProperties, object));
        }
        Class<ObjectFactory> factoryBeanClass = this.objectFactoryClassRepository.getObjectFactoryClass(componentBuildingDefinition, objectFactoryType, objectTypeVisitor.getType(), () -> componentModel.getBeanDefinition().isLazyInit(), instanceCustomizationFunction);
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(factoryBeanClass);
        return beanDefinitionBuilder;
    }

    private void injectSpringProperties(Map<String, Object> customProperties, Object createdInstance) {
        try {
            for (String propertyName : customProperties.keySet()) {
                BeanUtils.copyProperty((Object)createdInstance, (String)propertyName, (Object)customProperties.get(propertyName));
            }
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private Map<String, Object> getTransformerCustomProperties(ComponentModel componentModel) {
        ComponentIdentifier identifier = componentModel.getIdentifier();
        if (!identifier.equals((Object)ApplicationModel.CUSTOM_TRANSFORMER_IDENTIFIER)) {
            return Collections.emptyMap();
        }
        return componentModel.getInnerComponents().stream().filter(innerComponent -> {
            ComponentIdentifier childIdentifier = innerComponent.getIdentifier();
            return childIdentifier.equals((Object)ApplicationModel.SPRING_PROPERTY_IDENTIFIER) || childIdentifier.equals((Object)ApplicationModel.MULE_PROPERTY_IDENTIFIER);
        }).collect(Collectors.toMap(springComponent -> PropertyComponentUtils.getPropertyValueFromPropertyComponent(springComponent).getName(), springComponent -> PropertyComponentUtils.getPropertyValueFromPropertyComponent(springComponent).getValue()));
    }

    private void processComponentDefinitionModel(ComponentModel parentComponentModel, ComponentModel componentModel, ComponentBuildingDefinition componentBuildingDefinition, BeanDefinitionBuilder beanDefinitionBuilder) {
        AbstractBeanDefinition wrappedBeanDefinition;
        AbstractBeanDefinition originalBeanDefinition;
        this.processObjectConstructionParameters(componentModel, componentBuildingDefinition, new BeanDefinitionBuilderHelper(beanDefinitionBuilder));
        this.processSpringOrMuleProperties(componentModel, beanDefinitionBuilder);
        if (componentBuildingDefinition.isPrototype()) {
            beanDefinitionBuilder.setScope("prototype");
        }
        if ((originalBeanDefinition = beanDefinitionBuilder.getBeanDefinition()) != (wrappedBeanDefinition = CommonBeanDefinitionCreator.adaptFilterBeanDefinitions(parentComponentModel, originalBeanDefinition))) {
            componentModel.setType(wrappedBeanDefinition.getBeanClass());
        }
        this.beanDefinitionPostProcessor.postProcess(componentModel, wrappedBeanDefinition);
        componentModel.setBeanDefinition((BeanDefinition)wrappedBeanDefinition);
    }

    private void processSpringOrMuleProperties(ComponentModel componentModel, BeanDefinitionBuilder beanDefinitionBuilder) {
        if (this.genericPropertiesCustomProcessingIdentifiers.contains(componentModel.getIdentifier())) {
            return;
        }
        componentModel.getInnerComponents().stream().filter(innerComponent -> {
            ComponentIdentifier identifier = innerComponent.getIdentifier();
            return identifier.equals((Object)ApplicationModel.SPRING_PROPERTY_IDENTIFIER) || identifier.equals((Object)ApplicationModel.MULE_PROPERTY_IDENTIFIER);
        }).forEach(propertyComponentModel -> {
            PropertyValue propertyValue = PropertyComponentUtils.getPropertyValueFromPropertyComponent(propertyComponentModel);
            beanDefinitionBuilder.addPropertyValue(propertyValue.getName(), propertyValue.getValue());
        });
    }

    public static List<PropertyValue> getPropertyValueFromPropertiesComponent(ComponentModel propertyComponentModel) {
        ArrayList<PropertyValue> propertyValues = new ArrayList<PropertyValue>();
        propertyComponentModel.getInnerComponents().stream().forEach(entryComponentModel -> propertyValues.add(new PropertyValue(entryComponentModel.getParameters().get("key"), (Object)entryComponentModel.getParameters().get("value"))));
        return propertyValues;
    }

    private void processObjectConstructionParameters(ComponentModel componentModel, ComponentBuildingDefinition componentBuildingDefinition, BeanDefinitionBuilderHelper beanDefinitionBuilderHelper) {
        new ComponentConfigurationBuilder(componentModel, componentBuildingDefinition, beanDefinitionBuilderHelper).processConfiguration();
    }

    public static AbstractBeanDefinition adaptFilterBeanDefinitions(ComponentModel parentComponentModel, AbstractBeanDefinition originalBeanDefinition) {
        Class beanClass;
        if (originalBeanDefinition == null) {
            return null;
        }
        if (!CommonBeanDefinitionCreator.filterWrapperRequired(parentComponentModel)) {
            return originalBeanDefinition;
        }
        if (originalBeanDefinition instanceof RootBeanDefinition) {
            beanClass = ((RootBeanDefinition)originalBeanDefinition).getBeanClass();
        } else {
            if (originalBeanDefinition.getBeanClassName() == null) {
                return originalBeanDefinition;
            }
            try {
                beanClass = ClassUtils.getClass((String)originalBeanDefinition.getBeanClassName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (CommonBeanDefinitionCreator.areMatchingTypes(Filter.class, beanClass)) {
            boolean failOnUnaccepted = false;
            Object processorWhenUnaccepted = null;
            AbstractBeanDefinition newBeanDefinition = BeanDefinitionBuilder.rootBeanDefinition(MessageFilter.class).addConstructorArgValue((Object)originalBeanDefinition).addConstructorArgValue((Object)failOnUnaccepted).addConstructorArgValue(processorWhenUnaccepted).getBeanDefinition();
            return newBeanDefinition;
        }
        if (CommonBeanDefinitionCreator.areMatchingTypes(SecurityFilter.class, beanClass)) {
            AbstractBeanDefinition newBeanDefinition = BeanDefinitionBuilder.rootBeanDefinition(SecurityFilterMessageProcessor.class).addPropertyValue("filter", (Object)originalBeanDefinition).getBeanDefinition();
            return newBeanDefinition;
        }
        return originalBeanDefinition;
    }

    private static boolean filterWrapperRequired(ComponentModel parentComponentModel) {
        return !MESSAGE_FILTER_WRAPPERS.contains((Object)parentComponentModel.getIdentifier()) && !parentComponentModel.getIdentifier().getName().endsWith("-filter");
    }

    public static boolean areMatchingTypes(Class<?> superType, Class<?> childType) {
        return superType.isAssignableFrom(childType);
    }

    public static interface BeanDefinitionPostProcessor {
        public void postProcess(ComponentModel var1, AbstractBeanDefinition var2);
    }
}

