/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.config.spring.CompositeOptionalObjectsController;
import org.mule.runtime.config.spring.DefaultOptionalObjectsController;
import org.mule.runtime.config.spring.LazyMuleArtifactContext;
import org.mule.runtime.config.spring.MuleArtifactContext;
import org.mule.runtime.config.spring.OptionalObjectsController;
import org.mule.runtime.config.spring.SpringRegistry;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.ParentMuleContextAwareConfigurationBuilder;
import org.mule.runtime.core.api.lifecycle.LifecycleManager;
import org.mule.runtime.core.api.registry.Registry;
import org.mule.runtime.core.config.ConfigResource;
import org.mule.runtime.core.config.bootstrap.ArtifactType;
import org.mule.runtime.core.config.builders.AbstractResourceConfigurationBuilder;
import org.mule.runtime.deployment.model.api.artifact.MuleContextServiceConfigurator;
import org.mule.runtime.dsl.api.config.ArtifactConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringXmlConfigurationBuilder
extends AbstractResourceConfigurationBuilder
implements ParentMuleContextAwareConfigurationBuilder {
    private ArtifactConfiguration artifactConfiguration = new ArtifactConfiguration(Collections.emptyList());
    private boolean enableLazyInit = false;
    protected boolean useDefaultConfigResource = true;
    protected boolean useMinimalConfigResource = false;
    protected SpringRegistry registry;
    protected ApplicationContext domainContext;
    protected ApplicationContext parentContext;
    protected MuleArtifactContext muleArtifactContext;
    private ArtifactType artifactType;
    private final List<MuleContextServiceConfigurator> serviceConfigurators = new ArrayList<MuleContextServiceConfigurator>();

    public SpringXmlConfigurationBuilder(String[] configResources, Map<String, String> artifactProperties, ArtifactType artifactType) throws ConfigurationException {
        super(configResources, artifactProperties);
        this.artifactType = artifactType;
    }

    public SpringXmlConfigurationBuilder(String configResources, Map<String, String> artifactProperties, ArtifactType artifactType) throws ConfigurationException {
        this(new String[]{configResources}, artifactProperties, artifactType);
    }

    public SpringXmlConfigurationBuilder(ConfigResource[] configResources, Map<String, String> artifactProperties, ArtifactType artifactType) {
        super(configResources, artifactProperties);
        this.artifactType = artifactType;
    }

    public SpringXmlConfigurationBuilder(String configResource) throws ConfigurationException {
        this(configResource, Collections.emptyMap(), ArtifactType.APP);
    }

    public SpringXmlConfigurationBuilder(String[] configFiles, boolean enableLazyInit) throws ConfigurationException {
        super(configFiles, Collections.emptyMap());
        this.artifactType = ArtifactType.APP;
        this.enableLazyInit = enableLazyInit;
    }

    public SpringXmlConfigurationBuilder(String[] configurationFiles, ArtifactConfiguration artifactConfiguration, Map<String, String> artifactProperties, ArtifactType artifactType, boolean enableLazyInitialisation) throws ConfigurationException {
        this(configurationFiles, artifactProperties, artifactType);
        this.artifactConfiguration = artifactConfiguration;
        this.artifactType = ArtifactType.APP;
        this.enableLazyInit = enableLazyInitialisation;
    }

    public void addServiceConfigurator(MuleContextServiceConfigurator serviceConfigurator) {
        Preconditions.checkArgument((serviceConfigurator != null ? 1 : 0) != 0, (String)"serviceConfigurator cannot be null");
        this.serviceConfigurators.add(serviceConfigurator);
    }

    protected void doConfigure(MuleContext muleContext) throws Exception {
        this.muleArtifactContext = this.createApplicationContext(muleContext);
        this.createSpringRegistry(muleContext, (ApplicationContext)this.muleArtifactContext);
    }

    protected void addResources(List<ConfigResource> allResources) {
    }

    public void unconfigure(MuleContext muleContext) {
        this.registry.dispose();
        if (muleContext != null) {
            muleContext.removeRegistry((Registry)this.registry);
        }
        this.registry = null;
        this.configured = false;
    }

    private MuleArtifactContext createApplicationContext(MuleContext muleContext) throws Exception {
        ApplicationContext parentApplicationContext;
        OptionalObjectsController applicationObjectcontroller = new DefaultOptionalObjectsController();
        OptionalObjectsController parentObjectController = null;
        ApplicationContext applicationContext = parentApplicationContext = this.parentContext != null ? this.parentContext : this.domainContext;
        if (parentApplicationContext instanceof MuleArtifactContext) {
            parentObjectController = ((MuleArtifactContext)parentApplicationContext).getOptionalObjectsController();
        }
        if (parentObjectController != null) {
            applicationObjectcontroller = new CompositeOptionalObjectsController(applicationObjectcontroller, parentObjectController);
        }
        MuleArtifactContext muleArtifactContext = this.doCreateApplicationContext(muleContext, this.artifactConfigResources, this.artifactConfiguration, applicationObjectcontroller);
        this.serviceConfigurators.forEach(serviceConfigurator -> serviceConfigurator.configure(muleContext.getCustomizationService()));
        return muleArtifactContext;
    }

    protected MuleArtifactContext doCreateApplicationContext(MuleContext muleContext, ConfigResource[] artifactConfigResources, ArtifactConfiguration artifactConfiguration, OptionalObjectsController optionalObjectsController) {
        if (this.enableLazyInit) {
            return new LazyMuleArtifactContext(muleContext, artifactConfigResources, artifactConfiguration, optionalObjectsController, (Map<String, String>)this.getArtifactProperties(), this.artifactType);
        }
        return new MuleArtifactContext(muleContext, artifactConfigResources, artifactConfiguration, optionalObjectsController, (Map<String, String>)this.getArtifactProperties(), this.artifactType);
    }

    protected void createSpringRegistry(MuleContext muleContext, ApplicationContext applicationContext) throws Exception {
        if (this.parentContext != null && this.domainContext != null) {
            throw new IllegalStateException("An application with a web xml context and domain resources is not supported");
        }
        if (this.parentContext != null) {
            this.createRegistryWithParentContext(muleContext, applicationContext, this.parentContext);
        } else if (this.domainContext != null) {
            this.createRegistryWithParentContext(muleContext, applicationContext, this.domainContext);
        } else {
            this.registry = new SpringRegistry(applicationContext, muleContext);
        }
        muleContext.addRegistry((Registry)this.registry);
    }

    private void createRegistryWithParentContext(MuleContext muleContext, ApplicationContext applicationContext, ApplicationContext parentContext) throws ConfigurationException {
        if (!(applicationContext instanceof ConfigurableApplicationContext)) {
            throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)"Cannot set a parent context if the ApplicationContext does not implement ConfigurableApplicationContext"));
        }
        this.registry = new SpringRegistry((ConfigurableApplicationContext)applicationContext, parentContext, muleContext);
    }

    protected void applyLifecycle(LifecycleManager lifecycleManager) throws Exception {
        if (lifecycleManager.isPhaseComplete("start")) {
            lifecycleManager.fireLifecycle("start");
        }
    }

    public void setUseDefaultConfigResource(boolean useDefaultConfigResource) {
        this.useDefaultConfigResource = useDefaultConfigResource;
    }

    public MuleArtifactContext getMuleArtifactContext() {
        return this.muleArtifactContext;
    }

    public void setUseMinimalConfigResource(boolean useMinimalConfigResource) {
        this.useMinimalConfigResource = useMinimalConfigResource;
    }

    protected ApplicationContext getParentContext() {
        return this.parentContext;
    }

    public void setParentContext(ApplicationContext parentContext) {
        this.parentContext = parentContext;
    }

    public void setParentContext(MuleContext domainContext) {
        this.domainContext = (ApplicationContext)domainContext.getRegistry().get("springApplicationContext");
    }
}

