/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationException;
import org.mule.api.config.DomainMuleContextAwareConfigurationBuilder;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.registry.Registry;
import org.mule.config.ConfigResource;
import org.mule.config.builders.AbstractResourceConfigurationBuilder;
import org.mule.config.i18n.MessageFactory;
import org.mule.config.spring.CompositeOptionalObjectsController;
import org.mule.config.spring.DefaultOptionalObjectsController;
import org.mule.config.spring.MuleArtifactContext;
import org.mule.config.spring.OptionalObjectsController;
import org.mule.config.spring.SpringRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringXmlConfigurationBuilder
extends AbstractResourceConfigurationBuilder
implements DomainMuleContextAwareConfigurationBuilder {
    public static final String MULE_DEFAULTS_CONFIG = "default-mule-config.xml";
    public static final String MULE_SPRING_CONFIG = "mule-spring-config.xml";
    public static final String MULE_MINIMAL_SPRING_CONFIG = "minimal-mule-config.xml";
    public static final String MULE_REGISTRY_BOOTSTRAP_SPRING_CONFIG = "registry-bootstrap-mule-config.xml";
    public static final String MULE_DOMAIN_REGISTRY_BOOTSTRAP_SPRING_CONFIG = "registry-bootstrap-mule-domain-config.xml";
    protected boolean useDefaultConfigResource = true;
    protected boolean useMinimalConfigResource = false;
    protected SpringRegistry registry;
    protected ApplicationContext domainContext;
    protected ApplicationContext parentContext;
    protected ApplicationContext applicationContext;

    public SpringXmlConfigurationBuilder(String[] configResources) throws ConfigurationException {
        super(configResources);
    }

    public SpringXmlConfigurationBuilder(String configResources) throws ConfigurationException {
        super(configResources);
    }

    public SpringXmlConfigurationBuilder(ConfigResource[] configResources) {
        super(configResources);
    }

    protected List<ConfigResource> getConfigResources() throws IOException {
        ArrayList<ConfigResource> allResources = new ArrayList<ConfigResource>();
        if (this.useMinimalConfigResource) {
            allResources.add(new ConfigResource(MULE_DOMAIN_REGISTRY_BOOTSTRAP_SPRING_CONFIG));
            allResources.add(new ConfigResource(MULE_MINIMAL_SPRING_CONFIG));
            allResources.add(new ConfigResource(MULE_SPRING_CONFIG));
            allResources.addAll(Arrays.asList(this.configResources));
        } else if (this.useDefaultConfigResource) {
            allResources.add(new ConfigResource(MULE_REGISTRY_BOOTSTRAP_SPRING_CONFIG));
            allResources.add(new ConfigResource(MULE_MINIMAL_SPRING_CONFIG));
            allResources.add(new ConfigResource(MULE_SPRING_CONFIG));
            allResources.add(new ConfigResource(MULE_DEFAULTS_CONFIG));
            allResources.addAll(Arrays.asList(this.configResources));
        } else {
            allResources.add(new ConfigResource(MULE_SPRING_CONFIG));
            allResources.addAll(Arrays.asList(this.configResources));
        }
        return allResources;
    }

    protected void doConfigure(MuleContext muleContext) throws Exception {
        List<ConfigResource> allResources = this.getConfigResources();
        this.addResources(allResources);
        ConfigResource[] configResourcesArray = new ConfigResource[allResources.size()];
        this.applicationContext = this.createApplicationContext(muleContext, allResources.toArray(configResourcesArray));
        this.createSpringRegistry(muleContext, this.applicationContext);
    }

    protected void addResources(List<ConfigResource> allResources) {
    }

    public void unconfigure(MuleContext muleContext) {
        this.registry.dispose();
        if (muleContext != null) {
            muleContext.removeRegistry((Registry)this.registry);
        }
        this.registry = null;
        this.configured = false;
    }

    private ApplicationContext createApplicationContext(MuleContext muleContext, ConfigResource[] configResources) throws Exception {
        ApplicationContext parentApplicationContext;
        OptionalObjectsController applicationObjectcontroller = new DefaultOptionalObjectsController();
        OptionalObjectsController parentObjectController = null;
        ApplicationContext applicationContext = parentApplicationContext = this.parentContext != null ? this.parentContext : this.domainContext;
        if (parentApplicationContext instanceof MuleArtifactContext) {
            parentObjectController = ((MuleArtifactContext)parentApplicationContext).getOptionalObjectsController();
        }
        if (parentObjectController != null) {
            applicationObjectcontroller = new CompositeOptionalObjectsController(applicationObjectcontroller, parentObjectController);
        }
        return this.doCreateApplicationContext(muleContext, configResources, applicationObjectcontroller);
    }

    protected ApplicationContext doCreateApplicationContext(MuleContext muleContext, ConfigResource[] configResources, OptionalObjectsController optionalObjectsController) {
        return new MuleArtifactContext(muleContext, configResources, optionalObjectsController);
    }

    protected void createSpringRegistry(MuleContext muleContext, ApplicationContext applicationContext) throws Exception {
        if (this.parentContext != null && this.domainContext != null) {
            throw new IllegalStateException("An application with a web xml context and domain resources is not supported");
        }
        if (this.parentContext != null) {
            this.createRegistryWithParentContext(muleContext, applicationContext, this.parentContext);
        } else if (this.domainContext != null) {
            this.createRegistryWithParentContext(muleContext, applicationContext, this.domainContext);
        } else {
            this.registry = new SpringRegistry(applicationContext, muleContext);
        }
        muleContext.addRegistry((Registry)this.registry);
        this.registry.initialise();
    }

    private void createRegistryWithParentContext(MuleContext muleContext, ApplicationContext applicationContext, ApplicationContext parentContext) throws ConfigurationException {
        if (!(applicationContext instanceof ConfigurableApplicationContext)) {
            throw new ConfigurationException(MessageFactory.createStaticMessage((String)"Cannot set a parent context if the ApplicationContext does not implement ConfigurableApplicationContext"));
        }
        this.registry = new SpringRegistry((ConfigurableApplicationContext)applicationContext, parentContext, muleContext);
    }

    protected void applyLifecycle(LifecycleManager lifecycleManager) throws Exception {
        if (lifecycleManager.isPhaseComplete("start")) {
            lifecycleManager.fireLifecycle("start");
        }
    }

    public boolean isUseDefaultConfigResource() {
        return this.useDefaultConfigResource;
    }

    public void setUseDefaultConfigResource(boolean useDefaultConfigResource) {
        this.useDefaultConfigResource = useDefaultConfigResource;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setUseMinimalConfigResource(boolean useMinimalConfigResource) {
        this.useMinimalConfigResource = useMinimalConfigResource;
    }

    protected ApplicationContext getParentContext() {
        return this.parentContext;
    }

    public void setParentContext(ApplicationContext parentContext) {
        this.parentContext = parentContext;
    }

    public void setDomainContext(MuleContext domainContext) {
        this.domainContext = (ApplicationContext)domainContext.getRegistry().get("springApplicationContext");
    }
}

