/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.processors;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.mule.config.spring.processors.SelectiveInjectorProcessor;
import org.mule.util.ClassUtils;
import org.springframework.beans.PropertyValues;

public class NoDevkitInjectorProcessor
extends SelectiveInjectorProcessor {
    private static final String PROCESS_ADAPTER_CLASS_NAME = "org.mule.api.devkit.ProcessAdapter";
    private static final String LEGACY_PROCESS_ADAPTER_CLASS_NAME = "org.mule.modules.process.ProcessAdapter";
    private final Class<?>[] excludedClasses;

    public NoDevkitInjectorProcessor() {
        ArrayList presentClasses = new ArrayList();
        this.fetchExcludedClassByName(PROCESS_ADAPTER_CLASS_NAME, presentClasses);
        this.fetchExcludedClassByName(LEGACY_PROCESS_ADAPTER_CLASS_NAME, presentClasses);
        this.excludedClasses = new Class[presentClasses.size()];
        presentClasses.toArray(this.excludedClasses);
    }

    @Override
    protected boolean shouldInject(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) {
        for (Class<?> excludedClass : this.excludedClasses) {
            if (!excludedClass.isInstance(bean)) continue;
            return false;
        }
        return true;
    }

    private void fetchExcludedClassByName(String name, List<Class<?>> presentClasses) {
        try {
            Class excludedClass = ClassUtils.loadClass((String)name, ((Object)((Object)this)).getClass());
            if (excludedClass != null) {
                presentClasses.add(excludedClass);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

