/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.processors;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.config.spring.parsers.PreProcessor;
import org.mule.config.spring.parsers.assembly.configuration.PropertyConfiguration;
import org.mule.config.spring.util.SpringXMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class CheckExclusiveAttributesAndChildren
implements PreProcessor {
    private static final Pattern TYPE_REGEXP = Pattern.compile("\\{(.*)\\}(.*)");
    private final Set<String> attributeNames;
    private final Set<String> childrenNames;
    private final Set<ChildType> childrenTypes;

    public CheckExclusiveAttributesAndChildren(String[] attributeNames, String[] childrenNamesOrTypes) {
        this.attributeNames = new HashSet<String>(Arrays.asList(attributeNames));
        this.childrenNames = new HashSet<String>();
        this.childrenTypes = new HashSet<ChildType>();
        this.parseChildrenNamesOrTypes(childrenNamesOrTypes);
    }

    private void parseChildrenNamesOrTypes(String[] childrenNamesOrTypes) {
        for (String childrenNameOrType : childrenNamesOrTypes) {
            Matcher matcher = TYPE_REGEXP.matcher(childrenNameOrType);
            if (matcher.matches()) {
                this.childrenTypes.add(new ChildType(matcher.group(1), matcher.group(2)));
                continue;
            }
            this.childrenNames.add(childrenNameOrType);
        }
    }

    public void preProcess(PropertyConfiguration config, Element element) {
        NamedNodeMap attributes = element.getAttributes();
        int attributesCount = attributes.getLength();
        for (int i = 0; i < attributesCount; ++i) {
            String attributeName = SpringXMLUtils.attributeName((Attr)((Attr)attributes.item(i)));
            if (!this.attributeNames.contains(attributeName)) continue;
            this.ensureNoForbiddenChildren(element, attributeName);
        }
    }

    private void ensureNoForbiddenChildren(Element element, String attributeName) {
        NodeList childNodes = element.getChildNodes();
        int childNodesCount = childNodes.getLength();
        for (int j = 0; j < childNodesCount; ++j) {
            this.checkChildNode(element, attributeName, childNodes.item(j));
        }
    }

    private void checkChildNode(Element element, String attributeName, Node child) {
        if (child.getNodeType() == 1) {
            this.checkChildElement(element, attributeName, (Element)child);
        }
    }

    private void checkChildElement(Element element, String attributeName, Element child) {
        this.checkAttributeNameMatch(element, attributeName, child);
        for (ChildType childrenType : this.childrenTypes) {
            TypeInfo typeInfo = (TypeInfo)((Object)child);
            if ((!childrenType.ns.equals(typeInfo.getTypeNamespace()) || !childrenType.name.equals(typeInfo.getTypeName())) && !typeInfo.isDerivedFrom(childrenType.ns, childrenType.name, 2)) continue;
            throw new CheckExclusiveAttributesAndChildrenException("Element " + SpringXMLUtils.elementToString((Element)element) + " can't contain child of type " + childrenType + " because it defines attribute " + attributeName);
        }
    }

    private void checkAttributeNameMatch(Element element, String attributeName, Element child) {
        String childElementName = child.getLocalName();
        if (this.childrenNames.contains(childElementName)) {
            throw new CheckExclusiveAttributesAndChildrenException("Element " + SpringXMLUtils.elementToString((Element)element) + " can't contain child " + childElementName + " because it defines attribute " + attributeName);
        }
    }

    public static class CheckExclusiveAttributesAndChildrenException
    extends IllegalStateException {
        private static final long serialVersionUID = 8661524219979354246L;

        public CheckExclusiveAttributesAndChildrenException(String message) {
            super(message);
        }
    }

    private static class ChildType {
        String ns;
        String name;

        public ChildType(String ns, String name) {
            this.ns = ns;
            this.name = name;
        }

        public String toString() {
            return "{" + this.ns + "}" + this.name;
        }
    }
}

