/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.factories;

import java.util.List;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorBuilder;
import org.mule.api.transaction.TransactionConfig;
import org.mule.processor.TransactionalInterceptingMessageProcessor;
import org.mule.processor.builder.InterceptingChainMessageProcessorBuilder;
import org.springframework.beans.factory.FactoryBean;

public class TransactionalMessageProcessorsFactoryBean
implements FactoryBean {
    protected List messageProcessors;
    protected TransactionConfig transactionConfig;

    public Class getObjectType() {
        return MessageProcessor.class;
    }

    public void setMessageProcessors(List messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    public Object getObject() throws Exception {
        InterceptingChainMessageProcessorBuilder builder = new InterceptingChainMessageProcessorBuilder();
        TransactionalInterceptingMessageProcessor txProcessor = new TransactionalInterceptingMessageProcessor(this.transactionConfig);
        builder.chain(new MessageProcessor[]{txProcessor});
        for (Object processor : this.messageProcessors) {
            if (processor instanceof MessageProcessor) {
                builder.chain(new MessageProcessor[]{(MessageProcessor)processor});
                continue;
            }
            if (processor instanceof MessageProcessorBuilder) {
                builder.chain(new MessageProcessorBuilder[]{(MessageProcessorBuilder)processor});
                continue;
            }
            throw new IllegalArgumentException("MessageProcessorBuilder should only have MessageProcessor's or MessageProcessorBuilder's configured");
        }
        return builder.build();
    }

    public boolean isSingleton() {
        return false;
    }

    public void setTransactionConfig(TransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }
}

