/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific;

import org.mule.config.spring.parsers.AbstractMuleBeanDefinitionParser;
import org.mule.util.StringUtils;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractFlowConstructDefinitionParser
extends AbstractMuleBeanDefinitionParser {
    private static final String ABSTRACT_ATTRIBUTE = "abstract";
    private static final String PARENT_ATTRIBUTE = "parent";

    protected BeanDefinitionBuilder createBeanDefinitionBuilder(Element element, Class beanClass) {
        return BeanDefinitionBuilder.genericBeanDefinition((Class)beanClass);
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.setScope("singleton");
        this.handleAbstractAttribute(element, builder);
        this.handleParentAttribute(element, builder);
        super.doParse(element, parserContext, builder);
    }

    private void handleParentAttribute(Element element, BeanDefinitionBuilder builder) {
        String parentAttribute = element.getAttribute(PARENT_ATTRIBUTE);
        if (StringUtils.isNotBlank((String)parentAttribute)) {
            builder.setParentName(parentAttribute);
        }
        element.removeAttribute(PARENT_ATTRIBUTE);
    }

    private void handleAbstractAttribute(Element element, BeanDefinitionBuilder builder) {
        String abstractAttribute = element.getAttribute(ABSTRACT_ATTRIBUTE);
        if (StringUtils.isNotBlank((String)abstractAttribute)) {
            builder.setAbstract(Boolean.parseBoolean(abstractAttribute));
        }
        element.removeAttribute(ABSTRACT_ATTRIBUTE);
    }
}

