/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationException;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.registry.Registry;
import org.mule.config.ConfigResource;
import org.mule.config.builders.AbstractResourceConfigurationBuilder;
import org.mule.config.i18n.MessageFactory;
import org.mule.config.spring.MuleApplicationContext;
import org.mule.config.spring.SpringRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringXmlConfigurationBuilder
extends AbstractResourceConfigurationBuilder {
    public static final String MULE_DEFAULTS_CONFIG = "default-mule-config.xml";
    public static final String MULE_SPRING_CONFIG = "mule-spring-config.xml";
    protected boolean useDefaultConfigResource = true;
    protected Registry registry;
    protected ApplicationContext parentContext;

    public SpringXmlConfigurationBuilder(String[] configResources) throws ConfigurationException {
        super(configResources);
    }

    public SpringXmlConfigurationBuilder(String configResources) throws ConfigurationException {
        super(configResources);
    }

    public SpringXmlConfigurationBuilder(ConfigResource[] configResources) {
        super(configResources);
    }

    protected void doConfigure(MuleContext muleContext) throws Exception {
        ConfigResource[] allResources;
        if (this.useDefaultConfigResource) {
            allResources = new ConfigResource[this.configResources.length + 2];
            allResources[0] = new ConfigResource(MULE_SPRING_CONFIG);
            allResources[1] = new ConfigResource(MULE_DEFAULTS_CONFIG);
            System.arraycopy(this.configResources, 0, allResources, 2, this.configResources.length);
        } else {
            allResources = new ConfigResource[this.configResources.length + 1];
            allResources[0] = new ConfigResource(MULE_SPRING_CONFIG);
            System.arraycopy(this.configResources, 0, allResources, 1, this.configResources.length);
        }
        this.createSpringRegistry(muleContext, this.createApplicationContext(muleContext, allResources));
    }

    public void unconfigure(MuleContext muleContext) {
        this.registry.dispose();
        muleContext.removeRegistry(this.registry);
        this.registry = null;
        this.configured = false;
    }

    protected ApplicationContext createApplicationContext(MuleContext muleContext, ConfigResource[] configResources) throws Exception {
        return new MuleApplicationContext(muleContext, configResources);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createSpringRegistry(MuleContext muleContext, ApplicationContext applicationContext) throws Exception {
        if (this.parentContext != null) {
            if (!(applicationContext instanceof ConfigurableApplicationContext)) throw new ConfigurationException(MessageFactory.createStaticMessage((String)"Cannot set a parent context if the ApplicationContext does not implement ConfigurableApplicationContext"));
            this.registry = new SpringRegistry((ConfigurableApplicationContext)applicationContext, this.parentContext);
        } else {
            this.registry = new SpringRegistry(applicationContext);
        }
        muleContext.addRegistry(this.registry);
        this.registry.initialise();
    }

    protected void applyLifecycle(LifecycleManager lifecycleManager) throws Exception {
        if (lifecycleManager.isPhaseComplete("start")) {
            lifecycleManager.applyPhase(this.registry, "start");
        }
    }

    public boolean isUseDefaultConfigResource() {
        return this.useDefaultConfigResource;
    }

    public void setUseDefaultConfigResource(boolean useDefaultConfigResource) {
        this.useDefaultConfigResource = useDefaultConfigResource;
    }

    protected ApplicationContext getParentContext() {
        return this.parentContext;
    }

    public void setParentContext(ApplicationContext parentContext) {
        this.parentContext = parentContext;
    }
}

