/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.processors;

import org.mule.api.agent.Agent;
import org.mule.api.context.ContainerContext;
import org.mule.api.endpoint.Endpoint;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.model.Model;
import org.mule.api.service.Service;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.endpoint.MuleEndpoint;
import org.mule.util.ObjectNameHelper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class MuleObjectNameProcessor
implements BeanPostProcessor {
    private boolean overwrite = false;

    public Object postProcessBeforeInitialization(Object o, String s) throws BeansException {
        if (o instanceof Connector) {
            if (((Connector)o).getName() == null || this.overwrite) {
                ((Connector)o).setName(s);
            }
        } else if (o instanceof Transformer) {
            if (((Transformer)o).getName() == null || this.overwrite) {
                ((Transformer)o).setName(s);
            }
        } else if (o instanceof Endpoint) {
            if ((((Endpoint)o).getName() == null || this.overwrite) && !MuleEndpoint.class.getName().equals(s)) {
                Endpoint endpoint = (Endpoint)o;
                String name = ObjectNameHelper.getEndpointName((ImmutableEndpoint)endpoint);
                endpoint.setName(name);
            }
        } else if (o instanceof Service) {
            if (((Service)o).getName() == null || this.overwrite) {
                ((Service)o).setName(s);
            }
        } else if (o instanceof Model) {
            if (((Model)o).getName() == null || this.overwrite) {
                ((Model)o).setName(s);
            }
        } else if (o instanceof Agent) {
            ((Agent)o).setName(s);
        } else if (o instanceof ContainerContext) {
            ((ContainerContext)o).setName(s);
        }
        return o;
    }

    public Object postProcessAfterInitialization(Object o, String s) throws BeansException {
        return o;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }
}

