/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.transaction.TransactionManager;
import org.mule.api.MuleException;
import org.mule.api.agent.Agent;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.lifecycle.LifecyclePhase;
import org.mule.api.model.Model;
import org.mule.api.registry.RegistrationException;
import org.mule.api.registry.Registry;
import org.mule.api.registry.ServiceDescriptor;
import org.mule.api.registry.ServiceDescriptorFactory;
import org.mule.api.registry.ServiceException;
import org.mule.api.service.Service;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.config.MuleConfiguration;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.container.MultiContainerContext;
import org.mule.lifecycle.ContainerManagedLifecyclePhase;
import org.mule.lifecycle.GenericLifecycleManager;
import org.mule.registry.AbstractRegistry;
import org.mule.util.SpiUtils;
import org.mule.util.StringUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringRegistry
extends AbstractRegistry {
    public static final String REGISTRY_ID = "org.mule.Registry.Spring";
    protected ConfigurableApplicationContext applicationContext;
    protected MultiContainerContext containerContext;

    public SpringRegistry() {
        super(REGISTRY_ID);
    }

    public SpringRegistry(String id) {
        super(id);
    }

    public SpringRegistry(ConfigurableApplicationContext applicationContext) {
        super(REGISTRY_ID);
        this.applicationContext = applicationContext;
    }

    public SpringRegistry(String id, ConfigurableApplicationContext applicationContext) {
        super(id);
        this.applicationContext = applicationContext;
    }

    protected LifecycleManager createLifecycleManager() {
        GenericLifecycleManager lcm = new GenericLifecycleManager();
        lcm.registerLifecycle((LifecyclePhase)new ContainerManagedLifecyclePhase("initialise", Initialisable.class, "dispose"));
        lcm.registerLifecycle((LifecyclePhase)new ContainerManagedLifecyclePhase("dispose", Disposable.class, "initialise"));
        return lcm;
    }

    protected Object doLookupObject(String key) {
        if (StringUtils.isBlank((String)key)) {
            this.logger.warn((Object)MessageFactory.createStaticMessage((String)"Detected a lookup attempt with an empty or null key"), new Throwable().fillInStackTrace());
            return null;
        }
        try {
            return this.applicationContext.getBean(key);
        }
        catch (NoSuchBeanDefinitionException e) {
            this.logger.debug((Object)e);
            return null;
        }
    }

    protected Collection doLookupObjects(Class type) {
        Map map = this.applicationContext.getBeansOfType(type);
        return map.values();
    }

    public ServiceDescriptor lookupServiceDescriptor(String type, String name, Properties overrides) throws ServiceException {
        Properties props = SpiUtils.findServiceDescriptor((String)type, (String)name);
        if (props == null) {
            throw new ServiceException(CoreMessages.failedToLoad((String)(type + " " + name)));
        }
        return ServiceDescriptorFactory.create((String)type, (String)name, (Properties)props, (Properties)overrides, (Registry)this);
    }

    protected synchronized MuleConfiguration getLocalConfiguration() {
        return (MuleConfiguration)this.applicationContext.getBean("_muleConfiguration");
    }

    public TransactionManager getTransactionManager() {
        try {
            return (TransactionManager)this.lookupObject(TransactionManager.class);
        }
        catch (RegistrationException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection getModels() {
        return this.applicationContext.getBeansOfType(Model.class).values();
    }

    public Collection getConnectors() {
        return this.applicationContext.getBeansOfType(Connector.class).values();
    }

    public Collection getAgents() {
        return this.applicationContext.getBeansOfType(Agent.class).values();
    }

    public Collection getEndpoints() {
        return this.applicationContext.getBeansOfType(ImmutableEndpoint.class).values();
    }

    public Collection getTransformers() {
        return this.applicationContext.getBeansOfType(Transformer.class).values();
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isRemote() {
        return false;
    }

    public void registerConnector(Connector connector) throws MuleException {
        this.unsupportedOperation("registerConnector", connector);
    }

    public void unregisterConnector(String connectorName) throws MuleException {
        this.unsupportedOperation("unregisterConnector", connectorName);
    }

    public void registerEndpoint(ImmutableEndpoint endpoint) throws MuleException {
        this.unsupportedOperation("registerEndpoint", endpoint);
    }

    public void unregisterEndpoint(String endpointName) {
        this.unsupportedOperation("unregisterEndpoint", endpointName);
    }

    protected void doRegisterTransformer(Transformer transformer) throws MuleException {
        this.unsupportedOperation("registerTransformer", transformer);
    }

    public void unregisterTransformer(String transformerName) {
        this.unsupportedOperation("unregistertransformer", transformerName);
    }

    public void registerService(Service service) throws MuleException {
        this.unsupportedOperation("registerComponent", service);
    }

    public void unregisterComponent(String componentName) {
        this.unsupportedOperation("unregisterComponent", componentName);
    }

    public void registerModel(Model model) throws MuleException {
        this.unsupportedOperation("registerModel", model);
    }

    public void unregisterModel(String modelName) {
        this.unsupportedOperation("unregisterModel", modelName);
    }

    public void registerAgent(Agent agent) throws MuleException {
        this.unsupportedOperation("registerAgent", agent);
    }

    public void unregisterAgent(String agentName) throws MuleException {
        this.unsupportedOperation("unregisterAgent", agentName);
    }

    protected void doRegisterObject(String key, Object value, Object metadata) throws RegistrationException {
        this.unsupportedOperation("doRegisterObject", key);
    }

    public void unregisterObject(String key) {
        this.unsupportedOperation("unregisterObject", key);
    }

    public void registerObjects(Map objects) throws RegistrationException {
        this.unsupportedOperation("registryObjects", objects);
    }

    public void setConfiguration(MuleConfiguration config) {
        this.unsupportedOperation("setConfiguration", config);
    }

    public void registerEndpointBuilder(String name, EndpointBuilder builder) throws MuleException {
        this.unsupportedOperation("registerEndpointBuilder", builder);
    }

    protected void doDispose() {
        super.doDispose();
        this.applicationContext.close();
    }
}

