/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import java.io.IOException;
import org.mule.api.MuleContext;
import org.mule.api.registry.Registry;
import org.mule.config.spring.MissingParserProblemReporter;
import org.mule.config.spring.MuleBeanDefinitionDocumentReader;
import org.mule.config.spring.MuleContextPostProcessor;
import org.mule.config.spring.SpringRegistry;
import org.mule.util.ClassUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.core.io.Resource;

public class MuleApplicationContext
extends AbstractXmlApplicationContext {
    public static final String LEGACY_BEAN_READER_CLASS = "org.mule.config.spring.MuleBeanDefinitionReader";
    private MuleContext muleContext;
    private final Resource[] configResources;
    private final String[] configLocations;

    public MuleApplicationContext(MuleContext muleContext, Registry registry, String[] configLocations) {
        this(muleContext, registry, configLocations, true);
    }

    public MuleApplicationContext(MuleContext muleContext, Registry registry, String[] configLocations, ApplicationContext parent) {
        super(parent);
        this.setupParentSpringRegistry(registry);
        this.muleContext = muleContext;
        this.configLocations = configLocations;
        this.configResources = null;
        this.refresh();
    }

    protected void setupParentSpringRegistry(Registry registry) {
        registry.setParent((Registry)new SpringRegistry((ConfigurableApplicationContext)this));
    }

    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.prepareBeanFactory(beanFactory);
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new MuleContextPostProcessor(this.muleContext));
    }

    public MuleApplicationContext(MuleContext muleContext, Registry registry, Resource[] configResources) {
        this(muleContext, registry, configResources, true);
    }

    public MuleApplicationContext(MuleContext muleContext, Registry registry, String[] configLocations, boolean refresh) throws BeansException {
        this.muleContext = muleContext;
        this.setupParentSpringRegistry(registry);
        this.configLocations = configLocations;
        this.configResources = null;
        if (refresh) {
            this.refresh();
        }
    }

    public MuleApplicationContext(MuleContext muleContext, Registry registry, Resource[] configResources, ApplicationContext parent) {
        super(parent);
        this.muleContext = muleContext;
        this.setupParentSpringRegistry(registry);
        this.configLocations = null;
        this.configResources = configResources;
        this.refresh();
    }

    public MuleApplicationContext(MuleContext muleContext, Registry registry, Resource[] configResources, boolean refresh) throws BeansException {
        this.setupParentSpringRegistry(registry);
        this.muleContext = muleContext;
        this.configLocations = null;
        this.configResources = configResources;
        if (refresh) {
            this.refresh();
        }
    }

    protected Resource[] getConfigResources() {
        return this.configResources;
    }

    protected String[] getConfigLocations() {
        return this.configLocations;
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException {
        XmlBeanDefinitionReader beanDefinitionReader;
        if (ClassUtils.isClassOnPath((String)LEGACY_BEAN_READER_CLASS, ((Object)((Object)this)).getClass())) {
            try {
                beanDefinitionReader = (XmlBeanDefinitionReader)ClassUtils.instanciateClass((String)LEGACY_BEAN_READER_CLASS, (Object[])new Object[]{beanFactory, this.configLocations});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            beanDefinitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
        }
        beanDefinitionReader.setDocumentReaderClass(MuleBeanDefinitionDocumentReader.class);
        beanDefinitionReader.setProblemReporter((ProblemReporter)new MissingParserProblemReporter());
        if (this.configLocations != null) {
            beanDefinitionReader.loadBeanDefinitions(this.configLocations);
        } else {
            beanDefinitionReader.loadBeanDefinitions(this.configResources);
        }
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        DefaultListableBeanFactory bf = super.createBeanFactory();
        if (this.getParent() != null) {
            AbstractBeanFactory beanFactory = (AbstractBeanFactory)this.getParent().getAutowireCapableBeanFactory();
            bf.copyConfigurationFrom((ConfigurableBeanFactory)beanFactory);
        }
        return bf;
    }
}

