/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.wsdl;

import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.catalog.CatalogWSDLLocator;
import org.jetbrains.annotations.NotNull;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.DefaultUnknownMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.XmlMetaDataModel;
import org.mule.common.metadata.builder.DefaultMetaDataBuilder;
import org.mule.common.metadata.builder.XmlMetaDataBuilder;
import org.mule.common.metadata.datatype.DataType;
import org.mule.modules.wsdl.WSDLSchemaUtils;

public class WSDLMetadata {
    private final List<MetaDataKey> metaDataKeys;
    private final Map<String, DataType> types = ImmutableMap.builder().put((Object)"string", (Object)DataType.STRING).put((Object)"boolean", (Object)DataType.BOOLEAN).put((Object)"date", (Object)DataType.DATE).put((Object)"decimal", (Object)DataType.DECIMAL).put((Object)"byte", (Object)DataType.BYTE).put((Object)"unsignedByte", (Object)DataType.BYTE).put((Object)"dateTime", (Object)DataType.DATE_TIME).put((Object)"int", (Object)DataType.INTEGER).put((Object)"integer", (Object)DataType.INTEGER).put((Object)"unsignedInt", (Object)DataType.INTEGER).put((Object)"short", (Object)DataType.INTEGER).put((Object)"unsignedShort", (Object)DataType.INTEGER).put((Object)"long", (Object)DataType.LONG).put((Object)"unsignedLong", (Object)DataType.LONG).put((Object)"double", (Object)DataType.DOUBLE).build();
    private final Map<MetaDataKey, URL> metaDataKeysUrls = new HashMap<MetaDataKey, URL>();

    public WSDLMetadata(@NotNull Iterable<URL> wsdlURLs, @NotNull String category) throws URISyntaxException, WSDLException {
        this.metaDataKeys = new ArrayList<MetaDataKey>();
        for (URL wsdlURL : wsdlURLs) {
            URI wsdlURI = new URI(wsdlURL.toString());
            String name = URIUtil.getName((String)wsdlURI.toString());
            if (StringUtils.isBlank((String)name)) {
                String[] path = URIUtil.getPath((String)wsdlURI.toString()).split("/");
                name = path[path.length - 1];
            }
            String wsdlName = FilenameUtils.getBaseName((String)name);
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader wsdlReader = factory.newWSDLReader();
            Definition wsdlDefinition = wsdlReader.readWSDL((WSDLLocator)new CatalogWSDLLocator(wsdlURI.toString()));
            Map<QName, Binding> bindings = this.getBindingsFromWsdlDefinition(wsdlDefinition);
            for (Map.Entry<QName, Binding> entry : bindings.entrySet()) {
                Binding binding = entry.getValue();
                for (Object bindingOperation : binding.getBindingOperations()) {
                    Operation operation = ((BindingOperation)bindingOperation).getOperation();
                    String operationName = operation.getName();
                    String metaDataId = StringUtils.join((Object[])new Object[]{wsdlName, operationName}, (char)'#');
                    String metaDataName = StringUtils.join((Object[])new Object[]{wsdlName.replace('_', ' '), operationName.replace('_', ' ')}, (String)" - ");
                    DefaultMetaDataKey metaDataKey = new DefaultMetaDataKey(metaDataId, metaDataName);
                    metaDataKey.setCategory(category);
                    this.metaDataKeys.add((MetaDataKey)metaDataKey);
                    this.metaDataKeysUrls.put((MetaDataKey)metaDataKey, wsdlURL);
                }
            }
        }
    }

    public List<MetaDataKey> getMetaDataKeys() {
        return this.metaDataKeys;
    }

    public MetaData getInputMetaData(MetaDataKey key) throws Exception {
        URL wsdlUrl = this.metaDataKeysUrls.get(key);
        String[] wsdlAndOperation = key.getId().split("#");
        String operationName = wsdlAndOperation[1];
        WSDLFactory factory = WSDLFactory.newInstance();
        WSDLReader wsdlReader = factory.newWSDLReader();
        Definition wsdlDefinition = wsdlReader.readWSDL(wsdlUrl.toString());
        List<String> schemas = WSDLSchemaUtils.getSchemas(wsdlDefinition);
        Operation operation = this.getOperationFromWsdl(wsdlDefinition, operationName);
        Message message = this.getInputMessage(operation);
        Part part = this.getMessagePart(message);
        return this.createMetaData(schemas, part);
    }

    public MetaData getOutputMetaData(MetaDataKey key) throws Exception {
        URL wsdlUrl = this.metaDataKeysUrls.get(key);
        String[] wsdlAndOperation = key.getId().split("#");
        String operationName = wsdlAndOperation[1];
        WSDLFactory factory = WSDLFactory.newInstance();
        WSDLReader wsdlReader = factory.newWSDLReader();
        Definition wsdlDefinition = wsdlReader.readWSDL(wsdlUrl.toString());
        List<String> schemas = WSDLSchemaUtils.getSchemas(wsdlDefinition);
        Operation operation = this.getOperationFromWsdl(wsdlDefinition, operationName);
        Message message = this.getOutputMessage(operation);
        Part part = this.getMessagePart(message);
        MetaData metadata = null;
        if (part != null) {
            metadata = this.createMetaData(schemas, part);
        }
        return metadata;
    }

    private Message getInputMessage(Operation operation) {
        return operation.getInput().getMessage();
    }

    private Message getOutputMessage(Operation operation) {
        return operation.getOutput().getMessage();
    }

    private Operation getOperationFromWsdl(Definition wsdlDefinition, String operationName) {
        Map<QName, Binding> bindings = this.getBindingsFromWsdlDefinition(wsdlDefinition);
        Set<QName> qNames = bindings.keySet();
        QName bindQName = qNames.iterator().next();
        Binding binding = bindings.get(bindQName);
        BindingOperation bindingOperation = binding.getBindingOperation(operationName, null, null);
        return bindingOperation.getOperation();
    }

    private Map<QName, Binding> getBindingsFromWsdlDefinition(Definition wsdlDefinition) {
        Map bindings = wsdlDefinition.getBindings();
        return bindings;
    }

    private Part getMessagePart(Message message) {
        if (message == null) {
            return null;
        }
        Map parts = message.getParts();
        if (!parts.isEmpty()) {
            Object firstValueKey = parts.keySet().toArray()[0];
            return (Part)parts.get(firstValueKey);
        }
        return null;
    }

    private MetaData createMetaData(List<String> schemas, Part part) {
        if (part != null) {
            if (part.getElementName() != null) {
                QName elementName = part.getElementName();
                XmlMetaDataBuilder createXmlObject = new DefaultMetaDataBuilder().createXmlObject(elementName);
                for (String schema : schemas) {
                    createXmlObject.addSchemaStringList(new String[]{schema});
                }
                createXmlObject.setEncoding(Charset.defaultCharset());
                createXmlObject.setExample("");
                XmlMetaDataModel model = (XmlMetaDataModel)createXmlObject.build();
                if (!model.getFields().isEmpty()) {
                    return new DefaultMetaData((MetaDataModel)model);
                }
            } else if (part.getTypeName() != null) {
                DataType dataType = this.getDataTypeFromTypeName(part);
                DefaultSimpleMetaDataModel defaultSimpleMetaDataModel = new DefaultSimpleMetaDataModel(dataType);
                return new DefaultMetaData((MetaDataModel)defaultSimpleMetaDataModel);
            }
        }
        return new DefaultMetaData((MetaDataModel)new DefaultUnknownMetaDataModel());
    }

    private DataType getDataTypeFromTypeName(Part part) {
        String localPart = part.getTypeName().getLocalPart();
        DataType dataType = this.types.get(localPart);
        return dataType != null ? dataType : DataType.STRING;
    }
}

