/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.wsdl;

import com.google.common.base.Charsets;
import com.sforce.soap.partner.StatusCode;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.staxutils.StaxSource;
import org.mule.modules.salesforce.ProxyAuthenticator;
import org.mule.modules.salesforce.SalesforceProxySelector;
import org.mule.modules.salesforce.exception.SalesforceException;
import org.mule.modules.salesforce.exception.SalesforceTransformationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.xml.StaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class WSDLInvocation {
    private static final Logger logger = LoggerFactory.getLogger(WSDLInvocation.class);
    private XMLInputFactory inputFactory;
    private String basePath;
    private String headerQNamePrefix;
    private String wsdlNamespace;
    private String serviceName;
    private String portName;
    private String sessionId;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private Integer connectionTimeout;
    private Integer readTimeout;

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setWsdlNamespace(String wsdlNamespace) {
        this.wsdlNamespace = wsdlNamespace;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLStreamReader invoke(String type, XMLStreamReader input) throws Exception {
        XMLStreamReader result = null;
        String[] wsdlAndOperation = type.split("#");
        String wsdlName = wsdlAndOperation[0];
        String operationName = wsdlAndOperation[1];
        String headerPrefix = "headerPrefix";
        String bodyPrefix = "bodyPrefix";
        String methodName = StringUtils.lowerCase((String)operationName);
        QName serviceQName = new QName(this.wsdlNamespace, this.serviceName);
        QName portQName = new QName(this.wsdlNamespace, this.portName);
        String endpointAddress = this.basePath + wsdlName;
        Service service = Service.create((QName)serviceQName);
        service.addPort(portQName, "http://schemas.xmlsoap.org/wsdl/soap/http", endpointAddress);
        Dispatch dispatch = service.createDispatch(portQName, SOAPMessage.class, Service.Mode.MESSAGE);
        Map rc = dispatch.getRequestContext();
        rc.put("javax.xml.ws.soap.http.soapaction.use", Boolean.TRUE);
        rc.put("javax.xml.ws.soap.http.soapaction.uri", methodName);
        rc.put("com.sun.xml.internal.ws.connect.timeout", this.getConnectionTimeout());
        rc.put("com.sun.xml.internal.ws.request.timeout", this.getReadTimeout());
        MessageFactory factory = ((SOAPBinding)dispatch.getBinding()).getMessageFactory();
        SOAPMessage request = factory.createMessage();
        SOAPPart part = request.getSOAPPart();
        SOAPEnvelope env = part.getEnvelope();
        env.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
        env.addNamespaceDeclaration(bodyPrefix, this.wsdlNamespace + methodName + "/");
        env.addNamespaceDeclaration(headerPrefix, this.wsdlNamespace);
        this.populateRequestSOAPHeader(env.getHeader());
        SOAPBody body = env.getBody();
        String xml = this.getOuterXml(input);
        if (xml.trim().equals("<NullPayload/>")) {
            xml = "<ns0:" + operationName + " xmlns:ns0=\"" + this.wsdlNamespace.substring(0, this.wsdlNamespace.length() - 1) + "\"/>";
        }
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document document = docBuilder.parse(new InputSource(new StringReader(xml)));
        body.addDocument(document);
        request.saveChanges();
        ProxySelector previousSelector = this.prepareProxy(endpointAddress);
        SOAPMessage reply = null;
        try {
            reply = (SOAPMessage)dispatch.invoke((Object)request);
        }
        finally {
            this.revertProxy(previousSelector);
        }
        if (reply == null) {
            return null;
        }
        SOAPBodyElement sourceContent = (SOAPBodyElement)reply.getSOAPBody().getChildElements().next();
        NamedNodeMap envelopeAttributes = reply.getSOAPPart().getChildNodes().item(0).getAttributes();
        for (int i = 0; i < envelopeAttributes.getLength(); ++i) {
            sourceContent.addAttribute(env.createName(envelopeAttributes.item(i).getNodeName()), envelopeAttributes.item(i).getNodeValue());
        }
        DOMSource source = new DOMSource((Node)sourceContent);
        XMLInputFactory iFactory = this.getInputFactory();
        XMLStreamReader reader = iFactory.createXMLStreamReader(source);
        result = StaxUtils.getXMLStreamReader((Source)new StAXSource(reader));
        String stringResult = this.getOuterXml(result);
        logger.debug(stringResult);
        result = this.createNewXMLStreamReader(stringResult);
        return result;
    }

    private void revertProxy(ProxySelector proxySelector) {
        ProxySelector.setDefault(proxySelector);
    }

    private ProxySelector prepareProxy(String endpointAddress) throws SalesforceException {
        ProxySelector previousProxySelector = ProxySelector.getDefault();
        try {
            if (this.getProxyHost() != null && !this.getProxyHost().isEmpty()) {
                URI uri = new URI(endpointAddress);
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.getProxyHost(), (int)this.getProxyPort()));
                HashMap<URI, Proxy> proxyByURI = new HashMap<URI, Proxy>();
                proxyByURI.put(uri, proxy);
                SalesforceProxySelector salesforceProxySelector = new SalesforceProxySelector(proxyByURI);
                ProxySelector.setDefault(salesforceProxySelector);
                if (this.getProxyUsername() != null && this.getProxyPassword() != null) {
                    ProxyAuthenticator proxyAuthenticator = new ProxyAuthenticator(this.getProxyUsername(), this.getProxyPassword());
                    Authenticator.setDefault(proxyAuthenticator);
                }
            }
        }
        catch (URISyntaxException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SalesforceException(StatusCode.UNKNOWN_EXCEPTION, e.getMessage(), e);
        }
        return previousProxySelector;
    }

    private void populateRequestSOAPHeader(SOAPHeader header) throws SOAPException {
        SOAPElement allowFieldTruncationHeader = header.addChildElement(new QName(this.wsdlNamespace, "AllowFieldTruncationHeader", this.headerQNamePrefix));
        allowFieldTruncationHeader.addChildElement(new QName(this.wsdlNamespace, "allowFieldTruncation", this.headerQNamePrefix)).addTextNode("1");
        SOAPElement debuggingHeader = header.addChildElement(new QName(this.wsdlNamespace, "DebuggingHeader", this.headerQNamePrefix));
        SOAPElement categories = debuggingHeader.addChildElement(new QName(this.wsdlNamespace, "categories", this.headerQNamePrefix));
        categories.addChildElement(new QName(this.wsdlNamespace, "category", this.headerQNamePrefix)).addTextNode("Apex_code");
        categories.addChildElement(new QName(this.wsdlNamespace, "level", this.headerQNamePrefix)).addTextNode("Info");
        debuggingHeader.addChildElement(new QName(this.wsdlNamespace, "debugLevel", this.headerQNamePrefix)).addTextNode("Detail");
        SOAPElement callOptions = header.addChildElement(new QName(this.wsdlNamespace, "CallOptions", this.headerQNamePrefix));
        callOptions.addChildElement(new QName(this.wsdlNamespace, "client", this.headerQNamePrefix)).addTextNode("32.0");
        SOAPElement sessionHeader = header.addChildElement(new QName(this.wsdlNamespace, "SessionHeader", this.headerQNamePrefix));
        sessionHeader.addChildElement(new QName(this.wsdlNamespace, "sessionId", this.headerQNamePrefix)).addTextNode(this.getSessionId());
    }

    private XMLInputFactory getInputFactory() {
        if (this.inputFactory == null) {
            this.inputFactory = this.createInputFactory();
        }
        return this.inputFactory;
    }

    private XMLInputFactory createInputFactory() {
        return XMLInputFactory.newInstance();
    }

    public String getOuterXml(XMLStreamReader xmlr) throws Exception {
        Transformer transformer = null;
        StringWriter stringWriter = new StringWriter();
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            StaxSource source = new StaxSource(xmlr);
            transformer.transform((Source)source, new StreamResult(stringWriter));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SalesforceTransformationException("Could not transform from java.lang.String to XMLStreamReader!");
        }
        return stringWriter.toString();
    }

    public XMLStreamReader createNewXMLStreamReader(String data) throws XMLStreamException, UnsupportedEncodingException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes(Charsets.UTF_8));
        InputStreamReader myReader = new InputStreamReader((InputStream)is, Charsets.UTF_8);
        XMLStreamReader reader = factory.createXMLStreamReader(myReader);
        return reader;
    }

    public void setHeaderQNamePrefix(String headerQNamePrefix) {
        this.headerQNamePrefix = headerQNamePrefix;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }
}

