/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.processors;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationException;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.common.DefaultResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.DefaultListMetaDataModel;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.MetaDataModelProperty;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.datatype.DataTypeFactory;
import org.mule.common.metadata.key.property.MetaDataKeyProperty;
import org.mule.common.metadata.key.property.TypeDescribingProperty;
import org.mule.common.metadata.property.StructureIdentifierMetaDataModelProperty;
import org.mule.common.metadata.util.MetaDataQueryFilter;
import org.mule.common.query.DsqlQuery;
import org.mule.common.query.Type;
import org.mule.common.query.dsql.parser.MuleDsqlParser;
import org.mule.devkit.3.6.1.shade.metadata.MetaDataGeneratorUtils;
import org.mule.modules.salesforce.ExceptionDecorator;
import org.mule.modules.salesforce.SalesforceConnector;
import org.mule.modules.salesforce.api.SalesforceHeader;
import org.mule.modules.salesforce.exception.SalesforceSessionExpiredException;
import org.mule.security.oauth.callback.ProcessCallback;
import org.mule.streaming.PagingConfiguration;
import org.mule.streaming.PagingDelegate;
import org.mule.streaming.processor.AbstractDevkitBasedPageableMessageProcessor;
import org.mule.streaming.processor.ManagedPagingDelegateAdapter;

public class QueryAllMessageProcessor
extends AbstractDevkitBasedPageableMessageProcessor
implements MessageProcessor,
OperationMetaDataEnabled {
    protected Object query;
    protected String _queryType;
    protected Object headers;
    protected Map<SalesforceHeader, Object> _headersType;

    public QueryAllMessageProcessor(String operationName) {
        super(operationName);
    }

    public void initialise() throws InitialisationException {
    }

    public void start() throws MuleException {
        super.start();
    }

    public void stop() throws MuleException {
        super.stop();
    }

    public void dispose() {
        super.dispose();
    }

    public void setHeaders(Object value) {
        this.headers = value;
    }

    public void setQuery(Object value) {
        this.query = value;
    }

    public PagingDelegate getPagingDelegate(final MuleEvent event, final PagingConfiguration pagingConfiguration) throws Exception {
        Object moduleObject = null;
        moduleObject = this.findOrCreate(null, false, event);
        final QueryAllMessageProcessor messageProcessor = this;
        final String _transformedQuery = (String)this.evaluateAndTransform(this.getMuleContext(), event, QueryAllMessageProcessor.class.getDeclaredField("_queryType").getGenericType(), null, this.query);
        final Map _transformedHeaders = (Map)this.evaluateAndTransform(this.getMuleContext(), event, QueryAllMessageProcessor.class.getDeclaredField("_headersType").getGenericType(), null, this.headers);
        final ProcessTemplate processTemplate = ((ProcessAdapter)moduleObject).getProcessTemplate();
        Object resultPayload = processTemplate.execute((ProcessCallback)new ProcessCallback<Object, Object>(){

            public List<Class<? extends Exception>> getManagedExceptions() {
                return Arrays.asList(SalesforceSessionExpiredException.class);
            }

            public boolean isProtected() {
                return true;
            }

            public Object process(Object object) throws Exception {
                try {
                    SalesforceConnector connector = (SalesforceConnector)object;
                    String trimmedQuery = _transformedQuery;
                    if (trimmedQuery != null && _transformedQuery.startsWith("dsql:")) {
                        trimmedQuery = _transformedQuery.substring(5);
                        MuleDsqlParser parser = new MuleDsqlParser();
                        DsqlQuery q = parser.parse(trimmedQuery);
                        return new ManagedPagingDelegateAdapter(((SalesforceConnector)object).queryAll(connector.toNativeQuery(q).toString(), pagingConfiguration, _transformedHeaders), processTemplate, this.getManagedExceptions(), this.isProtected(), messageProcessor, event);
                    }
                    return new ManagedPagingDelegateAdapter(((SalesforceConnector)object).queryAll(_transformedQuery, pagingConfiguration, _transformedHeaders), processTemplate, this.getManagedExceptions(), this.isProtected(), messageProcessor, event);
                }
                catch (Exception e) {
                    ExceptionDecorator handler = new ExceptionDecorator();
                    handler.process(e);
                    throw e;
                }
            }
        }, (MessageProcessor)this, event);
        return (PagingDelegate)resultPayload;
    }

    public Result<MetaData> getInputMetaData() {
        return new DefaultResult(null, Result.Status.SUCCESS);
    }

    public Result<MetaData> getOutputMetaData(MetaData inputMetadata) {
        try {
            MuleDsqlParser parser = new MuleDsqlParser();
            String queryStr = (String)this.query;
            if (queryStr != null && queryStr.startsWith("dsql:")) {
                queryStr = queryStr.substring(5);
                DsqlQuery q = parser.parse(queryStr);
                Result<MetaData> result = this.auxOutputMetaData(null, ((Type)q.getTypes().get(0)).getName());
                MetaData metaData = new MetaDataQueryFilter((MetaData)result.get(), q.getFields()).doFilter();
                metaData.getPayload().addProperty((MetaDataModelProperty)new StructureIdentifierMetaDataModelProperty(null, true));
                return new DefaultResult((Object)metaData);
            }
            return new DefaultResult(null, Result.Status.FAILURE);
        }
        catch (Exception e) {
            return new DefaultResult(null, Result.Status.FAILURE, "Failed on parsing and getting query metadata");
        }
    }

    public Result<MetaData> auxOutputMetaData(MetaData inputMetadata, String key) {
        if (key == null || key.toString() == null) {
            return new DefaultResult(null, Result.Status.FAILURE, "There was an error retrieving metadata from parameter: key at processor queryAll at module SalesforceConnector");
        }
        DefaultMetaDataKey metaDataKey = new DefaultMetaDataKey(key.toString(), null);
        metaDataKey.setCategory("SalesforceMetadataCategory");
        metaDataKey.addProperty((MetaDataKeyProperty)new TypeDescribingProperty(TypeDescribingProperty.TypeScope.OUTPUT, "queryAll"));
        Result<MetaData> genericMetaData = this.getGenericMetaData((MetaDataKey)metaDataKey);
        if (Result.Status.FAILURE.equals((Object)genericMetaData.getStatus())) {
            return genericMetaData;
        }
        DefaultListMetaDataModel wrappedMetaDataModel = new DefaultListMetaDataModel(((MetaData)genericMetaData.get()).getPayload());
        return new DefaultResult((Object)MetaDataGeneratorUtils.extractPropertiesToMetaData((MetaDataModel)wrappedMetaDataModel, (MetaData)genericMetaData.get()));
    }

    private MetaDataModel getPojoOrSimpleModel(Class clazz) {
        DataType dataType = DataTypeFactory.getInstance().getDataType(clazz);
        if (DataType.POJO.equals((Object)dataType)) {
            return new DefaultPojoMetaDataModel(clazz);
        }
        return new DefaultSimpleMetaDataModel(dataType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result<MetaData> getGenericMetaData(MetaDataKey metaDataKey) {
        try {
            ConnectorMetaDataEnabled connector = (ConnectorMetaDataEnabled)this.findOrCreate(null, false, null);
            try {
                Result metadata = connector.getMetaData(metaDataKey);
                if (Result.Status.FAILURE.equals((Object)metadata.getStatus())) {
                    return metadata;
                }
                if (metadata.get() == null) {
                    return new DefaultResult(null, Result.Status.FAILURE, "There was an error processing metadata at SalesforceConnector at queryAll retrieving was successful but result is null");
                }
                return metadata;
            }
            catch (Exception e) {
                return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
            }
        }
        catch (ClassCastException cast) {
            return new DefaultResult(null, Result.Status.FAILURE, "There was an error getting metadata, there was no connection manager available. Maybe you're trying to use metadata from an Oauth connector");
        }
        catch (ConfigurationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (RegistrationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (InstantiationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (Exception e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
    }
}

