/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.processors;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationException;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.common.DefaultResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.MetaDataModelProperty;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.datatype.DataTypeFactory;
import org.mule.common.metadata.key.property.MetaDataKeyProperty;
import org.mule.common.metadata.key.property.TypeDescribingProperty;
import org.mule.common.metadata.property.StructureIdentifierMetaDataModelProperty;
import org.mule.devkit.3.6.1.shade.metadata.MetaDataGeneratorUtils;
import org.mule.devkit.processor.DevkitBasedMessageProcessor;
import org.mule.modules.salesforce.ExceptionDecorator;
import org.mule.modules.salesforce.SalesforceConnector;
import org.mule.modules.salesforce.apex.rest.ApexRequestHeaders;
import org.mule.modules.salesforce.exception.SalesforceSessionExpiredException;
import org.mule.security.oauth.callback.ProcessCallback;

public class InvokeApexRestMethodMessageProcessor
extends DevkitBasedMessageProcessor
implements MessageProcessor,
OperationMetaDataEnabled {
    protected Object restMethodName;
    protected String _restMethodNameType;
    protected Object input;
    protected Object _inputType;
    protected Object requestHeaders;
    protected ApexRequestHeaders _requestHeadersType;
    protected Object queryParameters;
    protected Map<String, String> _queryParametersType;

    public InvokeApexRestMethodMessageProcessor(String operationName) {
        super(operationName);
    }

    public void initialise() throws InitialisationException {
    }

    public void start() throws MuleException {
        super.start();
    }

    public void stop() throws MuleException {
        super.stop();
    }

    public void dispose() {
        super.dispose();
    }

    public void setInput(Object value) {
        this.input = value;
    }

    public void setRequestHeaders(Object value) {
        this.requestHeaders = value;
    }

    public void setRestMethodName(Object value) {
        this.restMethodName = value;
    }

    public void setQueryParameters(Object value) {
        this.queryParameters = value;
    }

    public MuleEvent doProcess(MuleEvent event) throws Exception {
        Object moduleObject = null;
        moduleObject = this.findOrCreate(null, false, event);
        final String _transformedRestMethodName = (String)this.evaluateAndTransform(this.getMuleContext(), event, InvokeApexRestMethodMessageProcessor.class.getDeclaredField("_restMethodNameType").getGenericType(), null, this.restMethodName);
        final Object _transformedInput = this.evaluateAndTransform(this.getMuleContext(), event, InvokeApexRestMethodMessageProcessor.class.getDeclaredField("_inputType").getGenericType(), null, this.input);
        final ApexRequestHeaders _transformedRequestHeaders = (ApexRequestHeaders)this.evaluateAndTransform(this.getMuleContext(), event, InvokeApexRestMethodMessageProcessor.class.getDeclaredField("_requestHeadersType").getGenericType(), null, this.requestHeaders);
        final Map _transformedQueryParameters = (Map)this.evaluateAndTransform(this.getMuleContext(), event, InvokeApexRestMethodMessageProcessor.class.getDeclaredField("_queryParametersType").getGenericType(), null, this.queryParameters);
        ProcessTemplate processTemplate = ((ProcessAdapter)moduleObject).getProcessTemplate();
        Object resultPayload = processTemplate.execute((ProcessCallback)new ProcessCallback<Object, Object>(){

            public List<Class<? extends Exception>> getManagedExceptions() {
                return Arrays.asList(SalesforceSessionExpiredException.class);
            }

            public boolean isProtected() {
                return true;
            }

            public Object process(Object object) throws Exception {
                try {
                    return ((SalesforceConnector)object).invokeApexRestMethod(_transformedRestMethodName, _transformedInput, _transformedRequestHeaders, _transformedQueryParameters);
                }
                catch (Exception e) {
                    ExceptionDecorator handler = new ExceptionDecorator();
                    handler.process(e);
                    throw e;
                }
            }
        }, (MessageProcessor)this, event);
        event.getMessage().setPayload(resultPayload);
        return event;
    }

    public Result<MetaData> getInputMetaData() {
        if (this.restMethodName == null || this.restMethodName.toString() == null) {
            return new DefaultResult(null, Result.Status.FAILURE, "There was an error retrieving metadata from parameter: restMethodName at processor invokeApexRestMethod at module SalesforceConnector");
        }
        DefaultMetaDataKey metaDataKey = new DefaultMetaDataKey(this.restMethodName.toString(), null);
        metaDataKey.setCategory("ApexRestMetadataCategory");
        metaDataKey.addProperty((MetaDataKeyProperty)new TypeDescribingProperty(TypeDescribingProperty.TypeScope.INPUT, "invokeApexRestMethod"));
        Result<MetaData> genericMetaData = this.getGenericMetaData((MetaDataKey)metaDataKey);
        if (Result.Status.FAILURE.equals((Object)genericMetaData.getStatus())) {
            return genericMetaData;
        }
        MetaDataModel wrappedMetaDataModel = ((MetaData)genericMetaData.get()).getPayload();
        return new DefaultResult((Object)MetaDataGeneratorUtils.extractPropertiesToMetaData(wrappedMetaDataModel, (MetaData)genericMetaData.get()));
    }

    public Result<MetaData> getOutputMetaData(MetaData inputMetadata) {
        if (this.restMethodName == null || this.restMethodName.toString() == null) {
            return new DefaultResult(null, Result.Status.FAILURE, "There was an error retrieving metadata from parameter: restMethodName at processor invokeApexRestMethod at module SalesforceConnector");
        }
        DefaultMetaDataKey metaDataKey = new DefaultMetaDataKey(this.restMethodName.toString(), null);
        metaDataKey.setCategory("ApexRestMetadataCategory");
        metaDataKey.addProperty((MetaDataKeyProperty)new TypeDescribingProperty(TypeDescribingProperty.TypeScope.OUTPUT, "invokeApexRestMethod"));
        Result<MetaData> genericMetaData = this.getGenericMetaData((MetaDataKey)metaDataKey);
        if (Result.Status.FAILURE.equals((Object)genericMetaData.getStatus())) {
            return genericMetaData;
        }
        MetaDataModel wrappedMetaDataModel = ((MetaData)genericMetaData.get()).getPayload();
        ((MetaData)genericMetaData.get()).getPayload().addProperty((MetaDataModelProperty)new StructureIdentifierMetaDataModelProperty((MetaDataKey)metaDataKey, true));
        return new DefaultResult((Object)MetaDataGeneratorUtils.extractPropertiesToMetaData(wrappedMetaDataModel, (MetaData)genericMetaData.get()));
    }

    private MetaDataModel getPojoOrSimpleModel(Class clazz) {
        DataType dataType = DataTypeFactory.getInstance().getDataType(clazz);
        if (DataType.POJO.equals((Object)dataType)) {
            return new DefaultPojoMetaDataModel(clazz);
        }
        return new DefaultSimpleMetaDataModel(dataType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result<MetaData> getGenericMetaData(MetaDataKey metaDataKey) {
        try {
            ConnectorMetaDataEnabled connector = (ConnectorMetaDataEnabled)this.findOrCreate(null, false, null);
            try {
                Result metadata = connector.getMetaData(metaDataKey);
                if (Result.Status.FAILURE.equals((Object)metadata.getStatus())) {
                    return metadata;
                }
                if (metadata.get() == null) {
                    return new DefaultResult(null, Result.Status.FAILURE, "There was an error processing metadata at SalesforceConnector at invokeApexRestMethod retrieving was successful but result is null");
                }
                return metadata;
            }
            catch (Exception e) {
                return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
            }
        }
        catch (ClassCastException cast) {
            return new DefaultResult(null, Result.Status.FAILURE, "There was an error getting metadata, there was no connection manager available. Maybe you're trying to use metadata from an Oauth connector");
        }
        catch (ConfigurationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (RegistrationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (InstantiationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (Exception e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
    }
}

