/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.oauth;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.store.ObjectStore;
import org.mule.modules.salesforce.adapters.SalesforceConnectorOAuth2Adapter;
import org.mule.modules.salesforce.config.SalesforceOAuth2Config;
import org.mule.modules.salesforce.exception.SalesforceSessionExpiredException;
import org.mule.modules.salesforce.oauth.SalesforceConnectorOAuthClientFactory;
import org.mule.security.oauth.BaseOAuth2Manager;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.OAuth2Manager;
import org.mule.security.oauth.OnNoTokenPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforceConnectorOAuthManager
extends BaseOAuth2Manager<OAuth2Adapter> {
    private static Logger logger = LoggerFactory.getLogger(SalesforceConnectorOAuthManager.class);

    protected Logger getLogger() {
        return logger;
    }

    public void setTimeObjectStore(ObjectStore<? extends Serializable> value) {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        connector.setTimeObjectStore(value);
    }

    public ObjectStore<? extends Serializable> getTimeObjectStore() {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        return connector.getTimeObjectStore();
    }

    public void setBatchSobjectMaxDepth(Integer value) {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        connector.setBatchSobjectMaxDepth(value);
    }

    public Integer getBatchSobjectMaxDepth() {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        return connector.getBatchSobjectMaxDepth();
    }

    public void setConsumerKey(String value) {
        super.setConsumerKey(value);
    }

    public void setConsumerSecret(String value) {
        super.setConsumerSecret(value);
    }

    public void setApiVersion(Double value) {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        ((SalesforceOAuth2Config)connector.getConfig()).setApiVersion(value);
    }

    public Double getApiVersion() {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        return ((SalesforceOAuth2Config)connector.getConfig()).getApiVersion();
    }

    public void setClientId(String value) {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        ((SalesforceOAuth2Config)connector.getConfig()).setClientId(value);
    }

    public String getClientId() {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        return ((SalesforceOAuth2Config)connector.getConfig()).getClientId();
    }

    public void setAssignmentRuleId(String value) {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        ((SalesforceOAuth2Config)connector.getConfig()).setAssignmentRuleId(value);
    }

    public String getAssignmentRuleId() {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        return ((SalesforceOAuth2Config)connector.getConfig()).getAssignmentRuleId();
    }

    public void setUseDefaultRule(Boolean value) {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        ((SalesforceOAuth2Config)connector.getConfig()).setUseDefaultRule(value);
    }

    public Boolean getUseDefaultRule() {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        return ((SalesforceOAuth2Config)connector.getConfig()).getUseDefaultRule();
    }

    public void setAllowFieldTruncationSupport(Boolean value) {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        ((SalesforceOAuth2Config)connector.getConfig()).setAllowFieldTruncationSupport(value);
    }

    public Boolean getAllowFieldTruncationSupport() {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        return ((SalesforceOAuth2Config)connector.getConfig()).getAllowFieldTruncationSupport();
    }

    public void setFetchAllApexSoapMetadata(boolean value) {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        ((SalesforceOAuth2Config)connector.getConfig()).setFetchAllApexSoapMetadata(value);
    }

    public boolean getFetchAllApexSoapMetadata() {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        return ((SalesforceOAuth2Config)connector.getConfig()).getFetchAllApexSoapMetadata();
    }

    public void setFetchAllApexRestMetadata(boolean value) {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        ((SalesforceOAuth2Config)connector.getConfig()).setFetchAllApexRestMetadata(value);
    }

    public boolean getFetchAllApexRestMetadata() {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        return ((SalesforceOAuth2Config)connector.getConfig()).getFetchAllApexRestMetadata();
    }

    public void setApexClassNames(List<String> value) {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        ((SalesforceOAuth2Config)connector.getConfig()).setApexClassNames((List)value);
    }

    public List<String> getApexClassNames() {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        return ((SalesforceOAuth2Config)connector.getConfig()).getApexClassNames();
    }

    public void setReadTimeout(Integer value) {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        ((SalesforceOAuth2Config)connector.getConfig()).setReadTimeout(value);
    }

    public Integer getReadTimeout() {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        return ((SalesforceOAuth2Config)connector.getConfig()).getReadTimeout();
    }

    public void setConnectionTimeout(Integer value) {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        ((SalesforceOAuth2Config)connector.getConfig()).setConnectionTimeout(value);
    }

    public Integer getConnectionTimeout() {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        return ((SalesforceOAuth2Config)connector.getConfig()).getConnectionTimeout();
    }

    public void setProxyHost(String value) {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        ((SalesforceOAuth2Config)connector.getConfig()).setProxyHost(value);
    }

    public String getProxyHost() {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        return ((SalesforceOAuth2Config)connector.getConfig()).getProxyHost();
    }

    public void setProxyPort(String value) {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        ((SalesforceOAuth2Config)connector.getConfig()).setProxyPort(value);
    }

    public String getProxyPort() {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        return ((SalesforceOAuth2Config)connector.getConfig()).getProxyPort();
    }

    public void setProxyUsername(String value) {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        ((SalesforceOAuth2Config)connector.getConfig()).setProxyUsername(value);
    }

    public String getProxyUsername() {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        return ((SalesforceOAuth2Config)connector.getConfig()).getProxyUsername();
    }

    public void setProxyPassword(String value) {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        ((SalesforceOAuth2Config)connector.getConfig()).setProxyPassword(value);
    }

    public String getProxyPassword() {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)this.getDefaultUnauthorizedConnector();
        return ((SalesforceOAuth2Config)connector.getConfig()).getProxyPassword();
    }

    protected OAuth2Adapter instantiateAdapter() {
        return new SalesforceConnectorOAuth2Adapter((OAuth2Manager<OAuth2Adapter>)this);
    }

    protected KeyedPoolableObjectFactory createPoolFactory(OAuth2Manager<OAuth2Adapter> oauthManager, ObjectStore<Serializable> objectStore) {
        return new SalesforceConnectorOAuthClientFactory(oauthManager, objectStore);
    }

    protected void setCustomProperties(OAuth2Adapter adapter) {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)adapter;
        connector.setTimeObjectStore(this.getTimeObjectStore());
        connector.setBatchSobjectMaxDepth(this.getBatchSobjectMaxDepth());
        ((SalesforceOAuth2Config)connector.getConfig()).setConsumerKey(this.getConsumerKey());
        ((SalesforceOAuth2Config)connector.getConfig()).setConsumerSecret(this.getConsumerSecret());
        ((SalesforceOAuth2Config)connector.getConfig()).setApiVersion(this.getApiVersion());
        ((SalesforceOAuth2Config)connector.getConfig()).setClientId(this.getClientId());
        ((SalesforceOAuth2Config)connector.getConfig()).setAssignmentRuleId(this.getAssignmentRuleId());
        ((SalesforceOAuth2Config)connector.getConfig()).setUseDefaultRule(this.getUseDefaultRule());
        ((SalesforceOAuth2Config)connector.getConfig()).setAllowFieldTruncationSupport(this.getAllowFieldTruncationSupport());
        ((SalesforceOAuth2Config)connector.getConfig()).setFetchAllApexSoapMetadata(this.getFetchAllApexSoapMetadata());
        ((SalesforceOAuth2Config)connector.getConfig()).setFetchAllApexRestMetadata(this.getFetchAllApexRestMetadata());
        ((SalesforceOAuth2Config)connector.getConfig()).setApexClassNames((List)this.getApexClassNames());
        ((SalesforceOAuth2Config)connector.getConfig()).setReadTimeout(this.getReadTimeout());
        ((SalesforceOAuth2Config)connector.getConfig()).setConnectionTimeout(this.getConnectionTimeout());
        ((SalesforceOAuth2Config)connector.getConfig()).setProxyHost(this.getProxyHost());
        ((SalesforceOAuth2Config)connector.getConfig()).setProxyPort(this.getProxyPort());
        ((SalesforceOAuth2Config)connector.getConfig()).setProxyUsername(this.getProxyUsername());
        ((SalesforceOAuth2Config)connector.getConfig()).setProxyPassword(this.getProxyPassword());
    }

    protected void fetchCallbackParameters(OAuth2Adapter adapter, String response) {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)adapter;
        ExpressionManager expressionManager = this.muleContext.getExpressionManager();
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)response, this.muleContext);
        ((SalesforceOAuth2Config)connector.getConfig()).setInstanceId((String)expressionManager.evaluate("#[json:instance_url]", (MuleMessage)muleMessage));
        ((SalesforceOAuth2Config)connector.getConfig()).setUserId((String)expressionManager.evaluate("#[json:id]", (MuleMessage)muleMessage));
    }

    public void setOnNoToken(OnNoTokenPolicy policy) {
        this.getDefaultUnauthorizedConnector().setOnNoTokenPolicy(policy);
    }

    protected Set<Class<? extends Exception>> refreshAccessTokenOn() {
        HashSet<Class<? extends Exception>> types = new HashSet<Class<? extends Exception>>();
        types.add(SalesforceSessionExpiredException.class);
        return types;
    }
}

