/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.oauth;

import java.io.Serializable;
import java.util.List;
import org.mule.api.store.ObjectStore;
import org.mule.common.security.oauth.OAuthState;
import org.mule.modules.salesforce.adapters.SalesforceConnectorOAuth2Adapter;
import org.mule.modules.salesforce.config.SalesforceOAuth2Config;
import org.mule.modules.salesforce.oauth.SalesforceConnectorOAuthManager;
import org.mule.security.oauth.BaseOAuthClientFactory;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.OAuth2Manager;

public class SalesforceConnectorOAuthClientFactory
extends BaseOAuthClientFactory {
    private SalesforceConnectorOAuthManager oauthManager;

    public SalesforceConnectorOAuthClientFactory(OAuth2Manager<OAuth2Adapter> oauthManager, ObjectStore<Serializable> objectStore) {
        super(oauthManager, objectStore);
        this.oauthManager = (SalesforceConnectorOAuthManager)oauthManager;
    }

    protected Class<? extends OAuth2Adapter> getAdapterClass() {
        return SalesforceConnectorOAuth2Adapter.class;
    }

    protected void setCustomAdapterProperties(OAuth2Adapter adapter, OAuthState state) {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)adapter;
        ((SalesforceOAuth2Config)connector.getConfig()).setInstanceId(state.getCustomProperty("instanceId"));
        ((SalesforceOAuth2Config)connector.getConfig()).setUserId(state.getCustomProperty("userId"));
        connector.setTimeObjectStore(this.oauthManager.getTimeObjectStore());
        connector.setBatchSobjectMaxDepth(this.oauthManager.getBatchSobjectMaxDepth());
        ((SalesforceOAuth2Config)connector.getConfig()).setApiVersion(this.oauthManager.getApiVersion());
        ((SalesforceOAuth2Config)connector.getConfig()).setClientId(this.oauthManager.getClientId());
        ((SalesforceOAuth2Config)connector.getConfig()).setAssignmentRuleId(this.oauthManager.getAssignmentRuleId());
        ((SalesforceOAuth2Config)connector.getConfig()).setUseDefaultRule(this.oauthManager.getUseDefaultRule());
        ((SalesforceOAuth2Config)connector.getConfig()).setAllowFieldTruncationSupport(this.oauthManager.getAllowFieldTruncationSupport());
        ((SalesforceOAuth2Config)connector.getConfig()).setFetchAllApexSoapMetadata(this.oauthManager.getFetchAllApexSoapMetadata());
        ((SalesforceOAuth2Config)connector.getConfig()).setFetchAllApexRestMetadata(this.oauthManager.getFetchAllApexRestMetadata());
        ((SalesforceOAuth2Config)connector.getConfig()).setApexClassNames((List)this.oauthManager.getApexClassNames());
        ((SalesforceOAuth2Config)connector.getConfig()).setReadTimeout(this.oauthManager.getReadTimeout());
        ((SalesforceOAuth2Config)connector.getConfig()).setConnectionTimeout(this.oauthManager.getConnectionTimeout());
        ((SalesforceOAuth2Config)connector.getConfig()).setProxyHost(this.oauthManager.getProxyHost());
        ((SalesforceOAuth2Config)connector.getConfig()).setProxyPort(this.oauthManager.getProxyPort());
        ((SalesforceOAuth2Config)connector.getConfig()).setProxyUsername(this.oauthManager.getProxyUsername());
        ((SalesforceOAuth2Config)connector.getConfig()).setProxyPassword(this.oauthManager.getProxyPassword());
    }

    protected void setCustomStateProperties(OAuth2Adapter adapter, OAuthState state) {
        SalesforceConnectorOAuth2Adapter connector = (SalesforceConnectorOAuth2Adapter)adapter;
        state.setCustomProperty("instanceId", ((SalesforceOAuth2Config)connector.getConfig()).getInstanceId());
        state.setCustomProperty("userId", ((SalesforceOAuth2Config)connector.getConfig()).getUserId());
    }
}

