/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.lazystream.impl;

import com.sforce.async.AsyncApiException;
import com.sforce.async.BulkConnection;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.modules.salesforce.lazystream.LazyInputStream;

public class LazyQueryResultInputStream
extends LazyInputStream {
    private static final Log logger = LogFactory.getLog(LazyInputStream.class);
    private String jobId;
    private String batchId;
    private String jobResultId;

    public LazyQueryResultInputStream(BulkConnection connection, String jobId, String batchId, String jobResultId) {
        super(connection);
        this.jobId = jobId;
        this.batchId = batchId;
        this.jobResultId = jobResultId;
    }

    @Override
    protected InputStream openLazyInputStream() throws IOException {
        try {
            logger.debug((Object)String.format("OPENING LAZY STREAM -- JobId[%s] BatchId[%s] JobResultId[%s]", this.jobId, this.batchId, this.jobResultId));
            InputStream queryResultStream = this.getBulkConnection().getQueryResultStream(this.jobId, this.batchId, this.jobResultId);
            logger.debug((Object)String.format("OPENED LAZY STREAM -- JobId[%s] BatchId[%s] JobResultId[%s]", this.jobId, this.batchId, this.jobResultId));
            return queryResultStream;
        }
        catch (AsyncApiException e) {
            throw new IOException(e);
        }
    }
}

