/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.connectivity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.pool.KeyedObjectPool;
import org.mule.api.MetadataAware;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.context.MuleContextAware;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.devkit.capability.Capabilities;
import org.mule.api.devkit.capability.ModuleCapability;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.store.ObjectStore;
import org.mule.common.DefaultResult;
import org.mule.common.DefaultTestResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.Testable;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataFailureType;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModelProperty;
import org.mule.common.metadata.NativeQueryMetadataTranslator;
import org.mule.common.metadata.key.property.TypeDescribingProperty;
import org.mule.common.metadata.property.StructureIdentifierMetaDataModelProperty;
import org.mule.common.query.DsqlQuery;
import org.mule.config.PoolingProfile;
import org.mule.devkit.3.6.1.shade.connection.management.ConnectionManagementConnectionAdapter;
import org.mule.devkit.3.6.1.shade.connection.management.ConnectionManagementConnectionManager;
import org.mule.devkit.3.6.1.shade.connection.management.ConnectionManagementConnectorAdapter;
import org.mule.devkit.3.6.1.shade.connection.management.ConnectionManagementConnectorFactory;
import org.mule.devkit.3.6.1.shade.connection.management.ConnectionManagementProcessTemplate;
import org.mule.devkit.3.6.1.shade.connection.management.UnableToAcquireConnectionException;
import org.mule.devkit.3.6.1.shade.connectivity.ConnectivityTestingErrorHandler;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.modules.salesforce.adapters.SalesforceConnectorConnectionManagementAdapter;
import org.mule.modules.salesforce.category.ApexRestMetadataCategory;
import org.mule.modules.salesforce.category.ApexSoapMetadataCategory;
import org.mule.modules.salesforce.category.MetadataCategory;
import org.mule.modules.salesforce.category.SalesforceMetadataCategory;
import org.mule.modules.salesforce.config.SalesforceOAuthJWTConfig;
import org.mule.modules.salesforce.connectivity.ConnectionManagementConfigOauthJwtBearerSalesforceConnectorConnectionKey;
import org.mule.modules.salesforce.connectivity.SalesforceOAuthJWTConfigSalesforceConnectorAdapter;
import org.mule.modules.salesforce.pooling.DevkitGenericKeyedObjectPool;

public class SalesforceConnectorConfigOauthJwtBearerConnectionManagementConnectionManager
extends ExpressionEvaluatorSupport
implements MetadataAware,
MuleContextAware,
ProcessAdapter<SalesforceConnectorConnectionManagementAdapter>,
Capabilities,
Disposable,
Initialisable,
Testable,
ConnectorMetaDataEnabled,
NativeQueryMetadataTranslator,
ConnectionManagementConnectionManager<ConnectionManagementConfigOauthJwtBearerSalesforceConnectorConnectionKey, SalesforceConnectorConnectionManagementAdapter, SalesforceOAuthJWTConfig> {
    private String consumerKey;
    private String keyStore;
    private String storePassword;
    private ObjectStore<? extends Serializable> timeObjectStore;
    private Integer batchSobjectMaxDepth;
    private String principal;
    private String tokenEndpoint;
    private boolean disableSessionInvalidation;
    private Double apiVersion;
    private String clientId;
    private String assignmentRuleId;
    private Boolean useDefaultRule;
    private Boolean allowFieldTruncationSupport;
    private boolean fetchAllApexSoapMetadata;
    private boolean fetchAllApexRestMetadata;
    private List<String> apexClassNames;
    private Integer readTimeout;
    private Integer connectionTimeout;
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    protected MuleContext muleContext;
    private KeyedObjectPool connectionPool;
    protected PoolingProfile poolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private static final String MODULE_NAME = "Salesforce";
    private static final String MODULE_VERSION = "6.2.6";
    private static final String DEVKIT_VERSION = "3.6.1";
    private static final String DEVKIT_BUILD = "UNNAMED.2405.44720b7";
    private static final String MIN_MULE_VERSION = "3.5";

    public void setConsumerKey(String value) {
        this.consumerKey = value;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setKeyStore(String value) {
        this.keyStore = value;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setStorePassword(String value) {
        this.storePassword = value;
    }

    public String getStorePassword() {
        return this.storePassword;
    }

    public void setTimeObjectStore(ObjectStore<? extends Serializable> value) {
        this.timeObjectStore = value;
    }

    public ObjectStore<? extends Serializable> getTimeObjectStore() {
        return this.timeObjectStore;
    }

    public void setBatchSobjectMaxDepth(Integer value) {
        this.batchSobjectMaxDepth = value;
    }

    public Integer getBatchSobjectMaxDepth() {
        return this.batchSobjectMaxDepth;
    }

    public void setPrincipal(String value) {
        this.principal = value;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setTokenEndpoint(String value) {
        this.tokenEndpoint = value;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void setDisableSessionInvalidation(boolean value) {
        this.disableSessionInvalidation = value;
    }

    public boolean getDisableSessionInvalidation() {
        return this.disableSessionInvalidation;
    }

    public void setApiVersion(Double value) {
        this.apiVersion = value;
    }

    public Double getApiVersion() {
        return this.apiVersion;
    }

    public void setClientId(String value) {
        this.clientId = value;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setAssignmentRuleId(String value) {
        this.assignmentRuleId = value;
    }

    public String getAssignmentRuleId() {
        return this.assignmentRuleId;
    }

    public void setUseDefaultRule(Boolean value) {
        this.useDefaultRule = value;
    }

    public Boolean getUseDefaultRule() {
        return this.useDefaultRule;
    }

    public void setAllowFieldTruncationSupport(Boolean value) {
        this.allowFieldTruncationSupport = value;
    }

    public Boolean getAllowFieldTruncationSupport() {
        return this.allowFieldTruncationSupport;
    }

    public void setFetchAllApexSoapMetadata(boolean value) {
        this.fetchAllApexSoapMetadata = value;
    }

    public boolean getFetchAllApexSoapMetadata() {
        return this.fetchAllApexSoapMetadata;
    }

    public void setFetchAllApexRestMetadata(boolean value) {
        this.fetchAllApexRestMetadata = value;
    }

    public boolean getFetchAllApexRestMetadata() {
        return this.fetchAllApexRestMetadata;
    }

    public void setApexClassNames(List<String> value) {
        this.apexClassNames = value;
    }

    public List<String> getApexClassNames() {
        return this.apexClassNames;
    }

    public void setReadTimeout(Integer value) {
        this.readTimeout = value;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setConnectionTimeout(Integer value) {
        this.connectionTimeout = value;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setProxyHost(String value) {
        this.proxyHost = value;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyPort(String value) {
        this.proxyPort = value;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyUsername(String value) {
        this.proxyUsername = value;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyPassword(String value) {
        this.proxyPassword = value;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setPoolingProfile(PoolingProfile value) {
        this.poolingProfile = value;
    }

    public PoolingProfile getPoolingProfile() {
        return this.poolingProfile;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void initialise() {
        this.connectionPool = new DevkitGenericKeyedObjectPool(new ConnectionManagementConnectorFactory(this), this.poolingProfile);
        if (this.retryPolicyTemplate == null) {
            this.retryPolicyTemplate = (RetryPolicyTemplate)this.muleContext.getRegistry().lookupObject("_defaultRetryPolicyTemplate");
        }
    }

    public void dispose() {
        try {
            this.connectionPool.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public SalesforceConnectorConnectionManagementAdapter acquireConnection(ConnectionManagementConfigOauthJwtBearerSalesforceConnectorConnectionKey key) throws Exception {
        return (SalesforceConnectorConnectionManagementAdapter)this.connectionPool.borrowObject((Object)key);
    }

    @Override
    public void releaseConnection(ConnectionManagementConfigOauthJwtBearerSalesforceConnectorConnectionKey key, SalesforceConnectorConnectionManagementAdapter connection) throws Exception {
        this.connectionPool.returnObject((Object)key, (Object)connection);
    }

    @Override
    public void destroyConnection(ConnectionManagementConfigOauthJwtBearerSalesforceConnectorConnectionKey key, SalesforceConnectorConnectionManagementAdapter connection) throws Exception {
        this.connectionPool.invalidateObject((Object)key, (Object)connection);
    }

    public boolean isCapableOf(ModuleCapability capability) {
        if (capability == ModuleCapability.LIFECYCLE_CAPABLE) {
            return true;
        }
        return capability == ModuleCapability.CONNECTION_MANAGEMENT_CAPABLE;
    }

    public <P> ProcessTemplate<P, SalesforceConnectorConnectionManagementAdapter> getProcessTemplate() {
        return new ConnectionManagementProcessTemplate(this, this.muleContext);
    }

    @Override
    public ConnectionManagementConfigOauthJwtBearerSalesforceConnectorConnectionKey getDefaultConnectionKey() {
        return new ConnectionManagementConfigOauthJwtBearerSalesforceConnectorConnectionKey(this.getConsumerKey(), this.getKeyStore(), this.getStorePassword());
    }

    @Override
    public ConnectionManagementConfigOauthJwtBearerSalesforceConnectorConnectionKey getEvaluatedConnectionKey(MuleEvent event) throws Exception {
        if (event != null) {
            String _transformedConsumerKey = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("consumerKey").getGenericType(), null, this.getConsumerKey());
            if (_transformedConsumerKey == null) {
                throw new UnableToAcquireConnectionException("Parameter consumerKey in method connect can't be null because is not @Optional");
            }
            String _transformedKeyStore = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("keyStore").getGenericType(), null, this.getKeyStore());
            if (_transformedKeyStore == null) {
                throw new UnableToAcquireConnectionException("Parameter keyStore in method connect can't be null because is not @Optional");
            }
            String _transformedStorePassword = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("storePassword").getGenericType(), null, this.getStorePassword());
            if (_transformedStorePassword == null) {
                throw new UnableToAcquireConnectionException("Parameter storePassword in method connect can't be null because is not @Optional");
            }
            return new ConnectionManagementConfigOauthJwtBearerSalesforceConnectorConnectionKey(_transformedConsumerKey, _transformedKeyStore, _transformedStorePassword);
        }
        return this.getDefaultConnectionKey();
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }

    public String getMinMuleVersion() {
        return MIN_MULE_VERSION;
    }

    @Override
    public ConnectionManagementConfigOauthJwtBearerSalesforceConnectorConnectionKey getConnectionKey(MessageProcessor messageProcessor, MuleEvent event) throws Exception {
        return this.getEvaluatedConnectionKey(event);
    }

    @Override
    public ConnectionManagementConnectionAdapter newConnection() {
        SalesforceOAuthJWTConfigSalesforceConnectorAdapter connection = new SalesforceOAuthJWTConfigSalesforceConnectorAdapter();
        connection.setPrincipal(this.getPrincipal());
        connection.setTokenEndpoint(this.getTokenEndpoint());
        connection.setDisableSessionInvalidation(this.getDisableSessionInvalidation());
        connection.setApiVersion(this.getApiVersion());
        connection.setClientId(this.getClientId());
        connection.setAssignmentRuleId(this.getAssignmentRuleId());
        connection.setUseDefaultRule(this.getUseDefaultRule());
        connection.setAllowFieldTruncationSupport(this.getAllowFieldTruncationSupport());
        connection.setFetchAllApexSoapMetadata(this.getFetchAllApexSoapMetadata());
        connection.setFetchAllApexRestMetadata(this.getFetchAllApexRestMetadata());
        connection.setApexClassNames((List)this.getApexClassNames());
        connection.setReadTimeout(this.getReadTimeout());
        connection.setConnectionTimeout(this.getConnectionTimeout());
        connection.setProxyHost(this.getProxyHost());
        connection.setProxyPort(this.getProxyPort());
        connection.setProxyUsername(this.getProxyUsername());
        connection.setProxyPassword(this.getProxyPassword());
        return connection;
    }

    @Override
    public ConnectionManagementConnectorAdapter newConnector(ConnectionManagementConnectionAdapter<SalesforceOAuthJWTConfig, ConnectionManagementConfigOauthJwtBearerSalesforceConnectorConnectionKey> connection) {
        SalesforceConnectorConnectionManagementAdapter connector = new SalesforceConnectorConnectionManagementAdapter();
        connector.setConfig(connection.getStrategy());
        connector.setTimeObjectStore(this.getTimeObjectStore());
        connector.setBatchSobjectMaxDepth(this.getBatchSobjectMaxDepth());
        return connector;
    }

    @Override
    public ConnectionManagementConnectionAdapter getConnectionAdapter(ConnectionManagementConnectorAdapter adapter) {
        SalesforceConnectorConnectionManagementAdapter connector = (SalesforceConnectorConnectionManagementAdapter)adapter;
        ConnectionManagementConnectionAdapter strategy = (ConnectionManagementConnectionAdapter)((Object)connector.getConfig());
        return strategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult test() {
        DefaultTestResult result;
        SalesforceConnectorConnectionManagementAdapter connection = null;
        ConnectionManagementConfigOauthJwtBearerSalesforceConnectorConnectionKey key = this.getDefaultConnectionKey();
        try {
            connection = this.acquireConnection(key);
            result = new DefaultTestResult(Result.Status.SUCCESS);
        }
        catch (Exception e) {
            try {
                this.destroyConnection(key, connection);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = (DefaultTestResult)ConnectivityTestingErrorHandler.buildFailureTestResult(e);
        }
        finally {
            if (connection != null) {
                try {
                    this.releaseConnection(key, connection);
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Result<List<MetaDataKey>> getMetaDataKeys() {
        SalesforceConnectorConnectionManagementAdapter connection = null;
        ConnectionManagementConfigOauthJwtBearerSalesforceConnectorConnectionKey key = this.getDefaultConnectionKey();
        try {
            connection = this.acquireConnection(key);
            try {
                ArrayList<MetaDataKey> gatheredMetaDataKeys = new ArrayList<MetaDataKey>();
                ApexRestMetadataCategory apexRestMetadataCategory = new ApexRestMetadataCategory();
                apexRestMetadataCategory.setConnector(connection);
                gatheredMetaDataKeys.addAll(this.fillCategory(apexRestMetadataCategory.getMetaDataKeys(), "ApexRestMetadataCategory"));
                SalesforceMetadataCategory salesforceMetadataCategory = new SalesforceMetadataCategory();
                salesforceMetadataCategory.setConnector(connection);
                gatheredMetaDataKeys.addAll(this.fillCategory(salesforceMetadataCategory.getMetaDataKeys(), "SalesforceMetadataCategory"));
                MetadataCategory metadataCategory = new MetadataCategory();
                metadataCategory.setConnector(connection);
                gatheredMetaDataKeys.addAll(this.fillCategory(metadataCategory.getMetadataKeys(), "MetadataCategory"));
                ApexSoapMetadataCategory apexSoapMetadataCategory = new ApexSoapMetadataCategory();
                apexSoapMetadataCategory.setSalesforceConnector(connection);
                gatheredMetaDataKeys.addAll(this.fillCategory(apexSoapMetadataCategory.getMetadataKeys(), "ApexSoapMetadataCategory"));
                DefaultResult defaultResult = new DefaultResult(gatheredMetaDataKeys, Result.Status.SUCCESS);
                return defaultResult;
            }
            catch (Exception e) {
                DefaultResult defaultResult;
                block19: {
                    defaultResult = new DefaultResult(null, Result.Status.FAILURE, "There was an error retrieving the metadata keys from service provider after acquiring connection, for more detailed information please read the provided stacktrace", (FailureType)MetaDataFailureType.ERROR_METADATA_KEYS_RETRIEVER, (Throwable)e);
                    if (connection == null) break block19;
                    try {
                        this.releaseConnection(key, connection);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return defaultResult;
                catch (Exception e2) {
                    try {
                        this.destroyConnection(key, connection);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    DefaultResult defaultResult2 = ConnectivityTestingErrorHandler.buildFailureTestResult(e2);
                    return defaultResult2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (connection != null) {
                try {
                    this.releaseConnection(key, connection);
                }
                catch (Exception exception) {}
            }
        }
    }

    private List<MetaDataKey> fillCategory(List<MetaDataKey> metadataKeys, String categoryClassName) {
        for (MetaDataKey metaDataKey : metadataKeys) {
            ((DefaultMetaDataKey)metaDataKey).setCategory(categoryClassName);
        }
        return metadataKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Result<MetaData> getMetaData(MetaDataKey metaDataKey) {
        SalesforceConnectorConnectionManagementAdapter connection = null;
        ConnectionManagementConfigOauthJwtBearerSalesforceConnectorConnectionKey key = this.getDefaultConnectionKey();
        try {
            connection = this.acquireConnection(key);
            try {
                MetaData metaData = null;
                TypeDescribingProperty property = (TypeDescribingProperty)metaDataKey.getProperty(TypeDescribingProperty.class);
                String category = ((DefaultMetaDataKey)metaDataKey).getCategory();
                if (category == null) throw new Exception("Invalid key type. There is no matching category for [" + metaDataKey.getId() + "]. All keys must contain a category with any of the following options:[ApexRestMetadataCategory, SalesforceMetadataCategory, MetadataCategory, ApexSoapMetadataCategory]");
                if (category.equals("ApexRestMetadataCategory")) {
                    ApexRestMetadataCategory apexRestMetadataCategory = new ApexRestMetadataCategory();
                    apexRestMetadataCategory.setConnector(connection);
                    metaData = property != null && property.getTypeScope().equals((Object)TypeDescribingProperty.TypeScope.OUTPUT) ? apexRestMetadataCategory.getOutputMetaData(metaDataKey) : apexRestMetadataCategory.getInputMetaData(metaDataKey);
                } else if (category.equals("SalesforceMetadataCategory")) {
                    SalesforceMetadataCategory salesforceMetadataCategory = new SalesforceMetadataCategory();
                    salesforceMetadataCategory.setConnector(connection);
                    metaData = salesforceMetadataCategory.getMetaData(metaDataKey);
                } else if (category.equals("MetadataCategory")) {
                    MetadataCategory metadataCategory = new MetadataCategory();
                    metadataCategory.setConnector(connection);
                    metaData = property != null && property.getTypeScope().equals((Object)TypeDescribingProperty.TypeScope.OUTPUT) ? metadataCategory.getOutputMetaData(metaDataKey) : metadataCategory.getMetaData(metaDataKey);
                } else {
                    if (!category.equals("ApexSoapMetadataCategory")) throw new Exception("Invalid key type. There is no matching category for [" + metaDataKey.getId() + "]. All keys must contain a category with any of the following options:[ApexRestMetadataCategory, SalesforceMetadataCategory, MetadataCategory, ApexSoapMetadataCategory]" + ", but found [" + category + "] instead");
                    ApexSoapMetadataCategory apexSoapMetadataCategory = new ApexSoapMetadataCategory();
                    apexSoapMetadataCategory.setSalesforceConnector(connection);
                    metaData = property != null && property.getTypeScope().equals((Object)TypeDescribingProperty.TypeScope.OUTPUT) ? apexSoapMetadataCategory.getOutputMetaData(metaDataKey) : apexSoapMetadataCategory.getInputMetaData(metaDataKey);
                }
                metaData.getPayload().addProperty((MetaDataModelProperty)new StructureIdentifierMetaDataModelProperty(metaDataKey, false));
                DefaultResult defaultResult = new DefaultResult((Object)metaData);
                return defaultResult;
            }
            catch (Exception e) {
                DefaultResult defaultResult = new DefaultResult(null, Result.Status.FAILURE, this.getMetaDataException(metaDataKey), (FailureType)MetaDataFailureType.ERROR_METADATA_RETRIEVER, (Throwable)e);
                if (connection == null) return defaultResult;
                try {
                    this.releaseConnection(key, connection);
                    return defaultResult;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return defaultResult;
                catch (Exception e2) {
                    try {
                        this.destroyConnection(key, connection);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    DefaultResult defaultResult2 = ConnectivityTestingErrorHandler.buildFailureTestResult(e2);
                    return defaultResult2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (connection != null) {
                try {
                    this.releaseConnection(key, connection);
                }
                catch (Exception exception) {}
            }
        }
    }

    private String getMetaDataException(MetaDataKey key) {
        if (key != null && key.getId() != null) {
            return "There was an error retrieving metadata from key: " + key.getId() + " after acquiring the connection, for more detailed information please read the provided stacktrace";
        }
        return "There was an error retrieving metadata after acquiring the connection, MetaDataKey is null or its id is null, for more detailed information please read the provided stacktrace";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<String> toNativeQuery(DsqlQuery query) {
        DefaultResult result;
        SalesforceConnectorConnectionManagementAdapter connection = null;
        ConnectionManagementConfigOauthJwtBearerSalesforceConnectorConnectionKey key = this.getDefaultConnectionKey();
        try {
            connection = this.acquireConnection(key);
            result = new DefaultResult((Object)connection.toNativeQuery(query).toString());
        }
        catch (Exception e) {
            try {
                this.destroyConnection(key, connection);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = new DefaultResult(null, Result.Status.FAILURE, e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    this.releaseConnection(key, connection);
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }
}

