/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.config;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.signature.Signer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SignerService {
    private static final Logger logger = LoggerFactory.getLogger(SignerService.class);

    SignerService() {
    }

    public byte[] signPayload(String allowedAlg, byte[] payload, InputStream keyStoreStream, String keyStoreType, char[] storePass) throws Exception {
        byte[] result = null;
        try {
            KeyStore keystore = this.loadKeyStore(keyStoreStream, keyStoreType, storePass);
            String aliasName = this.extractAlias(keystore);
            PrivateKey privateKey = (PrivateKey)keystore.getKey(aliasName, storePass);
            String signAlgorithm = null;
            Certificate cert = keystore.getCertificate(aliasName);
            if (cert instanceof X509Certificate) {
                signAlgorithm = ((X509Certificate)cert).getSigAlgName();
                if (!allowedAlg.equalsIgnoreCase(signAlgorithm)) {
                    throw new IOException(String.format("Algorithm used by keystore: \"%s\", not allowed. Expected algorithm: \"%s\"", signAlgorithm, allowedAlg));
                }
            } else {
                throw new IOException("Unknown certificate type: " + cert.getClass().getName());
            }
            Signature signature = Signature.getInstance(signAlgorithm);
            signature.initSign(privateKey);
            signature.update(payload);
            result = signature.sign();
        }
        catch (Exception e) {
            logger.error("Failed signing payload", (Throwable)e);
            throw e;
        }
        return result;
    }

    private KeyStore loadKeyStore(InputStream keyStoreStream, String keyStoreType, char[] storePass) throws Exception {
        KeyStore keystore = KeyStore.getInstance(keyStoreType);
        keystore.load(keyStoreStream, storePass);
        return keystore;
    }

    private String extractAlias(KeyStore keyStore) throws Exception {
        Enumeration<String> aliases = keyStore.aliases();
        String aliasName = null;
        if (aliases.hasMoreElements()) {
            aliasName = aliases.nextElement();
            if (aliases.hasMoreElements()) {
                logger.warn("There are more than one alias, picked first one with name: {}", (Object)aliasName);
            }
        } else {
            throw new IOException("Keystore contains no certificate");
        }
        return aliasName;
    }

    public void signSAMLObject(SignableSAMLObject samlObject, InputStream keyStoreStream, String keyStoreType, char[] storePass) throws Exception {
        try {
            KeyStore keystore = this.loadKeyStore(keyStoreStream, keyStoreType, storePass);
            String aliasName = this.extractAlias(keystore);
            PrivateKey privateKey = (PrivateKey)keystore.getKey(aliasName, storePass);
            X509Certificate x509Certificate = null;
            Certificate cert = keystore.getCertificate(aliasName);
            if (!(cert instanceof X509Certificate)) {
                throw new IOException("Unknown certificate type: " + cert.getClass().getName());
            }
            x509Certificate = (X509Certificate)cert;
            BasicX509Credential credential = new BasicX509Credential();
            credential.setEntityCertificate(x509Certificate);
            credential.setPrivateKey(privateKey);
            org.opensaml.xml.signature.Signature signature = (org.opensaml.xml.signature.Signature)Configuration.getBuilderFactory().getBuilder(org.opensaml.xml.signature.Signature.DEFAULT_ELEMENT_NAME).buildObject(org.opensaml.xml.signature.Signature.DEFAULT_ELEMENT_NAME);
            signature.setSigningCredential((Credential)credential);
            SecurityHelper.prepareSignatureParams((org.opensaml.xml.signature.Signature)signature, (Credential)credential, null, null);
            samlObject.setSignature(signature);
            Configuration.getMarshallerFactory().getMarshaller((XMLObject)samlObject).marshall((XMLObject)samlObject);
            Signer.signObject((org.opensaml.xml.signature.Signature)signature);
        }
        catch (Exception e) {
            logger.error("Failed signing SAML object", (Throwable)e);
            throw e;
        }
    }
}

