/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.config;

import com.sforce.soap.partner.Connector;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.StatusCode;
import com.sforce.ws.ConnectorConfig;
import java.net.URI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mule.RequestContext;
import org.mule.modules.salesforce.config.AbstractOAuthConfig;
import org.mule.modules.salesforce.config.CustomPartnerConnection;
import org.mule.modules.salesforce.exception.SalesforceException;

public class SalesforceOAuth2Config
extends AbstractOAuthConfig {
    private static final String FLOWVAR_REMOTE_USER_ID = "remoteUserId";
    private String consumerKey;
    private String consumerSecret;
    private String accessToken;
    private String instanceId;
    private String userId;

    public void postAuthorize() throws SalesforceException {
        if (this.getAccessToken() == null) {
            throw new SalesforceException(StatusCode.UNKNOWN_EXCEPTION, "Not able to extract \"accessToken\" neither from response returned on callback nor from an object store.");
        }
        if (this.getInstanceId() == null) {
            throw new SalesforceException(StatusCode.UNKNOWN_EXCEPTION, "Not able to extract \"instanceId\" neither from response returned on callback nor from an object store.");
        }
        try {
            this.verifyApiVersion();
            ConnectorConfig config = new ConnectorConfig();
            this.initConnectionConfig(config);
            this.setOAuth2AccessToken(this.getAccessToken());
            this.setOAuth2instanceId(this.getInstanceId());
            String serviceEndpoint = "https://" + new URI(this.getInstanceId()).getHost() + "/services/Soap/u/" + this.getApiVersion();
            config.setServiceEndpoint(serviceEndpoint);
            config.setSessionId(this.getAccessToken());
            PartnerConnection salesforcePartnerConnection = Connector.newConnection((ConnectorConfig)config);
            CustomPartnerConnection customPartnerConnection = new CustomPartnerConnection();
            customPartnerConnection.setConnection(salesforcePartnerConnection);
            this.setCustomPartnerConnection(customPartnerConnection);
            RequestContext.getEvent().setFlowVariable(FLOWVAR_REMOTE_USER_ID, (Object)this.getUserId());
        }
        catch (Exception e) {
            throw new SalesforceException(StatusCode.UNKNOWN_EXCEPTION, "Something went wrong while establishing connection with Salesforce.", e);
        }
    }

    @NotNull
    public String getConsumerKey() {
        return this.consumerKey;
    }

    @NotNull
    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(@NotNull String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public void setConsumerKey(@NotNull String consumerKey) {
        this.consumerKey = consumerKey;
    }

    @Nullable
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(@Nullable String accessToken) {
        this.accessToken = accessToken;
    }

    @Nullable
    public String getInstanceId() {
        return this.instanceId;
    }

    @Nullable
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(@Nullable String userId) {
        this.userId = userId;
    }

    public void setInstanceId(@Nullable String instanceId) {
        this.instanceId = instanceId;
    }

    @Override
    protected boolean isDisableSessionInvalidationActive() {
        return false;
    }
}

