/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.config;

import org.mule.config.MuleManifest;
import org.mule.modules.salesforce.oauth.SalesforceConnectorOAuthManager;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class SalesforceConnectorSalesforceOAuth2ConfigConfigDefinitionParser
extends AbstractDevkitBasedDefinitionParser {
    private static Logger logger = LoggerFactory.getLogger(SalesforceConnectorSalesforceOAuth2ConfigConfigDefinitionParser.class);

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Element oauthStoreConfigElement;
        this.parseConfigName(element);
        BeanDefinitionBuilder builder = this.getBeanDefinitionBuilder(parserContext);
        builder.setScope("singleton");
        if (this.hasAttribute(element, "timeObjectStore-ref")) {
            if (element.getAttribute("timeObjectStore-ref").startsWith("#")) {
                builder.addPropertyValue("timeObjectStore", (Object)element.getAttribute("timeObjectStore-ref"));
            } else {
                builder.addPropertyValue("timeObjectStore", (Object)new RuntimeBeanReference(element.getAttribute("timeObjectStore-ref")));
            }
        }
        this.parseProperty(builder, element, "batchSobjectMaxDepth", "batchSobjectMaxDepth");
        this.setInitMethodIfNeeded(builder, SalesforceConnectorOAuthManager.class);
        this.setDestroyMethodIfNeeded(builder, SalesforceConnectorOAuthManager.class);
        this.parseProperty(builder, element, "name", "name");
        this.parseProperty(builder, element, "authorizationUrl");
        this.parseProperty(builder, element, "accessTokenUrl");
        this.parseProperty(builder, element, "onNoToken");
        Element oauthHttpCallbackConfigElement = DomUtils.getChildElementByTagName((Element)element, (String)"oauth-callback-config");
        if (oauthHttpCallbackConfigElement != null) {
            this.parseProperty(builder, oauthHttpCallbackConfigElement, "domain");
            this.parseProperty(builder, oauthHttpCallbackConfigElement, "localPort");
            this.parseProperty(builder, oauthHttpCallbackConfigElement, "remotePort");
            this.parseProperty(builder, oauthHttpCallbackConfigElement, "async");
            this.parseProperty(builder, oauthHttpCallbackConfigElement, "path");
            this.parseProperty(builder, oauthHttpCallbackConfigElement, "defaultAccessTokenId");
            if (this.hasAttribute(oauthHttpCallbackConfigElement, "connector-ref")) {
                builder.addPropertyValue("connector", (Object)new RuntimeBeanReference(oauthHttpCallbackConfigElement.getAttribute("connector-ref")));
            }
        }
        if ((oauthStoreConfigElement = DomUtils.getChildElementByTagName((Element)element, (String)"oauth-store-config")) != null) {
            this.parsePropertyRef(builder, oauthStoreConfigElement, "objectStore-ref", "accessTokenObjectStore");
        }
        this.parseProperty(builder, element, "consumerKey", "consumerKey");
        this.parseProperty(builder, element, "consumerSecret", "consumerSecret");
        this.parseProperty(builder, element, "apiVersion", "apiVersion");
        this.parseProperty(builder, element, "clientId", "clientId");
        this.parseProperty(builder, element, "assignmentRuleId", "assignmentRuleId");
        this.parseProperty(builder, element, "useDefaultRule", "useDefaultRule");
        this.parseProperty(builder, element, "allowFieldTruncationSupport", "allowFieldTruncationSupport");
        this.parseProperty(builder, element, "fetchAllApexSoapMetadata", "fetchAllApexSoapMetadata");
        this.parseProperty(builder, element, "fetchAllApexRestMetadata", "fetchAllApexRestMetadata");
        this.parseListAndSetProperty(element, builder, "apexClassNames", "apex-class-names", "apex-class-name", (AbstractDevkitBasedDefinitionParser.ParseDelegate)new AbstractDevkitBasedDefinitionParser.ParseDelegate<String>(){

            public String parse(Element element) {
                return element.getTextContent();
            }
        });
        this.parseProperty(builder, element, "readTimeout", "readTimeout");
        this.parseProperty(builder, element, "connectionTimeout", "connectionTimeout");
        this.parseProperty(builder, element, "proxyHost", "proxyHost");
        this.parseProperty(builder, element, "proxyPort", "proxyPort");
        this.parseProperty(builder, element, "proxyUsername", "proxyUsername");
        this.parseProperty(builder, element, "proxyPassword", "proxyPassword");
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition((BeanDefinition)definition);
        return definition;
    }

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition((String)SalesforceConnectorOAuthManager.class.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            }
            catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error("Cannot launch the mule app, the configuration [config-with-oauth] within the connector [sfdc] is not supported in mule " + muleVersion);
            throw new BeanDefinitionParsingException(new Problem("Cannot launch the mule app, the configuration [config-with-oauth] within the connector [sfdc] is not supported in mule " + muleVersion, new Location(parserContext.getReaderContext().getResource()), null, (Throwable)noClassDefFoundError));
        }
    }
}

