/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.config;

import com.sforce.soap.partner.Connector;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.fault.ApiFault;
import com.sforce.soap.partner.fault.LoginFault;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import java.net.UnknownHostException;
import javax.security.auth.login.CredentialExpiredException;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mule.api.ConnectionExceptionCode;
import org.mule.modules.salesforce.config.AbstractConfig;
import org.mule.modules.salesforce.config.CustomPartnerConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforceBasicAuthConfig
extends AbstractConfig {
    private static final Logger logger = LoggerFactory.getLogger(SalesforceBasicAuthConfig.class);
    private String url;
    private String serviceEndpoint;
    private String sessionId;
    private boolean disableSessionInvalidation;

    public boolean isConnected() {
        CustomPartnerConnection customPartnerConnection = this.getCustomPartnerConnection();
        return customPartnerConnection != null && customPartnerConnection.getConfig() != null && customPartnerConnection.getConfig().getSessionId() != null;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public void setServiceEndpoint(String serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
    }

    @Override
    @Nullable
    public String getSessionId() {
        String result = null;
        if (this.sessionId != null) {
            result = this.sessionId;
        }
        if (this.sessionId == null && this.getCustomPartnerConnection() != null && this.getCustomPartnerConnection().getConfig() != null) {
            result = this.getCustomPartnerConnection().getConfig().getSessionId();
        }
        return result;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Override
    public void destroySession() {
        super.destroySession();
    }

    @Override
    protected boolean isDisableSessionInvalidationActive() {
        return this.getDisableSessionInvalidation();
    }

    public void connect(String username, String password, String securityToken) throws org.mule.api.ConnectionException {
        this.verifyApiVersion();
        ConnectorConfig config = this.buildConfig(this.url, username, password + StringUtils.defaultString((String)securityToken));
        CustomPartnerConnection customPartnerConnection = new CustomPartnerConnection();
        try {
            PartnerConnection partnerConnection = this.establishConnection(config);
            customPartnerConnection.setConnection(partnerConnection);
            this.setCustomPartnerConnection(customPartnerConnection);
        }
        catch (Exception e) {
            throw new org.mule.api.ConnectionException(this.getExceptionCode(e.getCause()), null, e.getMessage(), (Throwable)e);
        }
    }

    public PartnerConnection establishConnection(@NotNull ConnectorConfig connectorConfig) throws org.mule.api.ConnectionException {
        logger.debug("Creating a Salesforce session using " + connectorConfig.getUsername());
        try {
            PartnerConnection partnerConnection = Connector.newConnection((ConnectorConfig)connectorConfig);
            logger.debug("Session established successfully at instance " + connectorConfig.getServiceEndpoint());
            return partnerConnection;
        }
        catch (ApiFault e) {
            throw new org.mule.api.ConnectionException(this.getExceptionCode(e), e.getExceptionCode().name(), e.getExceptionMessage(), (Throwable)e);
        }
        catch (ConnectionException e) {
            throw new org.mule.api.ConnectionException(this.getExceptionCode(e.getCause()), null, e.getMessage(), (Throwable)e);
        }
    }

    @NotNull
    public ConnectionExceptionCode getExceptionCode(@NotNull Throwable exc) {
        ConnectionExceptionCode result = ConnectionExceptionCode.UNKNOWN;
        if (exc instanceof UnknownHostException) {
            result = ConnectionExceptionCode.UNKNOWN_HOST;
        }
        if (exc instanceof LoginFault) {
            result = ConnectionExceptionCode.INCORRECT_CREDENTIALS;
        }
        if (exc instanceof CredentialExpiredException) {
            result = ConnectionExceptionCode.CREDENTIALS_EXPIRED;
        }
        return result;
    }

    @NotNull
    private ConnectorConfig buildConfig(@NotNull String endpoint, @NotNull String username, String password) throws org.mule.api.ConnectionException {
        ConnectorConfig result = new ConnectorConfig();
        result.setUsername(username);
        result.setPassword(password);
        result.setAuthEndpoint(endpoint);
        result.setServiceEndpoint(endpoint);
        if (this.getServiceEndpoint() != null) {
            result.setServiceEndpoint(this.getServiceEndpoint());
        }
        result.setSessionId(this.getSessionId());
        this.initConnectionConfig(result);
        return result;
    }

    public Double computeApiVersion(@NotNull String url) {
        Double apiVersion;
        String apiVersionAsString = url.substring(url.lastIndexOf("/") + 1);
        try {
            apiVersion = Double.parseDouble(apiVersionAsString);
        }
        catch (Exception e) {
            logger.warn("Unable to compute API version. Falling into default version: {}", (Object)32.0, (Object)e);
            apiVersion = 32.0;
        }
        return apiVersion;
    }

    @Override
    public Double getApiVersion() {
        if (this.getServiceEndpoint() != null) {
            return this.computeApiVersion(this.getServiceEndpoint());
        }
        return this.computeApiVersion(this.getUrl());
    }

    public boolean getDisableSessionInvalidation() {
        return this.disableSessionInvalidation;
    }

    public void setDisableSessionInvalidation(boolean disableSessionInvalidation) {
        this.disableSessionInvalidation = disableSessionInvalidation;
    }
}

