/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.config;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.sforce.soap.partner.Connector;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.ws.ConnectorConfig;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.apache.commons.httpclient.NameValuePair;
import org.jetbrains.annotations.Nullable;
import org.mule.api.ConnectionException;
import org.mule.modules.salesforce.HttpClientService;
import org.mule.modules.salesforce.config.AbstractOAuthConfig;
import org.mule.modules.salesforce.config.CustomPartnerConnection;
import org.mule.modules.salesforce.config.OAuthTokenGeneratorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractOAuthTokenBearerConfig
extends AbstractOAuthConfig {
    private static final Logger logger = LoggerFactory.getLogger(AbstractOAuthTokenBearerConfig.class);
    private static final String ACCESS_TOKEN_PROPERTY = "access_token";
    private static final String INSTANCE_URL_PROPERTY = "instance_url";
    private static final String JWT_GRANT_TYPE = "urn:ietf:params:oauth:grant-type:jwt-bearer";
    private static final String SAML_GRANT_TYPE = "urn:ietf:params:oauth:grant-type:saml2-bearer";
    private String principal;
    private String tokenEndpoint;
    private boolean disableSessionInvalidation;

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    protected void establishConnection(String grantType, String consumerKey, String tokenEndpoint, String keyStore, String storePassword) throws ConnectionException {
        InputStream keyStoreStream = null;
        try {
            keyStoreStream = this.getKeyStoreResourceStream(keyStore);
            OAuthTokenGeneratorService oAuthTokenGeneratorService = new OAuthTokenGeneratorService();
            String token = null;
            String tokenEndpointBaseUrl = this.computeBaseUrl(tokenEndpoint);
            if (JWT_GRANT_TYPE.equals(grantType)) {
                token = oAuthTokenGeneratorService.generateJWTToken(consumerKey, this.getPrincipal(), tokenEndpointBaseUrl, keyStoreStream, storePassword.toCharArray());
            } else if (SAML_GRANT_TYPE.equals(grantType)) {
                token = oAuthTokenGeneratorService.generateSAMLToken(consumerKey, this.getPrincipal(), tokenEndpointBaseUrl, tokenEndpoint, keyStoreStream, storePassword.toCharArray());
            }
            this.sendAuthorizationRequestAndParseResponse(tokenEndpoint, grantType, token);
            this.postAuthorization();
        }
        catch (Exception e) {
            logger.error("Failed establishing connection with salesforce", (Throwable)e);
            throw new ConnectionException(null, null, "Failed establishing connection with salesforce", (Throwable)e);
        }
        finally {
            if (keyStoreStream != null) {
                try {
                    keyStoreStream.close();
                }
                catch (IOException e) {
                    logger.error("Failed closing key store stream", (Throwable)e);
                }
            }
        }
    }

    protected void sendAuthorizationRequestAndParseResponse(String tokenEndpoint, String grantType, String jwtToken) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("charset", "UTF-8");
        headers.put("Accept-Encoding", "gzip, deflate, sdch");
        NameValuePair[] nameValuePairs = new NameValuePair[]{new NameValuePair("grant_type", grantType), new NameValuePair("assertion", jwtToken)};
        Integer proxyPort = this.getProxyPort() != null ? Integer.valueOf(this.getProxyPort()) : null;
        HttpClientService httpClientService = new HttpClientService(this.getProxyHost(), proxyPort, this.getProxyUsername(), this.getProxyPassword(), this.getConnectionTimeout(), this.getReadTimeout());
        InputStream responseStream = httpClientService.sendPost(tokenEndpoint, nameValuePairs, headers, null);
        InputStreamReader inputStreamReader = new InputStreamReader(responseStream, Charset.forName("UTF-8"));
        this.processAuthorizationResponse(inputStreamReader);
    }

    private void processAuthorizationResponse(InputStreamReader responseReader) {
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = jsonParser.parse((Reader)responseReader).getAsJsonObject();
        this.setOAuth2AccessToken(jsonObject.get(ACCESS_TOKEN_PROPERTY).getAsString());
        this.setOAuth2instanceId(jsonObject.get(INSTANCE_URL_PROPERTY).getAsString());
    }

    protected InputStream getKeyStoreResourceStream(String keyStoreName) throws FileNotFoundException {
        InputStream keyStoreStream = this.getMuleContext().getExecutionClassLoader().getResourceAsStream(keyStoreName);
        if (keyStoreStream == null) {
            throw new FileNotFoundException(keyStoreName);
        }
        return keyStoreStream;
    }

    protected void postAuthorization() throws Exception {
        this.verifyApiVersion();
        ConnectorConfig config = new ConnectorConfig();
        this.initConnectionConfig(config);
        String serviceEndpoint = "https://" + new URI(this.getOAuth2instanceId()).getHost() + "/services/Soap/u/" + this.getApiVersion();
        config.setServiceEndpoint(serviceEndpoint);
        PartnerConnection salesforcePartnerConnection = Connector.newConnection((ConnectorConfig)config);
        CustomPartnerConnection customPartnerConnection = new CustomPartnerConnection();
        customPartnerConnection.setConnection(salesforcePartnerConnection);
        this.setCustomPartnerConnection(customPartnerConnection);
    }

    public boolean isConnected() {
        return this.getSessionId() != null;
    }

    @Override
    public void destroySession() {
        super.destroySession();
    }

    @Override
    protected boolean isDisableSessionInvalidationActive() {
        return this.getDisableSessionInvalidation();
    }

    @Override
    @Nullable
    public String getSessionId() {
        return this.getOAuth2AccessToken();
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public boolean getDisableSessionInvalidation() {
        return this.disableSessionInvalidation;
    }

    public void setDisableSessionInvalidation(boolean disableSessionInvalidation) {
        this.disableSessionInvalidation = disableSessionInvalidation;
    }
}

