/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.sforce.async.BulkConnection;
import com.sforce.soap.metadata.MetadataConnection;
import com.sforce.soap.partner.AssignmentRuleHeader_element;
import com.sforce.soap.partner.CallOptions_element;
import com.sforce.soap.partner.GetUserInfoResult;
import com.sforce.soap.partner.StatusCode;
import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.MessageHandler;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.MuleContext;
import org.mule.api.callback.SourceCallback;
import org.mule.api.context.MuleContextAware;
import org.mule.modules.salesforce.Config;
import org.mule.modules.salesforce.ExceptionDecorator;
import org.mule.modules.salesforce.HttpClientService;
import org.mule.modules.salesforce.ProxyAuthenticator;
import org.mule.modules.salesforce.SalesforceBayeuxClient;
import org.mule.modules.salesforce.SalesforceBayeuxMessageListener;
import org.mule.modules.salesforce.apex.ApexClient;
import org.mule.modules.salesforce.config.CustomMetadataConnection;
import org.mule.modules.salesforce.config.CustomPartnerConnection;
import org.mule.modules.salesforce.config.Subscription;
import org.mule.modules.salesforce.exception.SalesforceException;

abstract class AbstractConfig
implements MuleContextAware,
Config {
    private static final Logger logger = Logger.getLogger(AbstractConfig.class);
    protected static final double RECOMMENDED_API_VERSION = 32.0;
    private static final double MIN_SUPPORTED_API_VERSION = 31.0;
    private static final String IDENTITY_URL_TEMPLATE = "%s/id/%s/%s";
    private static final String VERSION_PLACEHOLDER = "{version}";
    private static final String URLS_FIELD = "urls";
    private static final String PARTNER_URL_FIELD = "partner";
    private static final String METADATA_URL_FIELD = "metadata";
    private static final Lock BAYEUX_CLIENT_CREATION_LOCK = new ReentrantLock();
    protected static final String UTF_8 = "UTF-8";
    private static final Lock BAYEUX_CLIENT_DESTRUCTION_LOCK = new ReentrantLock();
    private static final Lock URLS_CREATION_LOCK = new ReentrantLock();
    private String clientId;
    private String assignmentRuleId;
    private Boolean useDefaultRule;
    private Boolean allowFieldTruncationSupport;
    private boolean fetchAllApexSoapMetadata;
    private boolean fetchAllApexRestMetadata;
    private List<String> apexClassNames;
    private Integer readTimeout;
    private Integer connectionTimeout;
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private volatile Map<String, String> urls;
    private MuleContext muleContext;
    private final List<Subscription> subscriptions = new ArrayList<Subscription>();
    private CustomPartnerConnection customPartnerConnection;
    private SalesforceBayeuxClient bayeuxClient;

    AbstractConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Map<String, String> getUrls() throws SalesforceException {
        if (this.urls == null) {
            try {
                URLS_CREATION_LOCK.lock();
                if (this.urls == null) {
                    this.urls = this.retrieveIdentityURLs();
                }
            }
            finally {
                URLS_CREATION_LOCK.unlock();
            }
        }
        if (this.urls == null) {
            throw new SalesforceException(StatusCode.UNKNOWN_EXCEPTION, "Unable to retrieve Identity URLs.");
        }
        return this.urls;
    }

    @Override
    @Nullable
    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    @Override
    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    @Override
    @Nullable
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    @Override
    @Nullable
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Override
    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    @Nullable
    public CustomPartnerConnection getCustomPartnerConnection() {
        return this.customPartnerConnection;
    }

    public void setCustomPartnerConnection(@NotNull CustomPartnerConnection customPartnerConnection) throws Exception {
        this.customPartnerConnection = customPartnerConnection;
        this.setConnectionOptions(this.customPartnerConnection);
        this.processSubscriptions();
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public String getAssignmentRuleId() {
        return this.assignmentRuleId;
    }

    @Override
    public void setAssignmentRuleId(String assignmentRuleId) {
        this.assignmentRuleId = assignmentRuleId;
    }

    @Override
    public Boolean getUseDefaultRule() {
        return this.useDefaultRule;
    }

    @Override
    public void setUseDefaultRule(Boolean useDefaultRule) {
        this.useDefaultRule = useDefaultRule;
    }

    @Override
    public Boolean getAllowFieldTruncationSupport() {
        return this.allowFieldTruncationSupport;
    }

    @Override
    public void setAllowFieldTruncationSupport(Boolean allowFieldTruncationSupport) {
        this.allowFieldTruncationSupport = allowFieldTruncationSupport;
    }

    @Override
    @NotNull
    public List<Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    @Override
    @NotNull
    public List<String> getApexClassNames() {
        List<String> result = this.apexClassNames;
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public void setApexClassNames(@NotNull List<String> apexClassNames) {
        this.apexClassNames = apexClassNames;
    }

    @Override
    public boolean getFetchAllApexSoapMetadata() {
        return this.fetchAllApexSoapMetadata;
    }

    @Override
    public void setFetchAllApexSoapMetadata(boolean fetchAllApexMetadata) {
        this.fetchAllApexSoapMetadata = fetchAllApexMetadata;
    }

    @Override
    public boolean isReadyToSubscribe() {
        return this.getSessionId() != null;
    }

    @Override
    @Nullable
    public abstract String getSessionId();

    protected void verifyApiVersion() throws ConnectionException {
        if (this.getApiVersion() < 31.0) {
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, "Incorrect API version", "Unsupported API version " + this.getApiVersion() + " Recommended version is " + 32.0);
        }
        if (this.getApiVersion() < 32.0) {
            logger.warn((Object)("API version " + this.getApiVersion() + " is lower than the recommended " + 32.0 + " version"));
        } else if (this.getApiVersion() > 32.0) {
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, "Incorrect API version", "Unsupported API version " + this.getApiVersion() + " Recommended version is " + 32.0);
        }
    }

    @Override
    public boolean getFetchAllApexRestMetadata() {
        return this.fetchAllApexRestMetadata;
    }

    @Override
    public void setFetchAllApexRestMetadata(boolean fetchAllApexRestMetadata) {
        this.fetchAllApexRestMetadata = fetchAllApexRestMetadata;
    }

    private Map<String, String> retrieveIdentityURLs() throws SalesforceException {
        HashMap urls = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("charset", UTF_8);
        headers.put("Accept-Encoding", "gzip, deflate, sdch");
        headers.put("Authorization", "Bearer " + this.getSessionId());
        NameValuePair[] nameValuePairs = new NameValuePair[]{new NameValuePair("format", "json")};
        try {
            if (this.customPartnerConnection != null) {
                GetUserInfoResult getUserInfoResult = this.customPartnerConnection.getUserInfo();
                Integer proxyPort = this.getProxyPort() != null ? Integer.valueOf(this.getProxyPort()) : null;
                JsonParser jsonParser = new JsonParser();
                HttpClientService httpClientService = new HttpClientService(this.getProxyHost(), proxyPort, this.getProxyUsername(), this.getProxyPassword(), this.getConnectionTimeout(), this.getReadTimeout());
                InputStream responseStream = httpClientService.sendPost(String.format(IDENTITY_URL_TEMPLATE, this.computeBaseUrl(this.customPartnerConnection.getConfig().getServiceEndpoint()), getUserInfoResult.getOrganizationId(), getUserInfoResult.getUserId()), nameValuePairs, headers, null);
                InputStreamReader inputStreamReader = new InputStreamReader(responseStream, Charset.forName(UTF_8));
                JsonObject jsonObject = jsonParser.parse((Reader)inputStreamReader).getAsJsonObject();
                JsonElement jsonUrls = jsonObject.get(URLS_FIELD);
                if (jsonUrls != null && jsonUrls.isJsonObject()) {
                    urls = new HashMap();
                    for (Map.Entry entry : jsonUrls.getAsJsonObject().entrySet()) {
                        if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                        urls.put(entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SalesforceException(StatusCode.UNKNOWN_EXCEPTION, "Unable to retrieve identity urls", e);
        }
        return urls;
    }

    protected String computeBaseUrl(String url) throws SalesforceException {
        String baseUrl = null;
        try {
            String path = new URL(url).getPath();
            baseUrl = url.substring(0, url.indexOf(path));
        }
        catch (MalformedURLException e) {
            logger.error((Object)("Invalid service endpoint: " + url), (Throwable)e);
            throw new SalesforceException(StatusCode.UNKNOWN_EXCEPTION, "Please try again. If the problem persists please contact support team");
        }
        return baseUrl;
    }

    @Override
    @NotNull
    public BulkConnection getBulkConnection() throws SalesforceException {
        this.validateCustomPartnerConnection();
        try {
            Map<String, String> urls = this.getUrls();
            URI partnerUri = new URI(urls.get(PARTNER_URL_FIELD).replace(VERSION_PLACEHOLDER, this.getApiVersion().toString()));
            String restEndpoint = "https://" + partnerUri.getHost() + "/services/async/" + this.getApiVersion();
            this.customPartnerConnection.getConfig().setRestEndpoint(restEndpoint);
            return new BulkConnection(this.customPartnerConnection.getConfig());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SalesforceException(StatusCode.UNKNOWN_EXCEPTION, "Unable to configure connection with Bulk API", e);
        }
    }

    protected void validateCustomPartnerConnection() throws SalesforceException {
        if (this.customPartnerConnection == null) {
            throw new SalesforceException(StatusCode.UNKNOWN_EXCEPTION, "Connection not yet initialized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public SalesforceBayeuxClient getBayeuxClient() throws SalesforceException {
        if (this.bayeuxClient == null) {
            try {
                BAYEUX_CLIENT_CREATION_LOCK.lock();
                if (this.bayeuxClient == null) {
                    this.validateCustomPartnerConnection();
                    this.bayeuxClient = this.getNewInstanceOfSalesforceBayeuxClient();
                }
            }
            finally {
                BAYEUX_CLIENT_CREATION_LOCK.unlock();
            }
        }
        return this.bayeuxClient;
    }

    protected SalesforceBayeuxClient getNewInstanceOfSalesforceBayeuxClient() throws SalesforceException {
        try {
            String serviceURL = "https://" + new URL(this.customPartnerConnection.getConfig().getServiceEndpoint()).getHost() + "/cometd/" + this.getApiVersion();
            this.bayeuxClient = new SalesforceBayeuxClient(this, serviceURL);
            if (!this.bayeuxClient.isHandshook()) {
                this.bayeuxClient.handshake();
            }
            return this.bayeuxClient;
        }
        catch (MalformedURLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SalesforceException(StatusCode.UNKNOWN_EXCEPTION, "Unable to configure connection for Subscription Processor API", e);
        }
    }

    @Override
    @NotNull
    public final ApexClient getApexClient() throws SalesforceException {
        try {
            Map<String, String> urls = this.getUrls();
            URI partnerUri = new URI(urls.get(PARTNER_URL_FIELD).replace(VERSION_PLACEHOLDER, this.getApiVersion().toString()));
            String basePath = partnerUri.getHost();
            Integer proxyPort = this.getProxyPort() != null ? Integer.valueOf(this.getProxyPort()) : null;
            ApexClient apexClient = new ApexClient(this.getProxyHost(), proxyPort, this.getProxyUsername(), this.getProxyPassword(), this.getConnectionTimeout(), this.getReadTimeout(), basePath);
            apexClient.setSessionId(this.getSessionId());
            return apexClient;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SalesforceException(StatusCode.UNKNOWN_EXCEPTION, "Unable to configure connection with Apex API", e);
        }
    }

    @Override
    @NotNull
    public final CustomMetadataConnection getMetadataConnection() throws com.sforce.ws.ConnectionException {
        if (this.customPartnerConnection == null) {
            throw new com.sforce.ws.ConnectionException("Connection not yet initialized");
        }
        ConnectorConfig connectorConfig = null;
        try {
            connectorConfig = this.buildMetadataConnectorConfig(this.customPartnerConnection.getConfig());
        }
        catch (SalesforceException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new com.sforce.ws.ConnectionException(e.getMessage());
        }
        MetadataConnection metadataConnection = new MetadataConnection(connectorConfig);
        CustomMetadataConnection customMetadataConnection = new CustomMetadataConnection();
        customMetadataConnection.setConnection(metadataConnection);
        this.setConnectionOptions(customMetadataConnection);
        return customMetadataConnection;
    }

    private void setConnectionOptions(CustomMetadataConnection customMetadataConnection) {
        if (this.getClientId() != null) {
            com.sforce.soap.metadata.CallOptions_element callOptions = new com.sforce.soap.metadata.CallOptions_element();
            callOptions.setClient(this.getClientId());
            customMetadataConnection.__setCallOptions(callOptions);
        }
    }

    private ConnectorConfig buildMetadataConnectorConfig(ConnectorConfig config) throws SalesforceException {
        String metadata = this.getUrls().get(METADATA_URL_FIELD).replace(VERSION_PLACEHOLDER, this.getApiVersion().toString());
        ConnectorConfig result = new ConnectorConfig();
        result.setUsername(config.getUsername());
        result.setPassword(config.getPassword());
        result.setAuthEndpoint(config.getAuthEndpoint());
        result.setSessionId(this.getSessionId());
        result.setServiceEndpoint(metadata);
        this.initConnectionConfig(result);
        return result;
    }

    protected void destroySession() {
        try {
            this.disconnectBayeuxClientIfExists();
            if (this.shouldICallLogOutOnPartnerConnection()) {
                logger.debug((Object)"Sending logout request to invalidate session.");
                this.logoutPartnerConnection();
            }
        }
        catch (SalesforceException e) {
            logger.error((Object)"Failed destroying partner connection", (Throwable)e);
        }
    }

    public void logoutPartnerConnection() throws SalesforceException {
        this.checkThatUserIsLoggedIn();
        this.sendLogoutRequestToSalesforce();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectBayeuxClientIfExists() {
        if (this.bayeuxClient != null) {
            try {
                BAYEUX_CLIENT_DESTRUCTION_LOCK.lock();
                if (this.bayeuxClient != null) {
                    this.bayeuxClient.disconnect();
                }
            }
            finally {
                BAYEUX_CLIENT_DESTRUCTION_LOCK.unlock();
                this.bayeuxClient = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLogoutRequestToSalesforce() throws SalesforceException {
        block6: {
            try {
                this.customPartnerConnection.logout();
            }
            catch (com.sforce.ws.ConnectionException ce) {
                if (ExceptionDecorator.hasSessionExpired(ce)) {
                    logger.debug((Object)"The current session id is invalid. Not further action required during logout.");
                    logger.debug((Object)ce);
                    break block6;
                }
                throw ExceptionDecorator.decorateException((Exception)((Object)ce));
            }
            finally {
                this.customPartnerConnection = null;
            }
        }
    }

    private void checkThatUserIsLoggedIn() throws SalesforceException {
        if (this.customPartnerConnection == null) {
            throw new SalesforceException(StatusCode.UNKNOWN_EXCEPTION, "Already logged out.");
        }
    }

    private boolean shouldICallLogOutOnPartnerConnection() {
        return this.customPartnerConnection != null && !this.isDisableSessionInvalidationActive();
    }

    protected abstract boolean isDisableSessionInvalidationActive();

    protected void initConnectionConfig(@NotNull ConnectorConfig connectorConfig) {
        String sessionId = this.getSessionId();
        connectorConfig.setSessionId(sessionId);
        connectorConfig.setManualLogin(false);
        connectorConfig.setCompression(false);
        Integer connectionTimeout = this.getConnectionTimeout();
        connectorConfig.setConnectionTimeout(connectionTimeout.intValue());
        Integer readTimeout = this.getReadTimeout();
        connectorConfig.setReadTimeout(readTimeout.intValue());
        if (logger.isDebugEnabled()) {
            connectorConfig.addMessageHandler(new MessageHandler(){

                public void handleRequest(URL endpoint, byte[] request) {
                    logger.debug((Object)("Sending request to " + endpoint.toString()));
                    logger.debug((Object)new String(request, Charset.forName(AbstractConfig.UTF_8)));
                }

                public void handleResponse(URL endpoint, byte[] response) {
                    logger.debug((Object)("Receiving response from " + endpoint.toString()));
                    logger.debug((Object)new String(response, Charset.forName(AbstractConfig.UTF_8)));
                }
            });
        }
        if (this.proxyHost != null) {
            if (this.proxyUsername != null && this.proxyPassword != null) {
                ProxyAuthenticator proxyAuthenticator = new ProxyAuthenticator(this.proxyUsername, this.proxyPassword);
                Authenticator.setDefault(proxyAuthenticator);
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, (int)Integer.valueOf(this.proxyPort)));
                connectorConfig.setProxy(proxy);
            } else {
                connectorConfig.setProxy(this.proxyHost, Integer.valueOf(this.proxyPort).intValue());
            }
        }
    }

    @Override
    public void setConnectionOptions(CustomPartnerConnection connection) {
        if (this.getClientId() != null) {
            CallOptions_element callOptions = new CallOptions_element();
            callOptions.setClient(this.getClientId());
            connection.__setCallOptions(callOptions);
        }
        if (this.getAssignmentRuleId() != null || this.getUseDefaultRule() != null) {
            AssignmentRuleHeader_element assignmentRule = new AssignmentRuleHeader_element();
            if (this.getAssignmentRuleId() != null) {
                assignmentRule.setAssignmentRuleId(this.getAssignmentRuleId());
            }
            if (this.getUseDefaultRule() != null) {
                assignmentRule.setUseDefaultRule(this.getUseDefaultRule());
            }
            connection.__setAssignmentRuleHeader(assignmentRule);
        }
        if (this.getAllowFieldTruncationSupport() != null && this.getAllowFieldTruncationSupport().booleanValue()) {
            connection.setAllowFieldTruncationHeader(this.getAllowFieldTruncationSupport());
        }
    }

    public void processSubscriptions() throws Exception {
        for (Subscription p : this.subscriptions) {
            if (p.isSubscribed()) continue;
            this.subscribe(p.getTopic(), p.getCallback());
        }
    }

    @Override
    public void subscribe(@NotNull String topicName, @NotNull SourceCallback callback) throws Exception {
        SalesforceBayeuxMessageListener listener = new SalesforceBayeuxMessageListener(callback);
        this.getBayeuxClient().subscribe(topicName, listener);
    }
}

