/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.category;

import com.sforce.soap.partner.DescribeGlobalResult;
import com.sforce.soap.partner.DescribeGlobalSObjectResult;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.Field;
import com.sforce.soap.partner.FieldType;
import com.sforce.soap.partner.PicklistEntry;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.builder.DefaultMetaDataBuilder;
import org.mule.common.metadata.builder.DynamicObjectBuilder;
import org.mule.common.metadata.builder.EnumMetaDataBuilder;
import org.mule.common.metadata.datatype.DataType;
import org.mule.modules.salesforce.SalesforceConnector;

public class SalesforceMetadataCategory {
    @Inject
    private SalesforceConnector connector;

    public List<MetaDataKey> getMetaDataKeys() throws Exception {
        ArrayList<MetaDataKey> keys = new ArrayList<MetaDataKey>();
        DescribeGlobalResult describeGlobal = this.connector.describeGlobal();
        if (describeGlobal != null) {
            DescribeGlobalSObjectResult[] sobjects;
            for (DescribeGlobalSObjectResult sobject : sobjects = describeGlobal.getSobjects()) {
                String key = sobject.getName();
                String displayName = sobject.getLabel() + " (" + key + ")";
                DefaultMetaDataKey dataKey = new DefaultMetaDataKey(key, displayName);
                keys.add((MetaDataKey)dataKey);
            }
        }
        return keys;
    }

    public MetaData getMetaData(@NotNull MetaDataKey key) throws Exception {
        DescribeSObjectResult describeSObject = this.connector.describeSObject(key.getId());
        DefaultMetaData metaData = null;
        if (describeSObject != null) {
            Field[] fields = describeSObject.getFields();
            DynamicObjectBuilder dynamicObject = new DefaultMetaDataBuilder().createDynamicObject(key.getId());
            for (Field f : fields) {
                this.addField(f, dynamicObject);
            }
            MetaDataModel model = dynamicObject.build();
            metaData = new DefaultMetaData(model);
        }
        return metaData;
    }

    protected void addField(@NotNull Field field, @NotNull DynamicObjectBuilder dynamicObject) {
        DataType dataType = this.getDataType(field.getType());
        switch (dataType) {
            case POJO: {
                dynamicObject.addPojoField(field.getName(), Object.class);
                break;
            }
            case ENUM: {
                EnumMetaDataBuilder enumMetaDataBuilder = dynamicObject.addEnumField(field.getName());
                if (field.getPicklistValues().length == 0) break;
                String[] values = new String[field.getPicklistValues().length];
                int i = 0;
                for (PicklistEntry picklistEntry : field.getPicklistValues()) {
                    values[i] = picklistEntry.getValue();
                    ++i;
                }
                enumMetaDataBuilder.setValues(values).isWhereCapable(field.isFilterable()).isOrderByCapable(field.isSortable());
                break;
            }
            default: {
                dynamicObject.addSimpleField(field.getName(), dataType).isWhereCapable(field.isFilterable()).isOrderByCapable(field.isSortable());
            }
        }
    }

    protected DataType getDataType(FieldType fieldType) {
        DataType dt;
        switch (fieldType) {
            case _boolean: {
                dt = DataType.BOOLEAN;
                break;
            }
            case _double: {
                dt = DataType.DOUBLE;
                break;
            }
            case _int: {
                dt = DataType.INTEGER;
                break;
            }
            case anyType: {
                dt = DataType.POJO;
                break;
            }
            case base64: {
                dt = DataType.STRING;
                break;
            }
            case combobox: {
                dt = DataType.ENUM;
                break;
            }
            case currency: {
                dt = DataType.STRING;
                break;
            }
            case datacategorygroupreference: {
                dt = DataType.STRING;
                break;
            }
            case date: {
                dt = DataType.DATE_TIME;
                break;
            }
            case datetime: {
                dt = DataType.DATE_TIME;
                break;
            }
            case email: {
                dt = DataType.STRING;
                break;
            }
            case encryptedstring: {
                dt = DataType.STRING;
                break;
            }
            case id: {
                dt = DataType.STRING;
                break;
            }
            case multipicklist: {
                dt = DataType.ENUM;
                break;
            }
            case percent: {
                dt = DataType.STRING;
                break;
            }
            case phone: {
                dt = DataType.STRING;
                break;
            }
            case picklist: {
                dt = DataType.ENUM;
                break;
            }
            case reference: {
                dt = DataType.STRING;
                break;
            }
            case string: {
                dt = DataType.STRING;
                break;
            }
            case textarea: {
                dt = DataType.STRING;
                break;
            }
            case time: {
                dt = DataType.DATE_TIME;
                break;
            }
            case url: {
                dt = DataType.STRING;
                break;
            }
            default: {
                dt = DataType.STRING;
            }
        }
        return dt;
    }

    public SalesforceConnector getConnector() {
        return this.connector;
    }

    public void setConnector(@NotNull SalesforceConnector connector) {
        this.connector = connector;
    }
}

