/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.category;

import com.sforce.soap.metadata.FileProperties;
import com.sforce.soap.partner.StatusCode;
import com.sforce.ws.ConnectionException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.wsdl.WSDLException;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.modules.salesforce.Config;
import org.mule.modules.salesforce.MetadataType;
import org.mule.modules.salesforce.SalesforceConnector;
import org.mule.modules.salesforce.SalesforceUtils;
import org.mule.modules.salesforce.apex.util.ApexWSDLDownloaderService;
import org.mule.modules.salesforce.config.CustomPartnerConnection;
import org.mule.modules.salesforce.exception.SalesforceException;
import org.mule.modules.wsdl.WSDLMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApexSoapMetadataCategory {
    private static final String WSDL_TEMP_DIR = "salesforce/apex/wsdl";
    private static final Logger logger = LoggerFactory.getLogger(ApexSoapMetadataCategory.class);
    @Inject
    private SalesforceConnector salesforceConnector;
    private WSDLMetadata wsdlMetadata;

    private void loadWsdlMetaData() throws SalesforceException {
        List<URL> urls = this.downloadAndSaveWSDLs();
        try {
            this.wsdlMetadata = new WSDLMetadata(urls, this.getClass().getSimpleName());
        }
        catch (URISyntaxException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SalesforceException(StatusCode.UNKNOWN_EXCEPTION, e.getMessage());
        }
        catch (WSDLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SalesforceException(StatusCode.UNKNOWN_EXCEPTION, e.getMessage());
        }
    }

    private void cleanTempDir(String tempDir) {
        if (tempDir != null) {
            try {
                FileUtils.cleanDirectory((File)new File(tempDir));
            }
            catch (IOException e) {
                logger.error("Unable to clean temporary directory", (Throwable)e);
            }
        }
    }

    @NotNull
    private List<URL> downloadAndSaveWSDLs() throws SalesforceException {
        List<URL> urls = Collections.emptyList();
        try {
            URI tempDirURI = SalesforceUtils.createTempDir(WSDL_TEMP_DIR);
            String absolutePath = new File(tempDirURI).getAbsolutePath();
            this.cleanTempDir(absolutePath);
            List<String> wsdlClassNames = this.getApexClassNames();
            urls = this.downloadWsdlFiles(wsdlClassNames, tempDirURI);
        }
        catch (IOException e) {
            logger.error("Unable to create temp dir", (Throwable)e);
        }
        return urls;
    }

    @NotNull
    private List<URL> downloadWsdlFiles(@NotNull List<String> wsdlClassNames, @NotNull URI tempDirURI) throws SalesforceException {
        ArrayList<URL> urls = new ArrayList<URL>();
        File tempDirFile = new File(tempDirURI);
        String tempDirAbsolutePath = tempDirFile.getAbsolutePath();
        String sessionId = this.salesforceConnector.getConfig().getSessionId();
        CustomPartnerConnection customPartnerConnection = this.salesforceConnector.getConfig().getCustomPartnerConnection();
        if (customPartnerConnection == null) {
            throw new SalesforceException(StatusCode.UNKNOWN_EXCEPTION, "Connection not yet initialized");
        }
        String serviceEndpoint = customPartnerConnection.getConfig().getServiceEndpoint();
        try {
            serviceEndpoint = serviceEndpoint.replace(new URL(serviceEndpoint).getPath(), "");
        }
        catch (MalformedURLException e) {
            logger.error("Unable to compute service endpoint", (Throwable)e);
        }
        ApexWSDLDownloaderService apexWSDLDownloaderService = new ApexWSDLDownloaderService();
        Integer proxyPort = this.salesforceConnector.getConfig().getProxyPort() != null ? Integer.valueOf(this.salesforceConnector.getConfig().getProxyPort()) : null;
        for (String apexClassName : wsdlClassNames) {
            try {
                urls.add(apexWSDLDownloaderService.downloadWSDLForApexClass(serviceEndpoint, apexClassName, sessionId, tempDirAbsolutePath, this.salesforceConnector.getConfig().getProxyHost(), proxyPort, this.salesforceConnector.getConfig().getProxyUsername(), this.salesforceConnector.getConfig().getProxyPassword(), this.salesforceConnector.getConfig().getConnectionTimeout(), this.salesforceConnector.getConfig().getReadTimeout()).toURL());
            }
            catch (Exception e) {
                logger.error("Unable to download and save: {}", (Object)apexClassName, (Object)e);
            }
        }
        return urls;
    }

    @NotNull
    private List<String> getApexClassNames() throws SalesforceException {
        Config config = this.salesforceConnector.getConfig();
        List<String> result = config.getApexClassNames();
        if (config.getFetchAllApexSoapMetadata()) {
            result = this.extractAllApexClasses();
        }
        return result;
    }

    @NotNull
    private List<String> extractAllApexClasses() throws SalesforceException {
        ArrayList<String> result = new ArrayList<String>();
        try {
            List<FileProperties> fileProperties = this.salesforceConnector.listMetadata(MetadataType.ApexClass.getDisplayName());
            for (FileProperties fileProperty : fileProperties) {
                result.add(fileProperty.getFullName());
            }
        }
        catch (ConnectionException e) {
            logger.error("Unable to retrieve all apex classes", (Throwable)e);
        }
        return result;
    }

    public List<MetaDataKey> getMetadataKeys() throws MalformedURLException, URISyntaxException, WSDLException, SalesforceException {
        this.loadWsdlMetaData();
        return this.wsdlMetadata.getMetaDataKeys();
    }

    public MetaData getInputMetaData(MetaDataKey key) throws Exception {
        this.loadWsdlMetaDataIfNull();
        return this.wsdlMetadata.getInputMetaData(key);
    }

    public MetaData getOutputMetaData(MetaDataKey key) throws Exception {
        this.loadWsdlMetaDataIfNull();
        return this.wsdlMetadata.getOutputMetaData(key);
    }

    private void loadWsdlMetaDataIfNull() throws MalformedURLException, URISyntaxException, WSDLException, SalesforceException {
        if (this.wsdlMetadata == null) {
            this.loadWsdlMetaData();
        }
    }

    public void setSalesforceConnector(SalesforceConnector salesforceConnector) {
        this.salesforceConnector = salesforceConnector;
    }

    public SalesforceConnector getSalesforceConnector() {
        return this.salesforceConnector;
    }
}

