/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.category;

import com.sforce.soap.partner.DescribeGlobalResult;
import com.sforce.soap.partner.DescribeGlobalSObjectResult;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.Field;
import com.sforce.soap.partner.QueryResult;
import com.sforce.ws.ConnectionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.DefaultUnknownMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.builder.DefaultMetaDataBuilder;
import org.mule.common.metadata.builder.DynamicObjectBuilder;
import org.mule.common.metadata.builder.DynamicObjectFieldBuilder;
import org.mule.common.metadata.builder.ListMetaDataBuilder;
import org.mule.common.metadata.datatype.DataType;
import org.mule.modules.salesforce.QueryResultObject;
import org.mule.modules.salesforce.SalesforceConnector;
import org.mule.modules.salesforce.apex.rest.ApexClassInnerType;
import org.mule.modules.salesforce.apex.rest.ApexClassType;
import org.mule.modules.salesforce.apex.rest.ApexTypeUtils;
import org.mule.modules.salesforce.category.SalesforceMetadataCategory;
import org.mule.modules.salesforce.config.CustomPartnerConnection;

public class ApexRestMetadataCategory
extends SalesforceMetadataCategory {
    @Inject
    private SalesforceConnector connector;

    @Override
    public List<MetaDataKey> getMetaDataKeys() throws ConnectionException {
        String query;
        ArrayList<MetaDataKey> keys = new ArrayList<MetaDataKey>();
        if (this.connector.getConfig().getFetchAllApexRestMetadata()) {
            query = "SELECT ApiVersion,Body,Name FROM ApexClass";
        } else {
            List<String> apexClassNames = this.connector.getConfig().getApexClassNames();
            if (apexClassNames.isEmpty()) {
                return keys;
            }
            StringBuilder queryBuilder = new StringBuilder("SELECT ApiVersion,Body,Name FROM ApexClass WHERE ");
            queryBuilder.append("Name='" + apexClassNames.get(0) + "'");
            for (int i = 1; i < apexClassNames.size(); ++i) {
                queryBuilder.append("OR Name='" + apexClassNames.get(i) + "'");
            }
            query = queryBuilder.toString();
        }
        CustomPartnerConnection customPartnerConnection = this.connector.getConfig().getCustomPartnerConnection();
        if (customPartnerConnection == null) {
            throw new ConnectionException("Connection not yet initialized.");
        }
        QueryResult result = customPartnerConnection.query(query);
        QueryResultObject queryResultObject = new QueryResultObject(result);
        List<Map<String, Object>> data = queryResultObject.getData();
        for (Map<String, Object> aData : data) {
            String classBody = (String)aData.get("Body");
            ApexClassType apexClass = ApexClassType.parse(classBody);
            List<String> methods = apexClass.getMethodNames();
            for (String method : methods) {
                String displayName = aData.get("Name") + "-" + method;
                DefaultMetaDataKey dataKey = new DefaultMetaDataKey(displayName, displayName);
                keys.add((MetaDataKey)dataKey);
            }
        }
        return keys;
    }

    @NotNull
    public MetaData getMethodMetadata(@NotNull ApexClassType apexClass, @NotNull String methodName, boolean inputMetadata) throws ConnectionException {
        DynamicObjectBuilder dynamicObject = new DefaultMetaDataBuilder().createDynamicObject(methodName);
        DescribeGlobalResult global = this.connector.describeGlobal();
        Map<String, String> sObjectsMap = this.getMapOfSObjectTypes(global);
        if (inputMetadata) {
            Map<String, String> inputTypes = apexClass.getMethodInputTypes().get(methodName);
            List<String> wildCardParameters = apexClass.getUrlWildCardParameters();
            if (!wildCardParameters.isEmpty()) {
                DynamicObjectFieldBuilder dynamicInnerObject = dynamicObject.addDynamicObjectField("URLParameters");
                for (String parameterLabel : wildCardParameters) {
                    dynamicInnerObject.addSimpleField(parameterLabel, DataType.STRING);
                }
            } else if (inputTypes.isEmpty()) {
                return new DefaultMetaData((MetaDataModel)new DefaultUnknownMetaDataModel());
            }
            if (!inputTypes.isEmpty()) {
                dynamicObject = this.handleMethodInputParameters(inputTypes, dynamicObject, sObjectsMap);
            }
        } else {
            String type = apexClass.getMethodOutputType().get(methodName);
            if (!type.equals("void")) {
                dynamicObject = this.handleParameter(methodName + "Output", type, dynamicObject, sObjectsMap);
            } else {
                return new DefaultMetaData((MetaDataModel)new DefaultUnknownMetaDataModel());
            }
        }
        MetaDataModel model = dynamicObject.build();
        DefaultMetaData metaData = new DefaultMetaData(model);
        return metaData;
    }

    public MetaData getInputMetaData(MetaDataKey key) throws Exception {
        return this.getMetadata(key, true);
    }

    private MetaData getMetadata(MetaDataKey key, boolean inputMetadata) throws ConnectionException {
        String[] metadataKey = key.getId().split("-");
        if (metadataKey.length == 1) {
            return new DefaultMetaData((MetaDataModel)new DefaultUnknownMetaDataModel());
        }
        String className = metadataKey[0];
        String methodName = metadataKey[1];
        String query = "SELECT ApiVersion,Body,Name FROM ApexClass WHERE Name = '" + className.trim() + "'";
        CustomPartnerConnection customPartnerConnection = this.connector.getConfig().getCustomPartnerConnection();
        if (customPartnerConnection == null) {
            throw new ConnectionException("Connection not yet initialized.");
        }
        String classBody = ApexTypeUtils.fetchClassBody(customPartnerConnection, query);
        if (classBody.isEmpty()) {
            throw new ConnectionException("The Apex Rest Class " + className + " does not exist in Salesforce!");
        }
        ApexClassType apexClass = ApexClassType.parse(classBody);
        return this.getMethodMetadata(apexClass, methodName, inputMetadata);
    }

    private DynamicObjectBuilder handleMethodInputParameters(Map<String, String> inputTypes, DynamicObjectBuilder dynamicObject, Map<String, String> sObjectsMap) throws ConnectionException {
        for (Map.Entry<String, String> e : inputTypes.entrySet()) {
            String name = e.getKey();
            String type = e.getValue();
            dynamicObject = this.handleParameter(name, type, dynamicObject, sObjectsMap);
        }
        return dynamicObject;
    }

    @NotNull
    private DynamicObjectBuilder handleParameter(@NotNull String name, @NotNull String type, @NotNull DynamicObjectBuilder result, @NotNull Map<String, String> sObjectsMap) throws ConnectionException {
        ApexClassInnerType dataType = ApexClassInnerType.parse(type);
        String typeToCheck = dataType.getGenericType();
        if (sObjectsMap.containsKey(typeToCheck)) {
            DynamicObjectFieldBuilder dynamicInnerObject;
            ListMetaDataBuilder listBuilder;
            DescribeSObjectResult describeSObject = this.connector.describeSObject(typeToCheck);
            if (dataType.isList()) {
                listBuilder = result.addList(name);
                dynamicInnerObject = listBuilder.ofDynamicObject(typeToCheck);
            } else if (dataType.isMap()) {
                listBuilder = result.addList(name);
                DynamicObjectBuilder dynamicInnerEntryObject = listBuilder.ofDynamicObject(typeToCheck);
                dynamicInnerEntryObject.addSimpleField("key", DataType.STRING);
                dynamicInnerObject = dynamicInnerEntryObject.addDynamicObjectField("value");
            } else {
                dynamicInnerObject = result.addDynamicObjectField(name);
            }
            if (describeSObject != null) {
                Field[] fields;
                for (Field f : fields = describeSObject.getFields()) {
                    this.addField(f, (DynamicObjectBuilder)dynamicInnerObject);
                }
            }
        } else {
            ApexClassInnerType realType = ApexClassInnerType.parse(typeToCheck);
            if (dataType.isList()) {
                ListMetaDataBuilder listBuilder = result.addList(name);
                listBuilder.ofSimpleField(realType.getDataType());
            } else if (dataType.isMap()) {
                ListMetaDataBuilder listBuilder = result.addList(name);
                DynamicObjectBuilder dynamicInnerEntryObject = listBuilder.ofDynamicObject(typeToCheck);
                dynamicInnerEntryObject.addSimpleField("key", DataType.STRING);
                dynamicInnerEntryObject.addSimpleField("value", realType.getDataType());
            } else {
                result.addSimpleField(name, realType.getDataType());
            }
        }
        return result;
    }

    public MetaData getOutputMetaData(MetaDataKey key) throws Exception {
        return this.getMetadata(key, false);
    }

    @Override
    public void setConnector(SalesforceConnector connector) {
        this.connector = connector;
    }

    @Override
    public SalesforceConnector getConnector() {
        return this.connector;
    }

    private Map<String, String> getMapOfSObjectTypes(DescribeGlobalResult describeGlobalResult) {
        DescribeGlobalSObjectResult[] sObjectsArray;
        HashMap<String, String> sObjects = new HashMap<String, String>();
        for (DescribeGlobalSObjectResult sObject : sObjectsArray = describeGlobalResult.getSobjects()) {
            sObjects.put(sObject.getName(), sObject.getName());
        }
        return sObjects;
    }
}

