/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.api;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.InvocationHandler;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;
import org.mule.modules.salesforce.Config;
import org.mule.modules.salesforce.api.SalesforceHeader;
import org.mule.modules.salesforce.config.CustomPartnerConnection;

public class SalesforceSoapAdapter {
    private static final Logger logger = Logger.getLogger(SalesforceSoapAdapter.class);

    private SalesforceSoapAdapter() {
    }

    public static CustomPartnerConnection adapt(final CustomPartnerConnection facade, final Map<SalesforceHeader, Object> headers, final Config strategy) {
        return (CustomPartnerConnection)Enhancer.create(CustomPartnerConnection.class, (Callback)new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Invoked method %s with arguments %s", method.getName(), Arrays.toString(args)));
                }
                try {
                    CustomPartnerConnection connection = SalesforceSoapAdapter.addHeaders(facade, headers, strategy);
                    Object ret = method.invoke((Object)connection, args);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("Returned method %s with value %s", ret, Arrays.toString(args)));
                    }
                    return ret;
                }
                catch (Exception e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Method " + method.getName() + " threw " + e.getClass()));
                    }
                    throw e;
                }
            }
        });
    }

    private static CustomPartnerConnection addHeaders(CustomPartnerConnection partnerConnection, Map<SalesforceHeader, Object> headers, Config strategy) {
        strategy.setConnectionOptions(partnerConnection);
        if (headers != null) {
            SalesforceSoapAdapter.clearHeaders(partnerConnection);
            for (Map.Entry<SalesforceHeader, Object> entry : headers.entrySet()) {
                if (!Map.class.isAssignableFrom(entry.getValue().getClass())) {
                    logger.error((Object)String.format("The header %s should be a Map", entry.getKey().getHeaderName()));
                    continue;
                }
                try {
                    Object headerObject = entry.getKey().getHeaderClass().newInstance();
                    BeanUtils.populate(headerObject, (Map)((Map)entry.getValue()));
                    partnerConnection.getClass().getMethod("__set" + entry.getKey().getHeaderName(), entry.getKey().getHeaderClass()).invoke((Object)partnerConnection, headerObject);
                }
                catch (Exception e) {
                    logger.error((Object)String.format("Header %s is incorrect, couldn't be added to the request", entry.getKey().toString()), (Throwable)e);
                }
            }
        }
        return partnerConnection;
    }

    private static void clearHeaders(CustomPartnerConnection partnerConnection) {
        if (partnerConnection.getConnection() != null) {
            partnerConnection.getConnection().clearAllOrNoneHeader();
            partnerConnection.getConnection().clearDisableFeedTrackingHeader();
            partnerConnection.getConnection().clearEmailHeader();
            partnerConnection.getConnection().clearLocaleOptions();
            partnerConnection.getConnection().clearMruHeader();
            partnerConnection.getConnection().clearOwnerChangeOptions();
            partnerConnection.getConnection().clearQueryOptions();
            partnerConnection.getConnection().clearUserTerritoryDeleteHeader();
        }
    }
}

