/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.apex.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;

public class GregorianCalendarSerializer
implements JsonSerializer<GregorianCalendar> {
    public static final String FORMAT_DATE_TIME = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String FORMAT_TIME = "HH:mm:ss.SSS";

    public JsonElement serialize(GregorianCalendar cal, Type typeOfSrc, JsonSerializationContext context) {
        SimpleDateFormat fmt = null;
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        fmt = year == 1970 && month == 0 && day == 1 ? new SimpleDateFormat(FORMAT_TIME) : new SimpleDateFormat(FORMAT_DATE_TIME);
        fmt.setCalendar(cal);
        String dateFormatted = fmt.format(cal.getTime());
        JsonPrimitive prim = new JsonPrimitive(dateFormatted);
        return prim;
    }
}

