/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.apex.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class CalendarDeserializer
implements JsonDeserializer<Calendar> {
    public GregorianCalendar deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String stringDate = json.getAsString();
        Calendar cal = GregorianCalendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
        try {
            cal.setTime(sdf.parse(stringDate));
        }
        catch (ParseException e) {
            throw new JsonParseException("Unable to parse time: " + stringDate, (Throwable)e);
        }
        return (GregorianCalendar)cal;
    }
}

