/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.apex.util;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.mule.modules.salesforce.HttpClientService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApexWSDLDownloaderService {
    private static final String WSDL_URL_TEMPLATE = "%s/services/wsdl/class/%s";
    private static final String SESSION_COOKIE_NAME = "sid";
    private static final String APEX_DIR_TEMPLATE = "file:///%s%s.wsdl";
    private static final Logger logger = LoggerFactory.getLogger(ApexWSDLDownloaderService.class);

    public URI downloadWSDLForApexClass(String serviceEndpoint, String apexClassName, String sessionId, String tempDir, String proxyHost, Integer proxyPort, String proxyUsername, String proxyPassword, Integer connectionTimeout, Integer readTimeout) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8");
        headers.put("Accept-Encoding", "gzip, deflate, sdch");
        headers.put("Accept-Language", "en-US,en;q=0.8,ro;q=0.6");
        HashMap<String, String> cookies = new HashMap<String, String>();
        cookies.put(SESSION_COOKIE_NAME, sessionId);
        try {
            HttpClientService httpClientService = new HttpClientService(proxyHost, proxyPort, proxyUsername, proxyPassword, connectionTimeout, readTimeout);
            InputStream responseStream = httpClientService.sendGet(String.format(WSDL_URL_TEMPLATE, serviceEndpoint, apexClassName), headers, cookies);
            return this.saveWSDLFile(responseStream, tempDir, apexClassName);
        }
        catch (IOException e) {
            logger.error("Failed retrieving response stream", (Throwable)e);
            throw new Exception("Unknown error occurred while trying to download wsdl file", e);
        }
    }

    @NotNull
    private URI saveWSDLFile(@NotNull InputStream inputStream, @NotNull String tempDir, @NotNull String apexClassName) throws Exception {
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        String baseDir = tempDir.endsWith("/") || tempDir.endsWith("\\") ? tempDir : tempDir + File.separator;
        try {
            URI absoluteUri = new URI(String.format(APEX_DIR_TEMPLATE, baseDir.replace("\\", "/"), apexClassName));
            File wsdlFile = new File(absoluteUri);
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, Charsets.UTF_8));
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(wsdlFile), Charsets.UTF_8));
            while (bufferedReader.ready()) {
                bufferedWriter.write(bufferedReader.readLine());
                bufferedWriter.newLine();
            }
            URI uRI = absoluteUri;
            return uRI;
        }
        catch (MalformedURLException e) {
            logger.error("Failed accessing wsdl file", (Throwable)e);
            throw new Exception("Failed accessing wsdl file", e);
        }
        catch (IOException e) {
            logger.error("Failed reading wsdl file", (Throwable)e);
            throw new Exception("Failed reading wsdl file", e);
        }
        catch (URISyntaxException e) {
            logger.error("Failed accessing wsdl file", (Throwable)e);
            throw new Exception("Failed accessing wsdl file", e);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    logger.error("Failed closing reader", (Throwable)e);
                }
            }
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException e) {
                    logger.error("Failed closing writer", (Throwable)e);
                }
            }
        }
    }
}

