/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.apex.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.mule.modules.salesforce.HttpClientService;
import org.mule.modules.salesforce.apex.rest.ApexClassInnerType;
import org.mule.modules.salesforce.apex.rest.ApexRequestHeaders;
import org.mule.modules.salesforce.apex.util.CalendarDeserializer;
import org.mule.modules.salesforce.apex.util.DateDeserializer;
import org.mule.modules.salesforce.apex.util.DateSerializer;
import org.mule.modules.salesforce.apex.util.GregorianCalendarDeserializer;
import org.mule.modules.salesforce.apex.util.GregorianCalendarSerializer;
import org.mule.transport.http.PatchMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApexRestInvocation {
    private static final Logger logger = LoggerFactory.getLogger(ApexRestInvocation.class);
    private String sessionId;
    private String serviceRelativePath;
    private String basePath;
    private String requestType;
    private String methodName;
    private Map<String, String> queryParameters;
    private Map<String, Object> inputData;
    private ApexRequestHeaders requestHeaders;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private Integer connectionTimeout;
    private Integer readTimeout;
    private ApexClassInnerType outputType;

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getServiceRelativePath() {
        return this.serviceRelativePath;
    }

    public void setServiceRelativePath(String serviceRelativePath) {
        this.serviceRelativePath = serviceRelativePath.substring(1);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public ApexRequestHeaders getRequestHeaders() {
        return this.requestHeaders;
    }

    public void setRequestHeaders(ApexRequestHeaders requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    @NotNull
    private ApexClassInnerType getOutputType() {
        return this.outputType;
    }

    private String getServiceUrl() {
        if (this.getServiceRelativePath() != null && this.getServiceRelativePath().contains("*")) {
            Map urlParameters;
            if (this.inputData != null && !this.inputData.isEmpty() && (urlParameters = (Map)this.inputData.get("URLParameters")) != null) {
                String relativePath = this.getServiceRelativePath();
                for (int i = 1; i <= urlParameters.size(); ++i) {
                    String wildCardValue = (String)urlParameters.get("Parameter" + i);
                    if (wildCardValue == null) continue;
                    relativePath = relativePath.replaceFirst("\\*", wildCardValue);
                }
                return this.addQueryParameters(this.getBasePath() + relativePath);
            }
            return this.addQueryParameters(this.getBasePath() + this.getServiceRelativePath().replace("*", ""));
        }
        return this.addQueryParameters(this.getBasePath() + this.getServiceRelativePath());
    }

    private String addQueryParameters(String resourceUrl) {
        if (this.queryParameters != null && !this.queryParameters.isEmpty()) {
            StringBuilder fullResourceUrl = new StringBuilder(resourceUrl);
            fullResourceUrl.append("?");
            for (Map.Entry<String, String> entry : this.queryParameters.entrySet()) {
                fullResourceUrl.append(entry.getKey());
                fullResourceUrl.append("=");
                fullResourceUrl.append(entry.getValue());
                fullResourceUrl.append("&");
            }
            fullResourceUrl.deleteCharAt(fullResourceUrl.length() - 1);
            return fullResourceUrl.toString();
        }
        return resourceUrl;
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(Map<String, String> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public Map<String, Object> getInputData() {
        return this.inputData;
    }

    public void setInputData(Map<String, Object> inputData) {
        this.inputData = inputData == null ? new HashMap<String, Object>() : inputData;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getInputDataAsJson() {
        GsonBuilder gBuilder = new GsonBuilder();
        gBuilder.registerTypeAdapter(GregorianCalendar.class, (Object)new GregorianCalendarSerializer());
        gBuilder.registerTypeAdapter(Date.class, (Object)new DateSerializer());
        gBuilder.setPrettyPrinting();
        Gson gson = gBuilder.create();
        HashMap<String, Object> input = new HashMap<String, Object>(this.inputData);
        input.remove("URLParameters");
        return gson.toJson(input);
    }

    public Map<String, Object> invokeApexRest() throws IOException {
        Map<String, String> headers = this.getHeaders();
        Map<String, String> cookies = this.getCookies();
        String inputBody = this.getInputDataAsJson();
        HttpClientService httpClientService = new HttpClientService(this.proxyHost, this.proxyPort, this.proxyUsername, this.proxyPassword, this.connectionTimeout, this.readTimeout);
        InputStream resultAsStream = httpClientService.send(this.getHttpMethod(), this.getServiceUrl(), inputBody, headers, cookies);
        String result = IOUtils.toString((InputStream)resultAsStream, (String)"UTF-8");
        Map<String, Object> map = new HashMap<String, Object>();
        try {
            map = this.handleComplexResult(map, result);
        }
        catch (JsonSyntaxException ex) {
            logger.debug("Handle simple result", (Throwable)ex);
            map = this.handleSimpleResult(map, result);
        }
        return map;
    }

    private Map<String, String> getHeaders() {
        Map<String, String> requestHeaders;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.getRequestHeaders() != null && (requestHeaders = this.getRequestHeaders().getHeaders()) != null && !requestHeaders.isEmpty()) {
            headers.putAll(requestHeaders);
        }
        headers.put("Content-Type", "application/json");
        headers.put("charset", "UTF-8");
        headers.put("Accept-Encoding", "application/json");
        headers.put("Authorization", "Bearer " + this.getSessionId());
        return headers;
    }

    private Map<String, String> getCookies() {
        if (this.getRequestHeaders() != null) {
            return this.getRequestHeaders().getCookies();
        }
        return null;
    }

    private Map<String, Object> handleComplexResult(Map<String, Object> map, String result) {
        if (this.outputType.isList()) {
            List innerMapList = (List)new Gson().fromJson(result, new TypeToken<List<Map<String, Object>>>(){}.getType());
            for (Map innerMap : innerMapList) {
                innerMap.remove("attributes");
            }
            map.put(this.getMethodName() + "Output", innerMapList);
        } else if (this.outputType.isMap()) {
            Map innerMap = (Map)new Gson().fromJson(result, new TypeToken<Map<String, Map<String, Object>>>(){}.getType());
            for (String key : innerMap.keySet()) {
                ((Map)innerMap.get(key)).remove("attributes");
            }
            map.put(this.getMethodName() + "Output", this.getMapForOutput(innerMap));
        } else {
            Map innerMap = (Map)new Gson().fromJson(result, new TypeToken<HashMap<String, Object>>(){}.getType());
            innerMap.remove("attributes");
            map.put(this.getMethodName() + "Output", innerMap);
        }
        return map;
    }

    @NotNull
    private Map<String, Object> handleSimpleResult(@NotNull Map<String, Object> map, @NotNull String result) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        if (this.outputType.isDate()) {
            gsonBuilder.registerTypeAdapter(GregorianCalendar.class, (Object)new GregorianCalendarDeserializer());
            gsonBuilder.registerTypeAdapter(Calendar.class, (Object)new CalendarDeserializer());
            gsonBuilder.registerTypeAdapter(Date.class, (Object)new DateDeserializer());
        } else if (this.outputType.isList()) {
            Gson gson = gsonBuilder.create();
            List innerList = (List)gson.fromJson(result, this.getOutputType().getListTypeToken());
            map.put(this.getMethodName() + "Output", innerList);
        } else if (this.outputType.isMap()) {
            Gson gson = gsonBuilder.create();
            Map innerMap = (Map)gson.fromJson(result, this.getOutputType().getMapTypeToken());
            map.put(this.getMethodName() + "Output", this.getSimpleMapForOutput(innerMap));
        } else {
            Gson gson = gsonBuilder.create();
            Object res = gson.fromJson(result, this.getOutputType().getTypeToken());
            map.put(this.getMethodName() + "Output", res);
        }
        return map;
    }

    @NotNull
    private List<Map<String, Object>> getMapForOutput(Map<String, Map<String, Object>> map) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Map.Entry<String, Map<String, Object>> entry : map.entrySet()) {
            HashMap<String, Object> element = new HashMap<String, Object>();
            element.put("key", entry.getKey());
            element.put("value", entry.getValue());
            result.add(element);
        }
        return result;
    }

    private List<Map<String, Object>> getSimpleMapForOutput(Map<String, Object> map) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            HashMap<String, Object> element = new HashMap<String, Object>();
            element.put("key", entry.getKey());
            element.put("value", entry.getValue());
            result.add(element);
        }
        return result;
    }

    @NotNull
    private HttpMethod getHttpMethod() {
        String requestType = this.getRequestType();
        GetMethod result = new GetMethod();
        if (requestType.equals("HttpPost")) {
            result = new PostMethod();
        } else if (requestType.equals("HttpPut")) {
            result = new PutMethod();
        } else {
            if (requestType.equals("HttpDelete")) {
                return new DeleteMethod();
            }
            if (requestType.equals("HttpPatch")) {
                result = new PatchMethod();
            }
        }
        return result;
    }

    public void setOutputType(@NotNull ApexClassInnerType outputType) {
        this.outputType = outputType;
    }
}

