/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.apex.rest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApexClassType {
    private static final String APEX_REST_CLASS_NAME_STRING_PATTERN = "[ ]*(global)[ ][ ]*(with sharing|without sharing)?[ ][ ]*(class)[ ][ ]*([a-zA-Z0-9]*)";
    private static final String APEX_REST_CLASS_BODY_STRING_PATTERN = "@(HttpDelete|HttpGet|HttpPost|HttpPut|HttpPatch)[ ]*(public|private|protected|global)?[ ]*(override)*[ ]*(static)*[ ]*(with sharing|without sharing)?[ ]*([a-zA-Z0-9,<>\\[\\] ]*[ ])*([a-zA-Z0-9]*)(\\([a-zA-Z0-9 ,<>\\[\\]]*\\))";
    private static final String URL_MAPPING_STRING_PATTERN = "@(RestResource\\(urlMapping=')([a-zA-Z0-9/\\*]*)('\\))";
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("[ ]*(global)[ ][ ]*(with sharing|without sharing)?[ ][ ]*(class)[ ][ ]*([a-zA-Z0-9]*)");
    private static final Pattern APEX_REST_CLASS_BODY_PATTERN = Pattern.compile("@(HttpDelete|HttpGet|HttpPost|HttpPut|HttpPatch)[ ]*(public|private|protected|global)?[ ]*(override)*[ ]*(static)*[ ]*(with sharing|without sharing)?[ ]*([a-zA-Z0-9,<>\\[\\] ]*[ ])*([a-zA-Z0-9]*)(\\([a-zA-Z0-9 ,<>\\[\\]]*\\))");
    private static final Pattern URL_MAPPING_PATTERN = Pattern.compile("@(RestResource\\(urlMapping=')([a-zA-Z0-9/\\*]*)('\\))");
    private final String classBody;
    private String className;
    private String resourceUrl;
    private final List<String> methodNames;
    private final Map<String, String> methodRequestTypes;
    private final Map<String, Map<String, String>> methodInputTypes;
    private final Map<String, String> methodOutputType;

    private ApexClassType(@NotNull String classBody) {
        this.classBody = classBody;
        this.methodNames = new ArrayList<String>();
        this.methodRequestTypes = new HashMap<String, String>();
        this.methodInputTypes = new HashMap<String, Map<String, String>>();
        this.methodOutputType = new HashMap<String, String>();
    }

    @NotNull
    public static ApexClassType parse(@NotNull String classBody) {
        ApexClassType result = new ApexClassType(classBody);
        result.parse();
        return result;
    }

    @NotNull
    private String getInlineBody(@NotNull String apexClassBody) {
        String result = apexClassBody.replace('\n', ' ');
        result = result.replace('\t', ' ');
        result = result.replace('\r', ' ');
        return result;
    }

    private void parse() {
        String allClassInline = this.getInlineBody(this.classBody);
        Matcher urlMappingMatcher = URL_MAPPING_PATTERN.matcher(allClassInline);
        if (urlMappingMatcher.find()) {
            this.resourceUrl = urlMappingMatcher.group(2).trim();
        }
        this.className = this.parseClassName();
        Matcher matcher = APEX_REST_CLASS_BODY_PATTERN.matcher(allClassInline);
        while (matcher.find()) {
            if (matcher.group(7) == null || matcher.group(7).trim().isEmpty()) continue;
            String methodName = matcher.group(7).trim();
            this.methodNames.add(methodName);
            HashMap<String, String> inputParamTypes = new HashMap<String, String>();
            String requestType = matcher.group(1).trim();
            this.methodRequestTypes.put(methodName, requestType);
            String input = matcher.group(8).substring(1, matcher.group(8).length() - 1);
            String[] inputParameters = input.split(",");
            StringBuilder composedType = new StringBuilder();
            for (String inputParameter : inputParameters) {
                String[] parameterDefinition;
                if (inputParameter.contains("<") && !inputParameter.contains(">")) {
                    composedType.append(inputParameter.trim());
                    continue;
                }
                if (!inputParameter.contains("<") && inputParameter.contains(">")) {
                    composedType.append("," + inputParameter.trim());
                    parameterDefinition = composedType.toString().trim().split(">");
                    inputParamTypes.put(parameterDefinition[1].trim(), parameterDefinition[0].trim() + ">");
                    composedType.setLength(0);
                    continue;
                }
                if (inputParameter.contains("<") && inputParameter.contains(">")) {
                    parameterDefinition = inputParameter.trim().split(">");
                    inputParamTypes.put(parameterDefinition[1].trim(), parameterDefinition[0].trim() + ">");
                    continue;
                }
                if (inputParameter.trim().isEmpty()) continue;
                parameterDefinition = inputParameter.trim().split(" ");
                inputParamTypes.put(parameterDefinition[1].trim(), parameterDefinition[0].trim());
            }
            this.methodInputTypes.put(methodName, inputParamTypes);
            if (matcher.group(6) == null) continue;
            String methodOutput = matcher.group(6).trim();
            this.methodOutputType.put(methodName, methodOutput);
        }
    }

    @NotNull
    public List<String> getUrlWildCardParameters() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.resourceUrl != null && this.resourceUrl.contains("*")) {
            String urlCopy = this.resourceUrl;
            int index = urlCopy.indexOf("*");
            int count = 0;
            while (index != -1) {
                urlCopy = urlCopy.substring(index + 1);
                index = urlCopy.indexOf("*");
                String parameterLabel = "Parameter" + ++count;
                result.add(parameterLabel);
            }
        }
        return result;
    }

    @NotNull
    public String parseClassName() {
        String className = "";
        String allInline = this.getInlineBody(this.classBody);
        Matcher matcher = CLASS_NAME_PATTERN.matcher(allInline);
        while (matcher.find()) {
            if (matcher.group(4) == null) continue;
            className = matcher.group(4).trim();
        }
        return className;
    }

    @NotNull
    public String getClassBody() {
        return this.classBody;
    }

    @Nullable
    public String getResourceUrl() {
        return this.resourceUrl;
    }

    @NotNull
    public List<String> getMethodNames() {
        return this.methodNames;
    }

    public Map<String, String> getMethodRequestTypes() {
        return this.methodRequestTypes;
    }

    @NotNull
    public Map<String, Map<String, String>> getMethodInputTypes() {
        return this.methodInputTypes;
    }

    @NotNull
    public Map<String, String> getMethodOutputType() {
        return this.methodOutputType;
    }

    @NotNull
    public String getClassName() {
        return this.className;
    }
}

