/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.apex.rest;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.mule.common.metadata.datatype.DataType;

public class ApexClassInnerType {
    private static final String SOBJECT_LIST = "(List)[ ]*(<)([a-zA-Z0-9 ]*)(>)";
    private static final String SOBJECT_MAP = "(Map)[ ]*(<)([a-zA-Z0-9 ]*),([a-zA-Z0-9 ]*)(>)";
    private static final String SOBJECT_ARRAY = "([a-zA-Z0-9 ]*)(\\[[ ]*\\])";
    private static final String DATE_TYPE = "(Date|Datetime|Time)";
    private static final Pattern LIST_PATTERN = Pattern.compile("(List)[ ]*(<)([a-zA-Z0-9 ]*)(>)|([a-zA-Z0-9 ]*)(\\[[ ]*\\])");
    private static final Pattern DATE_PATTERN = Pattern.compile("(Date|Datetime|Time)");
    private static final Pattern SOBJECT_MAP_PATTERN = Pattern.compile("(Map)[ ]*(<)([a-zA-Z0-9 ]*),([a-zA-Z0-9 ]*)(>)");
    private final String type;
    private boolean isList;
    private boolean isMap;
    private String genericType;

    private ApexClassInnerType(@NotNull String type) {
        this.type = type;
        this.genericType = type;
        Matcher listMatcher = LIST_PATTERN.matcher(type);
        if (listMatcher.find()) {
            this.isList = true;
            if (listMatcher.group(3) != null) {
                this.genericType = listMatcher.group(3).trim();
            } else if (listMatcher.group(5) != null) {
                this.genericType = listMatcher.group(5).trim();
            }
        } else {
            Matcher mapMatcher = SOBJECT_MAP_PATTERN.matcher(type);
            if (mapMatcher.find()) {
                this.isMap = true;
                this.genericType = mapMatcher.group(4).trim();
            }
        }
    }

    public static ApexClassInnerType parse(@NotNull String type) {
        return new ApexClassInnerType(type);
    }

    @NotNull
    public String getGenericType() {
        return this.genericType;
    }

    public boolean isList() {
        return this.isList;
    }

    public boolean isMap() {
        return this.isMap;
    }

    public boolean isDate() {
        Matcher matcher = DATE_PATTERN.matcher(this.type);
        return matcher.find();
    }

    @NotNull
    public Type getTypeToken() {
        Type result = new TypeToken<Object>(){}.getType();
        if (this.type.equalsIgnoreCase("Boolean")) {
            result = new TypeToken<Boolean>(){}.getType();
        } else if (this.type.equalsIgnoreCase("Date")) {
            result = new TypeToken<Date>(){}.getType();
        } else if (this.type.equalsIgnoreCase("Datetime")) {
            result = new TypeToken<GregorianCalendar>(){}.getType();
        } else if (this.type.equalsIgnoreCase("Decimal")) {
            result = new TypeToken<Double>(){}.getType();
        } else if (this.type.equalsIgnoreCase("Double")) {
            result = new TypeToken<Double>(){}.getType();
        } else if (this.type.equalsIgnoreCase("Integer")) {
            result = new TypeToken<Integer>(){}.getType();
        } else if (this.type.equalsIgnoreCase("Long")) {
            result = new TypeToken<Long>(){}.getType();
        } else if (this.type.equalsIgnoreCase("Time")) {
            result = new TypeToken<Calendar>(){}.getType();
        }
        return result;
    }

    @NotNull
    public Type getMapTypeToken() {
        Type result = new TypeToken<HashMap<String, Object>>(){}.getType();
        if (this.type.equalsIgnoreCase("Boolean")) {
            result = new TypeToken<HashMap<String, Boolean>>(){}.getType();
        } else if (this.type.equalsIgnoreCase("Date")) {
            result = new TypeToken<HashMap<String, Date>>(){}.getType();
        } else if (this.type.equalsIgnoreCase("Datetime")) {
            result = new TypeToken<HashMap<String, GregorianCalendar>>(){}.getType();
        } else if (this.type.equalsIgnoreCase("Decimal")) {
            result = new TypeToken<HashMap<String, Object>>(){}.getType();
        } else if (this.type.equalsIgnoreCase("Double")) {
            result = new TypeToken<HashMap<String, Double>>(){}.getType();
        } else if (this.type.equalsIgnoreCase("Integer")) {
            result = new TypeToken<HashMap<String, Integer>>(){}.getType();
        } else if (this.type.equalsIgnoreCase("Long")) {
            result = new TypeToken<HashMap<String, Long>>(){}.getType();
        } else if (this.type.equalsIgnoreCase("Time")) {
            result = new TypeToken<HashMap<String, Calendar>>(){}.getType();
        }
        return result;
    }

    @NotNull
    public Type getListTypeToken() {
        Type result = new TypeToken<List<Object>>(){}.getType();
        if (this.type.equalsIgnoreCase("Boolean")) {
            result = new TypeToken<List<Boolean>>(){}.getType();
        } else if (this.type.equalsIgnoreCase("Date")) {
            result = new TypeToken<List<Date>>(){}.getType();
        } else if (this.type.equalsIgnoreCase("Datetime")) {
            result = new TypeToken<List<GregorianCalendar>>(){}.getType();
        } else if (this.type.equalsIgnoreCase("Decimal")) {
            result = new TypeToken<List<Object>>(){}.getType();
        } else if (this.type.equalsIgnoreCase("Double")) {
            result = new TypeToken<List<Double>>(){}.getType();
        } else if (this.type.equalsIgnoreCase("Integer")) {
            result = new TypeToken<List<Integer>>(){}.getType();
        } else if (this.type.equalsIgnoreCase("Long")) {
            result = new TypeToken<List<Long>>(){}.getType();
        } else if (this.type.equalsIgnoreCase("Time")) {
            result = new TypeToken<List<Calendar>>(){}.getType();
        }
        return result;
    }

    @NotNull
    public DataType getDataType() {
        DataType result = DataType.STRING;
        if (this.type.equals("Boolean")) {
            result = DataType.BOOLEAN;
        } else if (this.type.equals("Double")) {
            result = DataType.DOUBLE;
        } else if (this.type.equals("Integer")) {
            result = DataType.INTEGER;
        } else if (this.type.equals("Object")) {
            result = DataType.POJO;
        } else if (this.type.equals("String")) {
            result = DataType.STRING;
        } else if (this.type.equals("Date")) {
            result = DataType.DATE;
        } else if (this.type.equals("Time")) {
            result = DataType.DATE_TIME;
        } else if (this.type.equals("Datetime")) {
            result = DataType.DATE_TIME;
        } else if (this.type.equals("Decimal")) {
            result = DataType.DECIMAL;
        } else if (this.type.equals("Long")) {
            result = DataType.LONG;
        } else if (this.type.equals("Id")) {
            result = DataType.STRING;
        }
        return result;
    }
}

